<div class="form__wrapper">
    <form action="<?php echo e(route('login.post')); ?>" method="post" enctype="multipart/form-data" id="loginForm">
        <?php echo csrf_field(); ?>
        <div class="heading__content">
            <h2 class="title"><?php echo e(__('welcome_back!')); ?></h2>
            <p class="desc"><?php echo e(__('please_enter_your_details_to_sign_in')); ?></p>
        </div>
        <div class="instant__login">
            <?php echo e(__('continue_with')); ?>

            <div class="login__icon">
                <?php if(get_config('is_twilio_activated')): ?>
                    <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '<?php echo e(route('auth.phone')); ?>')"><i
                            class="ri-phone-fill"></i></a>
                <?php endif; ?>
                <a href="<?php echo e(route('auth.google')); ?>"><i class="ri-google-fill"></i></a>
                <a href="<?php echo e(route('auth.facebook')); ?>"><i class="ri-facebook-circle-fill"></i></a>
            </div>
        </div>
        <div class="devider text-center"><span><?php echo e(__('or')); ?></span></div>

        <div class="form-group">
            <label for="login-email">
                <?php echo e(__('email')); ?>

                <span class="required">*</span>
            </label>
            <input type="email" class="form-control" name="email" id="login-email"
                placeholder="<?php echo e(__('your_email')); ?>" />
            <span id="error-email"></span>
        </div>
        <div class="form-group">
            <label for="login-password">
                <?php echo e(__('password')); ?>

                <span class="required">*</span>
            </label>
            <input type="password" class="form-control" name="password" id="login-password"
                placeholder="<?php echo e(__('your_password')); ?>" />
            <span id="error-password"></span>
        </div>
        <div class="flex__input mb-20">
            <div class="custom__checkbox">
                <input type="checkbox" class="form-check-input" name="remember" id="login-policyCheck" />
                <label class="form-check-label" for="login-policyCheck"> <?php echo e(__('remember_me')); ?> </label>
            </div>
            <a href="javascript:void(0)" onclick="ajaxModal('modal-md', '<?php echo e(route('password.request')); ?>')"
                class="forget"><?php echo e(__('forgot_password?')); ?></a>
        </div>
        <?php if(get_config('is_recaptcha_activated') && get_config('recaptcha_site_key')): ?>
            <div class="mb-30">
                <div id="html_element" class="g-recaptcha" data-sitekey="<?php echo e(get_config('recaptcha_site_key')); ?>"></div>
            </div>
        <?php endif; ?>
        <div class="btn__group">
            <button type="button" onclick="ajaxLogin()" name="btn"
                class="btn btn-primary w-100"><?php echo e(__('sign_in')); ?></button>
        </div>
        <p class="account text-center">
            <?php echo e(__("don't_have_an_account?")); ?>

            <a href="javascript:void(0)" id="signUp" onclick="ajaxModal('modal-md', '<?php echo e(route('register')); ?>')">
                <?php echo e(__('sign_up')); ?></a>
        </p>
    </form>
</div><?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/auth/login.blade.php ENDPATH**/ ?>