<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
        $(document).on('click', '.generate-content', function(e) {
            e.preventDefault();

            let url = $(this).data('url');
            let targetId = $(this).data('id');
            let targetType = $(this).data('type');

            // Get the current title from the input field dynamically
            if (targetType == 'live_tv_description' || targetType == 'live_tv_meta_description') {
                var titleInput = $(this).closest('.crud-form').find('input[name="tv_name"]');
            } else {
                var titleInput = $(this).closest('.crud-form').find('input[name="title"]');
            }
            let targetTitle = titleInput.val(); // Get the current value

            // Store original button text
            const button = $(this);
            const originalText = button.find('span').html();
            if (!targetTitle) {
                toastr.error('<?php echo e(__('title_is_required')); ?>')
            } else {
                // Show loading text
                button.find('span').text('Loading...');
            }

            $.ajax({
                url: url,
                type: "GET",
                data: {
                    type: targetType,
                    title: targetTitle
                },
                success: function(response) {
                    //console.log(response);

                    let $target = $("#" + targetId);
                    if ($target.length === 0) return;

                    if (!targetTitle) {
                        $target.attr("placeholder", "<?php echo e(__('title_not_provided')); ?>");
                    } else {
                        // console.log(response.content);
                        if (response.content !== undefined) {
                            $target.val(response.content);
                        } else {
                            $target.val("<?php echo e(__('failed_to_load_content')); ?>");
                        }
                    }
                },
                error: function(xhr) {
                    let $target = $("#" + targetId);
                    if ($target.length === 0) return;

                    // Handle server errors
                    let msg = xhr.responseJSON.content;
                    if (xhr.responseJSON && xhr.responseJSON.content) {
                        msg = xhr.responseJSON.content;
                    }
                    $target.val(msg);
                },
                complete: function() {
                    // Restore original button text
                    button.find('span').html(originalText);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<script>
    "use strict";

    // modal open with ajax and custom view
    function ajaxModal(size, url, title = null) {
        $.ajax({
            url: url,
            type: "GET",
            data: {
                size: size
            },
            success: function(result) {
                // Handle the response (result)
                $("#ajaxModal").modal("show");
                // modal size
                $("#modalSize").addClass(size);
                $("#modalTitle").text(title);
                // show the view
                $("#modalContent").html(result);
            }
        });
    }


    function ajaxLogin() {
        // Clear previous errors
        $("#login-email, #login-password").removeClass('border border-danger');
        $("#error-email, #error-password").html('');

        // Get the values of the email and password fields
        var email = $("#login-email").val();
        var password = $("#login-password").val();

        // Basic client-side check for empty fields
        if (!email || !password) {
            if (!email) {
                $("#login-email").addClass('border border-danger');
                $("#error-email").html('<span class="text-danger fs-14px"><?php echo e(__('email_is_required')); ?></span>');
            }
            if (!password) {
                $("#login-password").addClass('border border-danger');
                $("#error-password").html('<span class="text-danger fs-14px"><?php echo e(__('password_is_required')); ?></span>');
            }
            return;
        }

        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        var formData = $("#loginForm").serialize();

        $.ajax({
            url: $("#loginForm").attr('action'),
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': csrfToken
            },
            data: formData,
            success: function(response) {
                // If login is successful
                if (response.success) {
                    window.location.href = response.redirect_url;
                    return;
                }

                // If controller returns validation errors
                if (response.errors) {
                    // Loop through each error and display it
                    $.each(response.errors, function(field, messages) {
                        var inputField = $("#login-" + field);
                        var errorDiv = $("#error-" + field);

                        inputField.addClass('border border-danger');
                        errorDiv.html('<span class="text-danger fs-14px">' + messages[0] +
                            '</span>');
                    });
                }

                // Optional: handle other custom response messages
                if (response.message) {
                    $("#login-password").addClass('border border-danger');
                    $("#error-password").html(
                        '<span class="text-danger fs-14px"><?php echo e(__('Wrong password')); ?></span>');
                }
            },
            error: function(xhr) {
                if (xhr.status === 422) {
                    var errors = xhr.responseJSON.errors;
                    $.each(errors, function(field, messages) {
                        $("#login-" + field).addClass('border border-danger');
                        $("#error-" + field).html('<span class="text-danger fs-14px">' + messages[
                            0] + '</span>');
                    });
                }
            }
        });
    }


    function ajaxSignUp() {}
</script>
<?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/layouts/script.blade.php ENDPATH**/ ?>