<form action="<?php echo e(route('admin.api.key.store')); ?>" method="post" enctype="multipart/form-data" class="form-validate form">
    <?php echo csrf_field(); ?>
    <div class="mb-2">
        <label for="title" class="form-label"> <?php echo e(__('title')); ?> <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="title" name="title" value="<?php echo e(old('title')); ?>"
            placeholder="<?php echo e(__('api_title')); ?>">
        <div class="nk-block-des text-danger">
            <p class="error"><?php echo e($errors->first('title')); ?></p>
        </div>
    </div>
    <!-- API Key Field -->
    <div class="mb-2">
        <label for="api_key" class="form-label"> <?php echo e(__('api_key')); ?> <span class="text-danger">*</span> </label>
        <div class="input-group">
            <input type="text" class="form-control rounded-start" id="api_key" name="api_key"
                value="<?php echo e(old('api_key', Str::random(16))); ?>" readonly>
            <button type="button" class="btn btn-outline-secondary" id="generateKey"> <i
                    class="las la-redo-alt"></i></button>
        </div>
        <div class="nk-block-des text-danger">
            <p class="error"><?php echo e($errors->first('api_key')); ?></p>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary"><?php echo e(__('submit')); ?></button>
    <?php echo $__env->make('layouts.loading_button', ['class' => 'btn sg-btn-primary'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</form>
<script>
    "use strict";

    document.getElementById('generateKey').addEventListener('click', function() {
        const length = 16;
        const charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        let randomKey = "";
        const randomValues = crypto.getRandomValues(new Uint32Array(length));

        for (let i = 0; i < length; i++) {
            randomKey += charset[randomValues[i] % charset.length];
        }

        document.getElementById('api_key').value = randomKey;
    });
</script>
<?php /**PATH /home/savadata/check.belovevn.com/public/resources/views/admin/settings/mobile_api/add.blade.php ENDPATH**/ ?>