@extends('website.layouts.master')
@section('title', __('series_details'))
@section('content')

    <!-- All Section Wrapper Start -->
    <section class="rentVideo__section"
        style="background: url('{{ getFileLink('poster', $series->poster, 'movies', '1920x1080', 'original') }}')">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="rentVideo__wrapper">
                        <div class="hero__text text-start">
                            <div class="video__meta">
                                <div class="meta__item"><i class="ri-star-fill"></i>{{ get_rating($series->imdb_rating) }}
                                </div>
                                <div class="meta__item"><i class="ri-time-fill"></i>
                                    {{ runtime($series->runtime) }} </div>
                                <div class="meta__item"><i
                                        class="ri-calendar-2-fill"></i>{{ date('Y', strtotime($series->release)) }}
                                </div>
                            </div>

                            <div class="video__tag d-flex">
                                <span>{{ get_video_quality($series->video_quality, 'quality') }}</span>
                                <span>{{ get_genre($series->genre, 0, 'name') }}</span>
                                @if ($series->video_type)
                                    <span> {{ get_video_type($series->video_type, 'video_type') }} </span>
                                @endif
                                @if ($series->is_blockbuster)
                                    <span> {{ __('block_buster') }} </span>
                                @endif
                            </div>
                            <h1 class="title"> {{ $series->title }} </h1>
                            <p class="desc">
                                {{ $series->description }}
                            </p>

                            <div class="btn__group justify-content-start flex-wrap">
                                @if (
                                    (is_rent_expire('series', $series->id) && is_rental('series', $series->id)) ||
                                        is_free('series', $series->id) ||
                                        (check_subscription() && !is_rental('series', $series->id)) ||
                                        is_admin())
                                    @if (get_episode_slug($series->id))
                                        <a href="{{ route('watch.episode', ['slug' => get_episode_slug($series->id)]) }}"
                                            class="btn btn-primary"> {{ __('watch_now') }} </a>
                                    @endif
                                @else
                                    @if (auth()->user() && !is_free('series', $series->id) && is_rental('series', $series->id))
                                        <a class="btn btn-primary" href="javascript:void(0)"
                                            onclick="ajaxModal('modal-md', '{{ route('payment.gateway.list', ['id' => $series->id, 'type' => 'rental', 'video_type' => 'series']) }}')">
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                    fill="white"></path>
                                            </svg>
                                            <span> {{ __('rent') . ' ' . get_currency($series->rental_price) }} </span>
                                        </a>
                                    @elseif (!auth()->user() && is_rental('series', $series->id))
                                        <a class="btn btn-white active" href="javascript:void(0)"
                                            onclick="ajaxModal('modal-md', '{{ route('login') }}')">
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                    fill="white"></path>
                                            </svg>
                                            <span> {{ __('rent') . ' ' . get_currency($series->rental_price) }} </span>
                                        </a>
                                    @else
                                        <a href="{{ route('packages') }}" class="btn btn-primary">
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M15.1773 2.04376C14.9337 1.94228 14.6654 1.91561 14.4066 1.96713C14.1478 2.01866 13.9102 2.14605 13.724 2.33309L12 4.05709L8.94267 0.999757C8.69263 0.749796 8.35355 0.609375 8 0.609375C7.64645 0.609375 7.30737 0.749796 7.05733 0.999757L4 4.05709L2.276 2.33309C2.08953 2.14668 1.85198 2.01974 1.59338 1.96831C1.33477 1.91689 1.06673 1.94329 0.823127 2.04419C0.579528 2.14508 0.37131 2.31593 0.224798 2.53515C0.0782854 2.75436 5.62991e-05 3.01209 0 3.27576L0 10.3331C0.00105857 11.2168 0.352588 12.0641 0.97748 12.6889C1.60237 13.3138 2.4496 13.6654 3.33333 13.6664H12.6667C13.5504 13.6654 14.3976 13.3138 15.0225 12.6889C15.6474 12.0641 15.9989 11.2168 16 10.3331V3.27576C16.0001 3.01207 15.9219 2.75428 15.7755 2.53499C15.6291 2.3157 15.4209 2.14475 15.1773 2.04376ZM14.6667 10.3331C14.6667 10.8635 14.456 11.3722 14.0809 11.7473C13.7058 12.1224 13.1971 12.3331 12.6667 12.3331H3.33333C2.8029 12.3331 2.29419 12.1224 1.91912 11.7473C1.54405 11.3722 1.33333 10.8635 1.33333 10.3331V3.27576L3.52867 5.47109C3.65369 5.59607 3.82322 5.66628 4 5.66628C4.17678 5.66628 4.34631 5.59607 4.47133 5.47109L8 1.94242L11.5287 5.47109C11.6537 5.59607 11.8232 5.66628 12 5.66628C12.1768 5.66628 12.3463 5.59607 12.4713 5.47109L14.6667 3.27576V10.3331Z"
                                                    fill="white"></path>
                                            </svg>
                                            <span>{{ __('subscribe') }}</span>
                                        </a>
                                    @endif
                                @endif

                                <div class="movieDetails__info d-block m-0">
                                    <div class="action__area mt-0 justify-content-lg-end">
                                        <a href="javascript:void(0)"
                                            class="favorite-toggle-btn @if ($series->isFavoritedByLoggedInUser()) marked @endif"
                                            data-id="{{ $series->id }}" data-type="tv_show" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" title="{{ __('favorite') }}">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_930_3283)">
                                                    <path
                                                        d="M11.667 1.27783C10.9163 1.28951 10.1819 1.49907 9.53814 1.88535C8.89434 2.27162 8.36387 2.82094 8.0003 3.47783C7.63672 2.82094 7.10625 2.27162 6.46246 1.88535C5.81866 1.49907 5.08433 1.28951 4.33363 1.27783C3.13692 1.32983 2.00944 1.85333 1.19749 2.73399C0.385537 3.61464 -0.0448693 4.78085 0.000297715 5.97783C0.000297715 9.00917 3.19096 12.3198 5.86696 14.5645C6.46444 15.0666 7.21987 15.3418 8.0003 15.3418C8.78073 15.3418 9.53615 15.0666 10.1336 14.5645C12.8096 12.3198 16.0003 9.00917 16.0003 5.97783C16.0455 4.78085 15.6151 3.61464 14.8031 2.73399C13.9912 1.85333 12.8637 1.32983 11.667 1.27783ZM9.27696 13.5445C8.91962 13.8454 8.46747 14.0104 8.0003 14.0104C7.53313 14.0104 7.08098 13.8454 6.72363 13.5445C3.2983 10.6705 1.33363 7.91317 1.33363 5.97783C1.28806 5.13431 1.57788 4.30699 2.13987 3.6763C2.70187 3.04561 3.49045 2.66273 4.33363 2.61117C5.17681 2.66273 5.96539 3.04561 6.52739 3.6763C7.08939 4.30699 7.3792 5.13431 7.33363 5.97783C7.33363 6.15464 7.40387 6.32421 7.52889 6.44924C7.65392 6.57426 7.82349 6.6445 8.0003 6.6445C8.17711 6.6445 8.34668 6.57426 8.4717 6.44924C8.59673 6.32421 8.66696 6.15464 8.66696 5.97783C8.62139 5.13431 8.91121 4.30699 9.47321 3.6763C10.0352 3.04561 10.8238 2.66273 11.667 2.61117C12.5101 2.66273 13.2987 3.04561 13.8607 3.6763C14.4227 4.30699 14.7125 5.13431 14.667 5.97783C14.667 7.91317 12.7023 10.6705 9.27696 13.5418V13.5445Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>

                                        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-placement="bottom"
                                            data-url="{{ route('series.details', ['slug' => $series->slug]) }}"
                                            data-bs-target="#shareModal" title="{{ __('share') }}" class="share-btn">
                                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_892_4790)">
                                                    <path
                                                        d="M12.8888 9.77816C12.3847 9.77858 11.8883 9.90163 11.4425 10.1367C10.9966 10.3718 10.6146 10.7118 10.3295 11.1275L5.99012 9.16817C6.29833 8.42392 6.29952 7.58796 5.99345 6.84283L10.3268 4.8735C10.7494 5.48467 11.377 5.92414 12.0958 6.1122C12.8147 6.30025 13.5771 6.22443 14.2449 5.8985C14.9126 5.57256 15.4414 5.0181 15.7353 4.33568C16.0293 3.65325 16.0689 2.88808 15.847 2.17895C15.6251 1.46982 15.1564 0.863696 14.5259 0.470535C13.8954 0.0773743 13.1449 -0.0767867 12.4105 0.0360157C11.6761 0.148818 11.0064 0.521112 10.5229 1.08537C10.0395 1.64962 9.7743 2.36846 9.77545 3.1115C9.77828 3.28736 9.79612 3.46267 9.82878 3.6355L5.22212 5.72883C4.77968 5.31431 4.22579 5.03806 3.6285 4.93401C3.03121 4.82996 2.41654 4.90264 1.85999 5.14314C1.30344 5.38363 0.829268 5.78146 0.495715 6.28774C0.162163 6.79402 -0.0162385 7.38671 -0.0175706 7.993C-0.0189027 8.59928 0.156892 9.19275 0.488217 9.70049C0.819542 10.2082 1.29197 10.6081 1.84745 10.8511C2.40293 11.094 3.01728 11.1694 3.61502 11.068C4.21276 10.9666 4.76786 10.6927 5.21212 10.2802L9.83078 12.3655C9.7987 12.5382 9.78109 12.7132 9.77812 12.8888C9.77799 13.5043 9.96037 14.1059 10.3022 14.6176C10.644 15.1294 11.1299 15.5283 11.6985 15.7639C12.267 15.9994 12.8927 16.0611 13.4963 15.9411C14.0999 15.8211 14.6543 15.5247 15.0895 15.0895C15.5247 14.6544 15.821 14.0999 15.941 13.4963C16.0611 12.8927 15.9994 12.2671 15.7638 11.6985C15.5282 11.13 15.1294 10.6441 14.6176 10.3022C14.1058 9.96041 13.5042 9.77803 12.8888 9.77816ZM12.8888 1.3335C13.2405 1.33337 13.5843 1.43753 13.8768 1.63282C14.1692 1.82811 14.3972 2.10575 14.5319 2.43063C14.6666 2.7555 14.7019 3.11302 14.6334 3.45796C14.5648 3.8029 14.3956 4.11977 14.1469 4.3685C13.8983 4.61722 13.5815 4.78663 13.2366 4.85529C12.8917 4.92394 12.5341 4.88877 12.2092 4.75422C11.8843 4.61967 11.6065 4.39178 11.4111 4.09937C11.2157 3.80697 11.1115 3.46318 11.1115 3.1115C11.1118 2.64017 11.2992 2.18823 11.6324 1.85489C11.9656 1.52154 12.4175 1.33403 12.8888 1.3335ZM3.11145 9.77816C2.75977 9.7783 2.41594 9.67413 2.12347 9.47884C1.83099 9.28355 1.60299 9.00591 1.46832 8.68104C1.33364 8.35616 1.29834 7.99865 1.36687 7.6537C1.4354 7.30876 1.60468 6.99189 1.85331 6.74317C2.10194 6.49444 2.41875 6.32504 2.76367 6.25638C3.10859 6.18772 3.46612 6.22289 3.79104 6.35744C4.11597 6.492 4.39369 6.71989 4.58909 7.01229C4.78449 7.3047 4.88878 7.64848 4.88878 8.00016C4.88826 8.47144 4.70085 8.92327 4.36767 9.25658C4.03449 9.58989 3.58273 9.77746 3.11145 9.77816ZM12.8888 14.6668C12.5371 14.6668 12.1934 14.5626 11.901 14.3672C11.6086 14.1718 11.3807 13.8941 11.2461 13.5692C11.1116 13.2444 11.0763 12.8869 11.1449 12.542C11.2136 12.1971 11.3829 11.8803 11.6315 11.6316C11.8802 11.3829 12.197 11.2136 12.5419 11.145C12.8868 11.0764 13.2443 11.1116 13.5692 11.2462C13.8941 11.3807 14.1718 11.6086 14.3671 11.901C14.5625 12.1934 14.6668 12.5372 14.6668 12.8888C14.6664 13.3603 14.479 13.8123 14.1456 14.1457C13.8123 14.479 13.3602 14.6665 12.8888 14.6668Z"
                                                        fill="white" />
                                                </g>
                                            </svg>
                                        </a>
                                        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#reportModal"
                                            title="{{ __('report_movie') }}" class="report-btn"
                                            data-id="{{ $series->id }}" data-type="{{ get_class($series) }}">
                                            <svg xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1"
                                                viewBox="0 0 24 24" width="512" height="512">
                                                <path
                                                    d="M20.358,7.5l3.237-4.297c.459-.609,.533-1.413,.192-2.096s-1.026-1.107-1.79-1.107H4C1.794,0,0,1.794,0,4V23c0,.553,.448,1,1,1s1-.447,1-1V15H21.998c.764,0,1.449-.425,1.79-1.107s.267-1.486-.192-2.096l-3.237-4.297ZM2,13V4c0-1.103,.897-2,2-2H21.998l-3.69,4.898c-.268,.356-.268,.847,0,1.203l3.69,4.898H2Z" />
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6">
                    <div class="rentsVideo__thumb">
                        <img class=" m-auto"
                            src="{{ getFileLink('thumbnail', $series->thumbnail, 'movies', '500x750', 'w500') }}"
                            alt="{{__('image')}}">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="movieDetails__section pt-100 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="movieDetails__wrapper">
                        <div class="movieDetails__inner">
                            @include('website.component.ads_middle_of_details')
                            <!-- Playlist Area Start -->

                            @foreach (get_season($series->id) as $key => $season)
                                <div class="playlist__area mb-4">
                                    <div class="flex__area">
                                        <div class="playlist__meta">
                                            <h4 class="title"> {{ $season->season_name }} </h4>
                                            <div class="meta">
                                                <span><i class="ri-lock-line"></i>{{ __('privet') }}</span>
                                                <span><i
                                                        class="ri-play-large-line"></i>{{ count(get_episode_by_season($series->id)) }}
                                                    {{ __('videos') }}</span>
                                            </div>
                                        </div>
                                        <button class="collapse__btn">
                                            @if ($key == 0)
                                                <i class="ri-subtract-line"></i>
                                            @else
                                                <i class="ri-add-line"></i>
                                            @endif
                                        </button>
                                    </div>
                                    <div class="playlist__single">
                                        <div class="playlist__overflow">

                                            <!-- Video List -->
                                            @foreach (get_episode_by_season($series->id) as $episode)
                                                <div class="videolist">
                                                    <div class="thumb">
                                                        <img src="{{ getFileLink('poster', $episode->poster, 'episodes', '500x250') }}"
                                                            alt="{{__('image')}}" />
                                                        <div class="overlay">
                                                            <button><i class="ri-play-large-line"></i></button>
                                                        </div>
                                                    </div>
                                                    <div class="content">
                                                        <h5>{{ __('added') . ' ' . $episode->created_at->diffForHumans() }}
                                                        </h5>
                                                        <h4 class="title">
                                                            <a
                                                                href="{{ route('watch.episode', ['slug' => $episode->slug]) }}">
                                                                {{ $episode->episode_name }} </a>
                                                        </h4>
                                                        <span>
                                                            {{ (episode_view($episode->id) ?? '0') . ' ' . __('views') }}</span>
                                                    </div>

                                                </div>
                                            @endforeach

                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <!-- Playlist Area End -->

                            <div class="video__content mt-50">
                                <!-- Tab Header -->
                                <div class="tabHeader">
                                    <h4 class="title">{{ __('series_details') }}</h4>
                                    <div class="tablist">
                                        <div class="custom__tabs text-center">
                                            <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link active" id="cast-tab" data-bs-toggle="pill"
                                                        data-bs-target="#cast" type="button" role="tab"
                                                        aria-controls="cast" aria-selected="false" tabindex="-1">
                                                        {{ __('cast') }}
                                                    </button>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link" id="director-tab" data-bs-toggle="pill"
                                                        data-bs-target="#director" type="button" role="tab"
                                                        aria-controls="director" aria-selected="false" tabindex="-1">
                                                        {{ __('director') }}
                                                    </button>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link" id="writer-tab" data-bs-toggle="pill"
                                                        data-bs-target="#writer" type="button" role="tab"
                                                        aria-controls="writer" aria-selected="false" tabindex="-1">
                                                        {{ __('write') }}
                                                    </button>
                                                </li>
                                                <li class="nav-item" role="presentation">
                                                    <button class="nav-link" id="review-tab" data-bs-toggle="pill"
                                                        data-bs-target="#review" type="button" role="tab"
                                                        aria-controls="review" aria-selected="false" tabindex="-1">
                                                        {{ __('review_&_ratings') }}
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tab Content Start -->
                                <div class="tab-content pb-5">
                                    <div class="tab-pane fade active show" id="cast" role="tabpanel">
                                        <!-- Actress Wrapper -->
                                        <div class="actress__wrapper">
                                            <div class="row">
                                                @foreach (json_decode($series->stars) as $star)
                                                    <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 pb-4">
                                                        <!-- Acctress Item -->
                                                        <div class="actressItem">
                                                            <div class="thumb">
                                                                <img src="{{ get_star($star, 'star_image') }}"
                                                                    alt="thumb" />
                                                            </div>
                                                            <div class="content">
                                                                <h4 class="title"> {{ get_star($star, 'star_name') }}
                                                                </h4>
                                                                <span class="designation">
                                                                    {{ get_star($star, 'star_type') }}
                                                                </span>
                                                                <div class="social__icon">
                                                                    @if (get_star($star, 'facebook'))
                                                                        <a href="{{ get_star($star, 'facebook') }}"
                                                                            target="_blank"><i
                                                                                class="ri-facebook-fill"></i></a>
                                                                    @endif
                                                                    @if (get_star($star, 'twitter'))
                                                                        <a href="{{ get_star($star, 'twitter') }}"
                                                                            target="_blank"><i
                                                                                class="ri-twitter-x-line"></i></a>
                                                                    @endif
                                                                    @if (get_star($star, 'instagram'))
                                                                        <a href="{{ get_star($star, 'instagram') }}"
                                                                            target="_blank"><i
                                                                                class="ri-instagram-line"></i></a>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Acctress Item -->
                                                    </div>
                                                @endforeach

                                            </div>
                                        </div>
                                        <!-- Actress Wrapper -->
                                    </div>
                                    <div class="tab-pane fade" id="director" role="tabpanel">
                                        <!-- Actress Wrapper -->
                                        <div class="actress__wrapper">
                                            <div class="row">
                                                @foreach (json_decode($series->director) as $director)
                                                    <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 pb-4">
                                                        <!-- Acctress Item -->
                                                        <div class="actressItem">
                                                            <div class="thumb">
                                                                <img src="{{ get_star($director, 'star_image') }}"
                                                                    alt="thumb" />
                                                            </div>
                                                            <div class="content">
                                                                <h4 class="title">{{ get_star($director, 'star_name') }}
                                                                </h4>
                                                                <span
                                                                    class="designation">{{ get_star($director, 'star_type') }}</span>
                                                                <div class="social__icon">
                                                                    @if (get_star($director, 'facebook'))
                                                                        <a href="{{ get_star($director, 'facebook') }}"
                                                                            target="_blank"><i
                                                                                class="ri-facebook-fill"></i></a>
                                                                    @endif
                                                                    @if (get_star($director, 'twitter'))
                                                                        <a href="{{ get_star($director, 'twitter') }}"
                                                                            target="_blank"><i
                                                                                class="ri-twitter-x-line"></i></a>
                                                                    @endif
                                                                    @if (get_star($director, 'instagram'))
                                                                        <a href="{{ get_star($director, 'instagram') }}"
                                                                            target="_blank"><i
                                                                                class="ri-instagram-line"></i></a>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Acctress Item -->
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <!-- Actress Wrapper -->
                                    </div>
                                    <div class="tab-pane fade" id="writer" role="tabpanel">
                                        <!-- Actress Wrapper -->
                                        <div class="actress__wrapper">
                                            <div class="row">
                                                @foreach (json_decode($series->writer) as $writer)
                                                    <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 pb-4">
                                                        <!-- Acctress Item -->
                                                        <div class="actressItem">
                                                            <div class="thumb">
                                                                <img src="{{ get_star($writer, 'star_image') }}"
                                                                    alt="thumb" />
                                                            </div>
                                                            <div class="content">
                                                                <h4 class="title">{{ get_star($writer, 'star_name') }}
                                                                </h4>
                                                                <span
                                                                    class="designation">{{ get_star($writer, 'star_type') }}</span>
                                                                <div class="social__icon">
                                                                    @if (get_star($writer, 'facebook'))
                                                                        <a href="{{ get_star($writer, 'facebook') }}"
                                                                            target="_blank"><i
                                                                                class="ri-facebook-fill"></i></a>
                                                                    @endif
                                                                    @if (get_star($writer, 'twitter'))
                                                                        <a href="{{ get_star($writer, 'twitter') }}"
                                                                            target="_blank"><i
                                                                                class="ri-twitter-x-line"></i></a>
                                                                    @endif
                                                                    @if (get_star($writer, 'instagram'))
                                                                        <a href="{{ get_star($writer, 'instagram') }}"
                                                                            target="_blank"><i
                                                                                class="ri-instagram-line"></i></a>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- Acctress Item -->
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <!-- Actress Wrapper -->
                                    </div>
                                    <div class="tab-pane fade" id="review" role="tabpanel">
                                        <!-- Single Wrapper -->
                                        <div class="blogSingle__wrapper">
                                            <!-- Related Blog Post -->
                                            @if (!auth()->user()?->hasReviewed($series))
                                                <form action="{{ route('review.store.tvshow', $series->id) }}"
                                                    method="POST" class="all__comments">
                                                    @csrf
                                                    <input type="hidden" name="reviewable_id"
                                                        value="{{ $series->id }}">
                                                    <input type="hidden" name="rating" id="rating-value"
                                                        value="">

                                                    <div class="commentsRating">
                                                        <h5 class="comments">{{ count($series->reviews) }}
                                                            {{ __('reviews') }}
                                                        </h5>
                                                        <div class="rating__inline">
                                                            <span class="title">{{ __('submit_rating') }} :</span>
                                                            <div class="rating" id="star-rating">
                                                                @for ($i = 1; $i <= 10; $i++)
                                                                    <a href="javascript:void(0)"
                                                                        data-value="{{ $i }}"><i
                                                                            class="ri-star-line"></i></a>
                                                                @endfor
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="form-group">
                                                        <textarea name="review" class="form-control" cols="30" rows="8" placeholder="Write Something"></textarea>
                                                    </div>

                                                    <div class="submit-btn">
                                                        <button type="submit"
                                                            class="btn btn-primary">{{ __('post') }}</button>
                                                    </div>
                                                </form>
                                            @endif
                                            <div class="clients__review">
                                                <!-- <h4 class="review__title">People Comments (03)</h4> -->
                                                <div class="review__wrapper">
                                                    @foreach ($series->reviews as $review)
                                                        <div class="review__item">
                                                            <div class="d-flex justify-content-between">
                                                                <div class="d-flex align-items-center gap-4">
                                                                    <div class="avatar">
                                                                        <img src="{{ getFileLink('user', $review->user->image, 'users', '80x80') }}"
                                                                            alt="avatar" />
                                                                    </div>
                                                                    <div class="review__content">
                                                                        <h5>{{ $review->user->first_name . ' ' . $review->user->last_name }}
                                                                        </h5>
                                                                        <span>{{ $review->created_at->format('d F, Y') }}</span>
                                                                    </div>
                                                                </div>
                                                                <div>
                                                                    @php
                                                                        $filled = $review->rating;
                                                                        $empty = 10 - $filled;
                                                                    @endphp

                                                                    <span class="text-white">
                                                                        <strong>{{ __('ratings') }}: </strong>
                                                                        {!! str_repeat('★', $filled) !!}{!! str_repeat('☆', $empty) !!}
                                                                    </span>

                                                                </div>
                                                            </div>
                                                            <p class="desc">
                                                                {{ $review->review }}
                                                            </p>

                                                            @if ($review->reply)
                                                                <div class="sub__replay">
                                                                    <div class="replay">
                                                                        <a href="javascript:void(0)"><i
                                                                                class="ri-corner-left-up-line"></i>{{ __('reply') }}</a>
                                                                    </div>
                                                                    <div class="review__item">
                                                                        <div class="d-flex align-items-center gap-4">
                                                                            <div class="avatar">
                                                                                <img src="{{ getFileLink('original_image', get_config('favicon'), 'favicons', '96x96') }}"
                                                                                    alt="avatar" />
                                                                            </div>
                                                                            <div class="review__content">
                                                                                <h5>{{ __('admin') }}</h5>
                                                                                <span>{{ $review->updated_at->format('d F, Y') }}</span>
                                                                            </div>
                                                                        </div>
                                                                        <p class="desc">
                                                                            {{ $review->reply }}
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            @endif

                                                            <!-- Reaction meta -->
                                                            <div class="reaction__meta">
                                                                <a href="javascript:void(0)"
                                                                    class="avarage__reaction like-btn"
                                                                    data-review-id="{{ $review->id }}"
                                                                    data-liked="{{ auth()->check() && $review->isLikedBy(auth()->user()) ? '1' : '0' }}">
                                                                    @if (auth()->check() && $review->isLikedBy(auth()->user()))
                                                                        <i class="ri-thumb-up-fill text-primary"></i>
                                                                    @else
                                                                        <i class="ri-thumb-up-line"></i>
                                                                    @endif
                                                                    <span
                                                                        class="like-count">{{ $review->likes()->count() }}</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Single Wrapper -->
                                    </div>
                                </div>

                                <!-- Relared Section Start -->
                                <div class="related__section mb-40 mt-30">
                                    <div class="section__title">
                                        <h2 class="title"> {{ __('related_series') }} </h2>
                                    </div>
                                    <div class="position-relative">
                                        <div class="swiper relatedmovie__slider">
                                            <div class="swiper-wrapper">
                                                @foreach ($related_series as $series)
                                                    <!-- Slide -->
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $series->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                            @if ($series->is_free == 1)
                                                            @elseif ($series->is_rental == 1)
                                                                <div class="badge bg-purple">
                                                                    {{ __('rent:') . ' ' . get_currency($series->rental_price) }}
                                                                </div>
                                                            @else
                                                                <div class="badge"> {{ __('premium') }} </div>
                                                            @endif
                                                            <div class="video__content">
                                                                <div class="content__left">
                                                                    <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                        class="title">{{ $series->title }}</a>
                                                                    <div class="video__meta">
                                                                        <div class="meta__item">
                                                                            {{ date('Y', strtotime($series->release)) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ get_rating($series->imdb_rating) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ runtime($series->runtime) }}</div>
                                                                    </div>
                                                                    <div class="video__tag">
                                                                        <span>{{ get_movie_genre($series->genre) }}</span>
                                                                        @if (get_movie_category($series->video_type))
                                                                            <span>{{ get_movie_category($series->video_type) }}</span>
                                                                        @endif
                                                                        <span>{{ get_movie_quality($series->video_quality) }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="content__right">
                                                                    <div class="action__btn">
                                                                        <a href="javascript:void(0)"
                                                                            class="share__btn share-btn"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-placement="bottom"
                                                                            data-url="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                            data-bs-target="#shareModal"
                                                                            title="{{ __('share') }}">
                                                                            <i class="ri-share-line"></i></a>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="related-movie-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="related-movie-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Related Section End -->

                                <!-- Recommended Section Start -->
                                <div class="recommended__section mb-40">
                                    <div class="section__title">
                                        <h2 class="title">{{ __('recommended_for_you') }}</h2>
                                        <div class="view__btn">
                                            <a
                                                href="{{ route('all.tv.series', ['type' => 'recommended']) }}">{{ __('view_all') }}</a>
                                        </div>
                                    </div>
                                    <div class="position-relative">
                                        <div class="swiper recommendedmovie__slider">
                                            <div class="swiper-wrapper">
                                                @foreach ($recommended_series as $series)
                                                    <!-- Slide -->
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $series->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                            @if ($series->is_free == 1)
                                                            @elseif ($series->is_rental == 1)
                                                                <div class="badge bg-purple">
                                                                    {{ __('rent:') . ' ' . get_currency($series->rental_price) }}
                                                                </div>
                                                            @else
                                                                <div class="badge"> {{ __('premium') }} </div>
                                                            @endif
                                                            <div class="video__content">
                                                                <div class="content__left">
                                                                    <a href="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                        class="title">{{ $series->title }}</a>
                                                                    <div class="video__meta">
                                                                        <div class="meta__item">
                                                                            {{ date('Y', strtotime($series->release)) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ get_rating($series->imdb_rating) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ runtime($series->runtime) }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="video__tag">
                                                                        <span>{{ get_movie_genre($series->genre) }}</span>
                                                                        @if (get_movie_category($series->video_type))
                                                                            <span>{{ get_movie_category($series->video_type) }}</span>
                                                                        @endif
                                                                        <span>{{ get_movie_quality($series->video_quality) }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="content__right">
                                                                    <div class="action__btn">
                                                                        <a href="javascript:void(0)"
                                                                            class="share__btn share-btn"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-placement="bottom"
                                                                            data-url="{{ route('series.details', ['slug' => $series->slug]) }}"
                                                                            data-bs-target="#shareModal"
                                                                            title="{{ __('share') }}"><i
                                                                                class="ri-share-line"></i></a>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="recommended-movie-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="recommended-movie-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Recommended Section End -->
                            </div>
                        </div>
                        <div class="ads__wrapper">
                            @include('website.component.ads_sidebar')
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- All Section Wrapper End -->
    </section>
@endsection
@include('website.component.like_review')
@push('js')
    <script>
        "use strict";

        function serverLink(type, url, el, poster = '') {

            document.querySelectorAll('#server-buttons .btn').forEach(btn => btn.classList.remove('active'));
            el.classList.add('active');
            console.log('Server Link Type:', type, 'URL:', url, 'Poster:', poster);
            const container = document.getElementById('player-container');
            container.innerHTML = '<div class="text-center py-4">Loading...</div>';

            const loadPlayerUrl = "{{ route('load.player') }}";

            const data = {
                video_type: 'movie',
                video_id: {{ $series->id }},
                video_url: url,
                type: type,
                poster: poster,
                playlistId: 0,
                videoId: 0
            };

            $.ajax({
                url: loadPlayerUrl,
                type: 'POST',
                data: JSON.stringify(data),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(html) {
                    container.innerHTML = html;
                    const randomInstanceName = 'player_' + Math.random().toString(36).substring(2, 10);
                    const player = new FWDUVPlayer({
                        //main settings
                        instanceName: randomInstanceName,
                        parentId: "myDiv",
                        playlistsId: "playlists",
                        mainFolderPath: "{{ static_asset('website/player/content/') }}",
                        skinPath: "minimal_skin_dark",
                        displayType: "responsive",
                        initializeOnlyWhenVisible: "no",
                        useVectorIcons: "yes",
                        fillEntireVideoScreen: "no",
                        fillEntireposterScreen: "yes",
                        goFullScreenOnButtonPlay: "no",
                        playsinline: "yes",
                        privateVideoPassword: "428c841430ea18a70f7b06525d4b748a",
                        youtubeAPIKey: "{{ get_config('google_api_key') }}",
                        useHEXColorsForSkin: "no",
                        normalHEXButtonsColor: "#FF0000",
                        useDeepLinking: "yes",
                        googleAnalyticsMeasurementId: "G-842HPC3W6L",
                        useResumeOnPlay: "no",
                        showPreloader: "yes",
                        preloaderBackgroundColor: "#000000",
                        preloaderFillColor: "#FFFFFF",
                        addKeyboardSupport: "yes",
                        autoScale: "yes",
                        showButtonsToolTip: "yes",
                        stopVideoWhenPlayComplete: "no",
                        playAfterVideoStop: "no",
                        autoPlay: "no",
                        autoPlayText: "Click To Unmute",
                        loop: "no",
                        shuffle: "no",
                        showErrorInfo: "yes",
                        maxWidth: 1300,
                        maxHeight: 700,
                        buttonsToolTipHideDelay: 1.5,
                        volume: .03,
                        rewindTime: 10,
                        backgroundColor: "#000000",
                        videoBackgroundColor: "#000000",
                        posterBackgroundColor: "#000000",
                        buttonsToolTipFontColor: "#5a5a5a",
                        //logo settings
                        showLogo: "yes",
                        logoPath: "{{ getFileLink('original_image', get_config('player_logo'), 'player_logos', '130x50') }}",
                        hideLogoWithController: "yes",
                        logoPosition: "topRight",
                        logoLink: "{{ route('home') }}",
                        logoTarget: '_blank',
                        logoMargins: 10,

                        //playlists/categories settings
                        showPlaylistsSearchInput: "no",
                        usePlaylistsSelectBox: "yes",
                        showPlaylistsButtonAndPlaylists: "no",
                        showPlaylistsByDefault: "no",
                        thumbnailSelectedType: "opacity",
                        startAtPlaylist: 0,
                        buttonsMargins: 15,
                        thumbnailMaxWidth: 350,
                        thumbnailMaxHeight: 350,
                        horizontalSpaceBetweenThumbnails: 40,
                        verticalSpaceBetweenThumbnails: 40,
                        inputBackgroundColor: "#333333",
                        inputColor: "#999999",
                        //playlist settings
                        showPlaylistButtonAndPlaylist: "no",
                        playlistPosition: "right",
                        showPlaylistByDefault: "no",
                        showPlaylistName: "no",
                        showSearchInput: "no",
                        showLoopButton: "no",
                        showShuffleButton: "no",
                        showPlaylistOnFullScreen: "no",
                        showNextAndPrevButtons: "no",
                        showThumbnail: "no",
                        showOnlyThumbnail: "no",
                        forceDisableDownloadButtonForFolder: "no",
                        addMouseWheelSupport: "no",
                        startAtRandomVideo: "no",
                        stopAfterLastVideoHasPlayed: "no",
                        addScrollOnMouseMove: "no",
                        randomizePlaylist: 'no',
                        folderVideoLabel: "VIDEO ",
                        playlistRightWidth: 310,
                        playlistBottomHeight: 380,
                        startAtVideo: 0,
                        maxPlaylistItems: 50,
                        thumbnailWidth: 71,
                        thumbnailHeight: 71,
                        spaceBetweenControllerAndPlaylist: 1,
                        spaceBetweenThumbnails: 1,
                        scrollbarOffestWidth: 8,
                        scollbarSpeedSensitivity: .5,
                        playlistBackgroundColor: "#000000",
                        playlistNameColor: "#FFFFFF",
                        thumbnailNormalBackgroundColor: "#1b1b1b",
                        thumbnailHoverBackgroundColor: "#313131",
                        thumbnailDisabledBackgroundColor: "#272727",
                        searchInputBackgroundColor: "#000000",
                        searchInputColor: "#999999",
                        youtubeAndFolderVideoTitleColor: "#FFFFFF",
                        folderAudioSecondTitleColor: "#999999",
                        youtubeOwnerColor: "#888888",
                        youtubeDescriptionColor: "#888888",
                        mainSelectorBackgroundSelectedColor: "#FFFFFF",
                        mainSelectorTextNormalColor: "#FFFFFF",
                        mainSelectorTextSelectedColor: "#000000",
                        mainButtonBackgroundNormalColor: "#212021",
                        mainButtonBackgroundSelectedColor: "#FFFFFF",
                        mainButtonTextNormalColor: "#FFFFFF",
                        mainButtonTextSelectedColor: "#000000",
                        //controller settings
                        showController: "yes",
                        showControllerWhenVideoIsStopped: "yes",
                        showNextAndPrevButtonsInController: "no",
                        showRewindButton: "yes",
                        showPlaybackRateButton: "yes",
                        showVolumeButton: "yes",
                        showTime: "yes",
                        showAudioTracksButton: "yes",
                        showQualityButton: "yes",
                        showInfoButton: "yes",
                        showDownloadButton: "no",
                        showShareButton: "yes",
                        showEmbedButton: "yes",
                        showChromecastButton: "yes",
                        show360DegreeVideoVrButton: "yes",
                        showFullScreenButton: "yes",
                        disableVideoScrubber: "no",
                        showScrubberWhenControllerIsHidden: "yes",
                        showMainScrubberToolTipLabel: "yes",
                        showDefaultControllerForVimeo: "yes",
                        repeatBackground: "yes",
                        controllerHeight: 42,
                        controllerHideDelay: 3,
                        startSpaceBetweenButtons: 7,
                        spaceBetweenButtons: 8,
                        scrubbersOffsetWidth: 2,
                        mainScrubberOffestTop: 14,
                        timeOffsetLeftWidth: 5,
                        timeOffsetRightWidth: 3,
                        timeOffsetTop: 0,
                        volumeScrubberHeight: 80,
                        volumeScrubberOfsetHeight: 12,
                        timeColor: "#888888",
                        showYoutubeRelAndInfo: "no",
                        youtubeQualityButtonNormalColor: "#888888",
                        youtubeQualityButtonSelectedColor: "#FFFFFF",
                        scrubbersToolTipLabelBackgroundColor: "#FFFFFF",
                        scrubbersToolTipLabelFontColor: "#5a5a5a",
                        //advertisement on pause window
                        aopwTitle: "Advertisement",
                        aopwWidth: 400,
                        aopwHeight: 240,
                        aopwBorderSize: 6,
                        aopwTitleColor: "#FFFFFF",
                        //subtitle
                        subtitlesOffLabel: "Subtitle off",
                        showSubtitleButton: 'no',
                        //popup add windows
                        showPopupAdsCloseButton: "yes",
                        //embed window and info window
                        embedAndInfoWindowCloseButtonMargins: 15,
                        borderColor: "#333333",
                        mainLabelsColor: "#FFFFFF",
                        secondaryLabelsColor: "#a1a1a1",
                        shareAndEmbedTextColor: "#5a5a5a",
                        inputBackgroundColor: "#000000",
                        inputColor: "#FFFFFF",
                        //login
                        playIfLoggedIn: "no",
                        playIfLoggedInMessage: "Please <a href='https://google.com' target='_blank'>login</a> to play this video.",
                        //audio visualizer
                        audioVisualizerLinesColor: "#0099FF",
                        audioVisualizerCircleColor: "#FFFFFF",
                        //lightbox settings
                        closeLightBoxWhenPlayComplete: "no",
                        lightBoxBackgroundOpacity: .6,
                        lightBoxBackgroundColor: "#000000",
                        //sticky on scroll
                        stickyOnScroll: "no",
                        stickyOnScrollShowOpener: "yes",
                        stickyOnScrollWidth: "700",
                        stickyOnScrollHeight: "394",
                        //sticky display settings
                        showOpener: "yes",
                        showOpenerPlayPauseButton: "yes",
                        verticalPosition: "bottom",
                        horizontalPosition: "center",
                        showPlayerByDefault: "yes",
                        animatePlayer: "yes",
                        openerAlignment: "right",
                        mainBackgroundImagePath: "content/minimal_skin_dark/main-background.png",
                        openerEqulizerOffsetTop: -1,
                        openerEqulizerOffsetLeft: 3,
                        offsetX: 0,
                        offsetY: 0,
                        //playback rate / speed
                        defaultPlaybackRate: 1, //0.25, 0.5, 1, 1.25, 1.2, 2
                        //cuepoints
                        executeCuepointsOnlyOnce: "no",
                        //annotations
                        showAnnotationsPositionTool: "no",
                        //ads
                        openNewPageAtTheEndOfTheAds: "no",
                        playAdsOnlyOnce: "no",
                        adsButtonsPosition: "right",
                        skipToVideoText: "You can skip to video in: ",
                        skipToVideoButtonText: "Skip Ad",
                        adsTextNormalColor: "#888888",
                        adsTextSelectedColor: "#FFFFFF",
                        adsBorderNormalColor: "#666666",
                        adsBorderSelectedColor: "#FFFFFF",
                        //a to b loop
                        useAToB: "no",
                        atbTimeBackgroundColor: "transparent",
                        atbTimeTextColorNormal: "#888888",
                        atbTimeTextColorSelected: "#FFFFFF",
                        atbButtonTextNormalColor: "#888888",
                        atbButtonTextSelectedColor: "#FFFFFF",
                        atbButtonBackgroundNormalColor: "#FFFFFF",
                        atbButtonBackgroundSelectedColor: "#000000",
                        //thumbnails preview
                        thumbnailsPreviewWidth: 196,
                        thumbnailsPreviewHeight: 200,
                        thumbnailsPreviewBackgroundColor: "#000000",
                        thumbnailsPreviewBorderColor: "#666",
                        thumbnailsPreviewLabelBackgroundColor: "#666",
                        thumbnailsPreviewLabelFontColor: "#FFF",
                        // context menu
                        showContextmenu: 'yes',
                        showScriptDeveloper: "yes",
                        contextMenuBackgroundColor: "#1f1f1f",
                        contextMenuBorderColor: "#1f1f1f",
                        contextMenuSpacerColor: "#333",
                        contextMenuItemNormalColor: "#888888",
                        contextMenuItemSelectedColor: "#FFFFFF",
                        contextMenuItemDisabledColor: "#444",
                        // fingerprint stamp
                        useFingerPrintStamp: "yes",
                        frequencyOfFingerPrintStamp: 3000,
                        durationOfFingerPrintStamp: 100
                    });
                },
                error: function(xhr, status, error) {
                    container.innerHTML = '<div class="text-danger">Failed to load player.</div>';
                    console.error('AJAX Error:', error);
                }
            });


        }

        $("#default0").click();
    </script>
@endpush
