@extends('website.layouts.master')
@section('title', __('play_list_details'))
@section('content')

    @include('website.movie.details_header')

    <!-- All Section Wrapper Start -->
    <section class="movieDetails__section pt-100 pb-80">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="movieDetails__wrapper">
                        <div class="movieDetails__inner">
                            @include('website.component.ads_middle_of_details')
                            <!-- playlist -->
                            <div class="playlist__area mt-4">
                                <div class="flex__area">
                                    <div class="playlist__meta">
                                        <h4 class="title">{{ $playlist_details->name }}</h4>
                                        <div class="meta">
                                            <span></span>
                                            <span><i class="ri-play-large-line"></i>
                                                {{ $playlist_details->movies_count }}
                                                {{ __('videos') }}</span>
                                        </div>
                                    </div>
                                    <button class="collapse__btn">
                                        <i class="ri-subtract-line"></i>
                                    </button>
                                </div>
                                <div class="playlist__single">
                                    <div class="playlist__overflow">
                                        @forelse ($playlist_movies as $play_list_movie)
                                            <div class="videolist">
                                                <div class="thumb">
                                                    <img src="{{ getFileLink('thumbnail', $play_list_movie->thumbnail, 'movies', '500x750') }}"
                                                        alt="{{__('image')}}" />
                                                    <a href="{{ route('playlist.movie', ['playlist' => $playlist_details->slug, 'slug' => $play_list_movie->slug]) }}"
                                                        class="overlay">
                                                        <button><i class="ri-pause-large-line"></i></button>
                                                    </a>
                                                </div>
                                                <div class="content">
                                                    <h5>{{ __('added') }}
                                                        {{ $play_list_movie->pivot->created_at?->diffForHumans() ?? '-' }}
                                                        {{ __('ago') }}
                                                    </h5>
                                                    <h4 class="title">
                                                        <a
                                                            href="{{ route('playlist.movie', ['playlist' => $playlist_details->slug, 'slug' => $play_list_movie->slug]) }}">{{ $play_list_movie->title }}</a>
                                                    </h4>
                                                    <span>{{ $play_list_movie->total_view . ' ' . __('views') }}</span>
                                                </div>
                                                <div class="dropdown custom__dropdown ms-auto">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                        id="playlist_action01" data-bs-toggle="dropdown"
                                                        aria-expanded="false">
                                                        <i class="ri-more-2-fill"></i>
                                                    </button>
                                                    <ul class="dropdown-menu" aria-labelledby="playlist_action01">
                                                        <li>
                                                            <a href="javascript:void(0)"
                                                                class="dropdown-item btn-remove-from-playlist"
                                                                data-id="{{ $play_list_movie->id }}"
                                                                data-playlistid="{{ $playlist_details->id }}">
                                                                {{ __('remove_from_playlist') }}
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        @empty
                                            <p><span>{{ __('no_videos_available') }}</span></p>
                                        @endforelse

                                    </div>
                                </div>
                            </div>

                            <div class="video__content mt-50">
                                @if (!empty($movie)) <!-- Tab Header -->
                                    <div class="tabHeader">
                                        <h4 class="title">{{ __('video_details') }}</h4>
                                        <div class="tablist">
                                            <div class="custom__tabs text-center">
                                                <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link active" id="cast-tab" data-bs-toggle="pill"
                                                            data-bs-target="#cast" type="button" role="tab"
                                                            aria-controls="cast" aria-selected="false" tabindex="-1">
                                                            {{ __('cast') }}
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="director-tab" data-bs-toggle="pill"
                                                            data-bs-target="#director" type="button" role="tab"
                                                            aria-controls="director" aria-selected="false" tabindex="-1">
                                                            {{ __('director') }}
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="writer-tab" data-bs-toggle="pill"
                                                            data-bs-target="#writer" type="button" role="tab"
                                                            aria-controls="writer" aria-selected="false" tabindex="-1">
                                                            {{ __('write') }}
                                                        </button>
                                                    </li>
                                                    <li class="nav-item" role="presentation">
                                                        <button class="nav-link" id="review-tab" data-bs-toggle="pill"
                                                            data-bs-target="#review" type="button" role="tab"
                                                            aria-controls="review" aria-selected="false" tabindex="-1">
                                                            {{ __('review_&_ratings') }}
                                                        </button>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Tab Content Start -->


                                    <div class="tab-content pb-5">
                                        <div class="tab-pane fade active show" id="cast" role="tabpanel">
                                            <!-- Actress Wrapper -->
                                            <div class="actress__wrapper">
                                                <div class="row">
                                                    @foreach (json_decode($movie->stars) as $star)
                                                        <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 pb-4">
                                                            <!-- Acctress Item -->
                                                            <div class="actressItem">
                                                                <div class="thumb">
                                                                    <img src="{{ get_star($star, 'star_image') }}"
                                                                        alt="thumb" />
                                                                </div>
                                                                <div class="content">
                                                                    <h4 class="title"> {{ get_star($star, 'star_name') }}
                                                                    </h4>
                                                                    <span class="designation">
                                                                        {{ get_star($star, 'star_type') }}
                                                                    </span>
                                                                    <div class="social__icon">
                                                                        @if (get_star($star, 'facebook'))
                                                                            <a href="{{ get_star($star, 'facebook') }}"
                                                                                target="_blank"><i
                                                                                    class="ri-facebook-fill"></i></a>
                                                                        @endif
                                                                        @if (get_star($star, 'twitter'))
                                                                            <a href="{{ get_star($star, 'twitter') }}"
                                                                                target="_blank"><i
                                                                                    class="ri-twitter-x-line"></i></a>
                                                                        @endif
                                                                        @if (get_star($star, 'instagram'))
                                                                            <a href="{{ get_star($star, 'instagram') }}"
                                                                                target="_blank"><i
                                                                                    class="ri-instagram-line"></i></a>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- Acctress Item -->
                                                        </div>
                                                    @endforeach

                                                </div>
                                            </div>
                                            <!-- Actress Wrapper -->
                                        </div>
                                        <div class="tab-pane fade" id="director" role="tabpanel">
                                            <!-- Actress Wrapper -->
                                            <div class="actress__wrapper">
                                                <div class="row">
                                                    @foreach (json_decode($movie->director) as $director)
                                                        <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 pb-4">
                                                            <!-- Acctress Item -->
                                                            <div class="actressItem">
                                                                <div class="thumb">
                                                                    <img src="{{ get_star($director, 'star_image') }}"
                                                                        alt="thumb" />
                                                                </div>
                                                                <div class="content">
                                                                    <h4 class="title">
                                                                        {{ get_star($director, 'star_name') }}</h4>
                                                                    <span
                                                                        class="designation">{{ get_star($director, 'star_type') }}</span>
                                                                    @if (get_star($director, 'facebook'))
                                                                        <a href="{{ get_star($director, 'facebook') }}"
                                                                            target="_blank"><i
                                                                                class="ri-facebook-fill"></i></a>
                                                                    @endif
                                                                    @if (get_star($director, 'twitter'))
                                                                        <a href="{{ get_star($director, 'twitter') }}"
                                                                            target="_blank"><i
                                                                                class="ri-twitter-x-line"></i></a>
                                                                    @endif
                                                                    @if (get_star($director, 'instagram'))
                                                                        <a href="{{ get_star($director, 'instagram') }}"
                                                                            target="_blank"><i
                                                                                class="ri-instagram-line"></i></a>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <!-- Acctress Item -->
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                            <!-- Actress Wrapper -->
                                        </div>
                                        <div class="tab-pane fade" id="writer" role="tabpanel">
                                            <!-- Actress Wrapper -->
                                            <div class="actress__wrapper">
                                                <div class="row">
                                                    @foreach (json_decode($movie->writer) as $writer)
                                                        <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 pb-4">
                                                            <!-- Acctress Item -->
                                                            <div class="actressItem">
                                                                <div class="thumb">
                                                                    <img src="{{ get_star($writer, 'star_image') }}"
                                                                        alt="thumb" />
                                                                </div>
                                                                <div class="content">
                                                                    <h4 class="title">
                                                                        {{ get_star($writer, 'star_name') }}</h4>
                                                                    <span
                                                                        class="designation">{{ get_star($writer, 'star_type') }}</span>
                                                                    <div class="social__icon">
                                                                        @if (get_star($writer, 'facebook'))
                                                                            <a href="{{ get_star($writer, 'facebook') }}"
                                                                                target="_blank"><i
                                                                                    class="ri-facebook-fill"></i></a>
                                                                        @endif
                                                                        @if (get_star($writer, 'twitter'))
                                                                            <a href="{{ get_star($writer, 'twitter') }}"
                                                                                target="_blank"><i
                                                                                    class="ri-twitter-x-line"></i></a>
                                                                        @endif
                                                                        @if (get_star($writer, 'instagram'))
                                                                            <a href="{{ get_star($writer, 'instagram') }}"
                                                                                target="_blank"><i
                                                                                    class="ri-instagram-line"></i></a>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- Acctress Item -->
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                            <!-- Actress Wrapper -->
                                        </div>
                                        <div class="tab-pane fade" id="review" role="tabpanel">
                                            <!-- Single Wrapper -->
                                            <div class="blogSingle__wrapper">
                                                @if (!auth()->user()?->hasReviewed($movie))
                                                    <form action="{{ route('review.store.movie', $movie->id) }}"
                                                        method="POST" class="all__comments">
                                                        @csrf
                                                        <input type="hidden" name="reviewable_id"
                                                            value="{{ $movie->id }}">
                                                        <input type="hidden" name="rating" id="rating-value"
                                                            value="">

                                                        <div class="commentsRating">
                                                            <h5 class="comments">{{ count($movie->reviews) }}
                                                                {{ __('reviews') }}</h5>
                                                            <div class="rating__inline">
                                                                <span class="title">{{ __('submit_rating') }} :</span>
                                                                <div class="rating" id="star-rating">
                                                                    @for ($i = 1; $i <= 10; $i++)
                                                                        <a href="javascript:void(0)"
                                                                            data-value="{{ $i }}"><i
                                                                                class="ri-star-line"></i></a>
                                                                    @endfor
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <textarea name="review" class="form-control" cols="30" rows="8"
                                                                placeholder="{{ __('write_something') }}"></textarea>
                                                        </div>

                                                        <div class="submit-btn">
                                                            <button type="submit"
                                                                class="btn btn-primary">{{ __('post') }}</button>
                                                        </div>
                                                    </form>
                                                @endif
                                                <div class="clients__review">
                                                    <!-- <h4 class="review__title">People Comments (03)</h4> -->
                                                    <div class="review__wrapper">
                                                        <!-- Review Item Start -->
                                                        @foreach ($movie->reviews as $review)
                                                            <div class="review__item">
                                                                <div class="d-flex justify-content-between">
                                                                    <div class="d-flex align-items-center gap-4">
                                                                        <div class="avatar">
                                                                            <img src="{{ getFileLink('user', $review->user->image, 'users', '80x80') }}"
                                                                                alt="avatar" />
                                                                        </div>
                                                                        <div class="review__content">
                                                                            <h5>{{ $review->user->first_name . ' ' . $review->user->last_name }}
                                                                            </h5>
                                                                            <span>{{ $review->created_at->format('d F, Y') }}</span>
                                                                        </div>
                                                                    </div>
                                                                    <div>
                                                                        @php
                                                                            $filled = $review->rating;
                                                                            $empty = 10 - $filled;
                                                                        @endphp

                                                                        <span class="text-white">
                                                                            <strong>{{ __('ratings') }}: </strong>
                                                                            {!! str_repeat('★', $filled) !!}{!! str_repeat('☆', $empty) !!}
                                                                        </span>

                                                                    </div>
                                                                </div>
                                                                <p class="desc">
                                                                    {{ $review->review }}
                                                                </p>

                                                                @if ($review->reply)
                                                                    <div class="sub__replay">
                                                                        <div class="replay">
                                                                            <a href="javascript:void(0)"><i
                                                                                    class="ri-corner-left-up-line"></i>{{ __('reply') }}</a>
                                                                        </div>
                                                                        <div class="review__item">
                                                                            <div class="d-flex align-items-center gap-4">
                                                                                <div class="avatar">
                                                                                    <img src="{{ getFileLink('original_image', get_config('favicon'), 'favicons', '96x96') }}"
                                                                                        alt="avatar" />
                                                                                </div>
                                                                                <div class="review__content">
                                                                                    <h5>{{ __('admin') }}</h5>
                                                                                    <span>{{ $review->updated_at->format('d F, Y') }}</span>
                                                                                </div>
                                                                            </div>
                                                                            <p class="desc">
                                                                                {{ $review->reply }}
                                                                            </p>
                                                                        </div>
                                                                    </div>
                                                                @endif

                                                                <!-- Reaction meta -->
                                                                <div class="reaction__meta">
                                                                    <a href="javascript:void(0)"
                                                                        class="avarage__reaction like-btn"
                                                                        data-review-id="{{ $review->id }}"
                                                                        data-liked="{{ auth()->check() && $review->isLikedBy(auth()->user()) ? '1' : '0' }}">
                                                                        @if (auth()->check() && $review->isLikedBy(auth()->user()))
                                                                            <i class="ri-thumb-up-fill text-primary"></i>
                                                                        @else
                                                                            <i class="ri-thumb-up-line"></i>
                                                                        @endif
                                                                        <span
                                                                            class="like-count">{{ $review->likes()->count() }}</span>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        @endforeach

                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Single Wrapper -->
                                        </div>
                                    </div>
                                @endif

                                <!-- Relared Section Start -->
                                <div class="related__section mb-40 mt-30">
                                    <div class="section__title">
                                        <h2 class="title">{{ __('related_movies') }}</h2>
                                    </div>
                                    <div class="position-relative">
                                        <div class="swiper relatedmovie__slider">
                                            <div class="swiper-wrapper">
                                                @foreach (related_movies() as $related_movie)
                                                    <!-- Slide -->
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('movie.details', ['slug' => $related_movie->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $related_movie->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                            @if ($related_movie->is_free == 1)
                                                            @elseif ($related_movie->is_rental == 1)
                                                                <div class="badge bg-purple">
                                                                    {{ __('rent:') . ' ' . get_currency($related_movie->rental_price) }}
                                                                </div>
                                                            @else
                                                                <div class="badge"> {{ __('premium') }} </div>
                                                            @endif
                                                            <div class="video__content">
                                                                <div class="content__left">
                                                                    <a href="{{ route('movie.details', ['slug' => $related_movie->slug]) }}"
                                                                        class="title">{{ $related_movie->title }}</a>
                                                                    <div class="video__meta">
                                                                        <div class="meta__item">
                                                                            {{ date('Y', strtotime($related_movie->release)) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ get_rating($related_movie->imdb_rating) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ runtime($related_movie->runtime) }}</div>
                                                                    </div>
                                                                    <div class="video__tag">
                                                                        <span>{{ get_movie_genre($related_movie->genre) }}</span>
                                                                        @if (get_movie_category($related_movie->video_type))
                                                                            <span>{{ get_movie_category($related_movie->video_type) }}</span>
                                                                        @endif
                                                                        <span>{{ get_movie_quality($related_movie->video_quality) }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="content__right">
                                                                    <div class="action__btn">
                                                                        <a href="javascript:void(0)"
                                                                            class="share__btn share-btn"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-placement="bottom"
                                                                            data-url="{{ route('movie.details', ['slug' => $related_movie->slug]) }}"
                                                                            data-bs-target="#shareModal"
                                                                            title="{{ __('share') }}"><i
                                                                                class="ri-share-line"></i></a>
                                                                        <a href="javascript:void(0)"
                                                                            data-movie-id="{{ $related_movie->id }}"
                                                                            class="open-save-playlist-modal"
                                                                            title="{{ __('add_playlist') }}"><i
                                                                                class="ri-add-line"></i></a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="related-movie-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="related-movie-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Related Section End -->

                                <!-- Recommended Section Start -->
                                <div class="recommended__section mb-40">
                                    <div class="section__title">
                                        <h2 class="title">{{ __('recommended_for_you') }}</h2>
                                        <div class="view__btn">
                                            <a
                                                href="{{ route('all.movies', ['type' => 'recommended']) }}">{{ __('view_all') }}</a>
                                        </div>
                                    </div>
                                    <div class="position-relative">
                                        <div class="swiper recommendedmovie__slider">
                                            <div class="swiper-wrapper">
                                                @foreach (recommended_movies() as $recommended_movie)
                                                    <!-- Slide -->
                                                    <div class="swiper-slide">
                                                        <div class="video__card">
                                                            <a href="{{ route('movie.details', ['slug' => $recommended_movie->slug]) }}"
                                                                class="video__thumb">
                                                                <img src="{{ getFileLink('thumbnail', $recommended_movie->thumbnail, 'movies', '500x750') }}"
                                                                    alt="movie" />
                                                                <div class="video__btn">
                                                                    <i class="ri-play-fill"></i>
                                                                </div>
                                                            </a>
                                                            @if ($recommended_movie->is_free == 1)
                                                            @elseif ($recommended_movie->is_rental == 1)
                                                                <div class="badge bg-purple">
                                                                    {{ __('rent:') . ' ' . get_currency($recommended_movie->rental_price) }}
                                                                </div>
                                                            @else
                                                                <div class="badge"> {{ __('premium') }} </div>
                                                            @endif
                                                            <div class="video__content">
                                                                <div class="content__left">
                                                                    <a href="{{ route('movie.details', ['slug' => $recommended_movie->slug]) }}"
                                                                        class="title">{{ $recommended_movie->title }}</a>
                                                                    <div class="video__meta">
                                                                        <div class="meta__item">
                                                                            {{ date('Y', strtotime($recommended_movie->release)) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ get_rating($recommended_movie->imdb_rating) }}
                                                                        </div>
                                                                        <div class="meta__item">
                                                                            {{ runtime($recommended_movie->runtime) }}
                                                                        </div>
                                                                    </div>
                                                                    <div class="video__tag">
                                                                        <span>{{ get_movie_genre($recommended_movie->genre) }}</span>
                                                                        @if (get_movie_category($recommended_movie->video_type))
                                                                            <span>{{ get_movie_category($recommended_movie->video_type) }}</span>
                                                                        @endif
                                                                        <span>{{ get_movie_quality($recommended_movie->video_quality) }}</span>
                                                                    </div>
                                                                </div>
                                                                <div class="content__right">
                                                                    <div class="action__btn">
                                                                        <a href="javascript:void(0)"
                                                                            class="share__btn share-btn"
                                                                            data-bs-toggle="modal"
                                                                            data-bs-placement="bottom"
                                                                            data-url="{{ route('movie.details', ['slug' => $recommended_movie->slug]) }}"
                                                                            data-bs-target="#shareModal"
                                                                            title="{{ __('share') }}"><i
                                                                                class="ri-share-line"></i></a>
                                                                        <a href="javascript:void(0)"
                                                                            data-movie-id="{{ $related_movie->id }}"
                                                                            class="open-save-playlist-modal"
                                                                            title="{{ __('add_playlist') }}"><i
                                                                                class="ri-add-line"></i></a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="swiper__navigation">
                                            <div class="recommended-movie-swipe-prev swiper-button-prev">
                                                <i class="ri-arrow-left-s-line"></i>
                                            </div>
                                            <div class="recommended-movie-swipe-next swiper-button-next">
                                                <i class="ri-arrow-right-s-line"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Recommended Section End -->
                            </div>
                        </div>
                        <div class="ads__wrapper">
                            <img src="{{ static_asset('website/images/ads/ads-big-01.jpg') }}" alt="ads-img" />
                            <img src="{{ static_asset('website/images/ads/ads-big-02.jpg') }}" alt="ads-img" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- All Section Wrapper End -->
@endsection
@include('website.component.like_review')
@push('js')
    <script>
        "use strict";

        let player;

        function getYouTubeID(url) {
            const regExp =
                /(?:youtube\.com\/(?:[^\/\n\s]+\/\S+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([a-zA-Z0-9_-]{11})/;
            const match = url.match(regExp);
            return match ? match[1] : null;
        }

        function getGoogleDriveEmbed(url) {
            const fileIdMatch = url.match(/\/d\/([^\/]+)\//);
            if (fileIdMatch && fileIdMatch[1]) {
                return `https://drive.google.com/uc?export=download&id=${fileIdMatch[1]}`;
            }
            return null;
        }

        function serverLink(type, url, el) {

            document.querySelectorAll('#server-buttons .btn').forEach(btn => btn.classList.remove('active'));
            el.classList.add('active');

            const container = document.getElementById('player-container');
            container.innerHTML = ''; // Clear previous player

            // Destroy previous Plyr instance
            if (player && typeof player.destroy === 'function') {
                player.destroy();
            }

            let embedHtml = '';

            if (type === 'youtube') {
                const videoId = getYouTubeID(url);
                if (videoId) {
                    embedHtml = `<div id="plyr-player" data-plyr-provider="youtube" data-plyr-embed-id="${videoId}"></div>`;
                }
            } else if (type === 'gdrive') {
                const embedUrl = getGoogleDriveEmbed(url);
                if (embedUrl) {
                    embedHtml =
                        `
                                                                                                                                                                                                                                                                        <video id="plyr-player" controls crossorigin>
                                                                                                                                                                                                                                                                            <source src="${embedUrl}" type="video/mp4">
                                                                                                                                                                                                                                                                        </video>`;
                }
            }

            container.innerHTML = embedHtml;

            // Re-initialize Plyr
            player = new Plyr('#plyr-player');
        }

        $("#default0").click();
        let currentMovieId = {{ $movie?->id ?? 'null' }};

        $('.btn-remove-from-playlist').on('click', function() {
            const movieId = $(this).data('id');
            const playlistId = $(this).data('playlistid');
            const $el = $(this).closest('.videolist');

            Swal.fire({
                title: '{{ __('are_you_sure') }}',
                text: "{{ __('movie_delete_prompt') }}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: '{{ __('yes_remove_it') }}',
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('remove.move.from.playlist') }}",
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            movie_id: movieId,
                            playlist_id: playlistId
                        },
                        success: function(data) {
                            if (movieId == currentMovieId) {
                                location.reload();
                            } else {
                                Swal.fire('{{ __('Removed!') }}',
                                    '{{ __('playlist_removed') }}', 'success');
                                $el.remove();
                            }
                        },
                        error: function(xhr) {
                            let message = '{{ __('something_went_wrong') }}';
                            if (xhr.responseJSON && xhr.responseJSON.message) {
                                message = xhr.responseJSON.message;
                            }
                            Swal.fire('{{ __('Error!') }}', message, 'error');
                        }
                    });
                }
            });
        });
    </script>
@endpush
