<div class="modal-header">
    <button type="button" class="close ms-auto" data-bs-dismiss="modal" aria-label="Close">
        <i class="ri-close-large-line"></i>
    </button>
</div>
<div class="modal-body p-0">
    <form action="" method="post" class="form__wrapper payment_form p-5" enctype="multipart/form-data">
        @csrf
        <div class="heading__content d-flex justify-content-between mt-25">
            <h2 class="title2 mb-0">
                {{ $payment_type == 'rental' ? __('video_subscription_plan') : __('subscription_plan') }} </h2>
            <div class="meta text-16 text-primary">
                {{ $payment_type == 'rental' ? __('Video Rent') : $package_details?->name }} </div>
        </div>
        <hr />
        <input type="hidden" name="payment_type" value="{{ $payment_type }}">
        <!-- Rent Card Start -->
        @if ($payment_type == 'rental')
            <input type="hidden" name="video_type" value="{{ $video_type }}">
            <input type="hidden" name="video_id" value="{{ $package_details->id }}">
            <div class="rentCard">
                <div class="rent__header" id="toggleHeader">
                    <div class="title">
                        <span class="icon"><img src="{{ static_asset('payment_icon/crown-icon.svg') }}"
                                alt="icon" /></span>
                        <span>{{ $package_details->title }}</span>
                    </div>
                    <div class="prices">
                        {{ get_currency($package_details->rental_price) }}
                        <span>/ {{ $package_details->rental_duration . ' ' . __('hours') }}</span>
                        <i class="ri-arrow-down-s-line"></i>
                    </div>
                </div>

                <div class="details" id="toggleDetails">
                    <p><span>{{ __('package_cost') }} :</span> {{ get_currency($package_details->rental_price) }}</p>
                    <p><span>{{ __('validity') }}:</span> {{ $package_details->rental_duration . ' ' . __('hours') }}
                    </p>
                    <p><span>{{ __('expire_date') }}:</span>
                        {{ \Carbon\Carbon::now()->addHours($package_details->rental_duration)->format('Y-m-d') }}
                    </p>
                    <p><span>{{ __('ads') }}:</span> {{ __('not_shown') }}</p>
                    <p><span>{{ __('download') }}:</span> {{ __('allowed') }}</p>
                </div>
            </div>
        @else
            <input type="hidden" value="{{ $package_details->id }}" name="package_id">
            <div class="rentCard">
                <div class="rent__header" id="toggleHeader">
                    <div class="title">
                        <span class="icon"><img src="{{ static_asset('payment_icon/crown-icon.svg') }}"
                                alt="icon" /></span>
                        <span>{{ get_config('system_name') . ' ' . ucwords($package_details->type) . ' ' . __('subscription') }}</span>
                    </div>
                    <div class="prices">
                        {{ get_currency($package_details->discount > 0 ? $package_details->price - $package_details->discount : $package_details->price) }}
                        <span>/ {{ $package_details->day . ' ' . __('days') }}</span>
                        <i class="ri-arrow-down-s-line"></i>
                    </div>
                </div>

                <div class="details" id="toggleDetails">
                    <p><span>{{ __('package_cost') }} :</span> {{ get_currency($package_details->price) }}</p>
                    <p><span>{{ __('discount') }} :</span> {{ get_currency($package_details->discount) }}</p>
                    <p><span>{{ __('validity') }}:</span> {{ $package_details->day . ' ' . __('days') }}</p>
                    <p><span>{{ __('device_limit') }}:</span> {{ $package_details->screens }}</p>
                    <p><span>{{ __('expire_date') }}:</span>
                        {{ \Carbon\Carbon::now()->addDays($package_details->day)->format('Y-m-d') }}
                    </p>
                    <p><span>{{ __('ads') }}:</span> {{ __('not_shown') }}</p>
                    <p><span>{{ __('download') }}:</span> {{ __('allowed') }}</p>
                    <p><span>{{ __('premium_content') }}:</span> {{ __('allowed') }}</p>
                </div>
            </div>
        @endif

        <!-- Payment Method Start -->
        <div class="payment__method mt-20">
            <h4 class="title">{{ __('select_payment_method') }}</h4>
            <div class="radio__options">
                @if (setting('is_offline_activated'))
                    <div class="radio__option">
                        <input type="radio" name="payment_gateway" onclick="requiredCheck()" id="payment-card-offline"
                            value="offline" required>
                        <label for="payment-card-offline">
                            <img src="{{ static_asset('images/payment-icon/offline.svg') }}" alt="icon" />
                        </label>
                    </div>
                @endif
                @if (setting('is_stripe_activated'))
                    <div class="radio__option">
                        <input type="radio" name="payment_gateway" onclick="requiredCheck()" id="payment-card-stripe"
                            value="stripe" required>
                        <label for="payment-card-stripe">
                            <img src="{{ static_asset('images/payment-icon/stripe.svg') }}" alt="icon" />
                        </label>
                    </div>
                @endif
                @if (setting('is_paypal_activated'))
                    <div class="radio__option">
                        <input type="radio" name="payment_gateway" onclick="requiredCheck()" id="payment-card-paypal"
                            value="paypal" required>
                        <label for="payment-card-paypal">
                            <img src="{{ static_asset('images/payment-icon/paypal.svg') }}" alt="icon" />
                        </label>
                    </div>
                @endif
                @if (setting('is_paddle_activated'))
                    <div class="radio__option">
                        <input type="radio" name="payment_gateway" onclick="requiredCheck()" id="payment-card-paddle"
                            value="paddle" required>
                        <label for="payment-card-paddle">
                            <img src="{{ static_asset('images/payment-icon/paddle.svg') }}" alt="icon" />
                        </label>
                    </div>
                @endif
                @if (setting('is_razor_pay_activated'))
                    <div class="radio__option">
                        <input type="radio" name="payment_gateway" onclick="requiredCheck()"
                            id="payment-card-razor_pay" value="razor_pay" required>
                        <label for="payment-card-razor_pay">
                            <img src="{{ static_asset('images/payment-icon/razor_pay.svg') }}" alt="icon" />
                        </label>
                    </div>
                @endif
                @if (setting('is_mercadopago_activated'))
                    <div class="radio__option">
                        <input type="radio" name="payment_gateway" onclick="requiredCheck()"
                            id="payment-card-mercadopago" value="mercadopago" required>
                        <label for="payment-card-mercadopago">
                            <img src="{{ static_asset('images/payment-icon/mercadopago.svg') }}" alt="icon" />
                        </label>
                    </div>
                @endif
            </div>
        </div>


        <!-- Terms and Conditions -->
        <div class="custom__checkbox align-items-start">
            <input type="checkbox" class="form-check-input" id="login-policyChecks" onclick="requiredCheck()">
            <label class="form-check-label" for="login-policyChecks">
                {{ __('i_agree_to_the_refund_policy') }}, <a href="javascript:void(0)" class="text-primary">
                    {{ __('term_and_conditions') }} </a> {{ __('about_us') }}
            </label>
        </div>

        <!-- Button Group -->
        <div class="btn__group mt-40 d-flex align-items-center justify-content-end gap-3" id="proceedDiv">
            <button type="submit" id="proceedBtn" class="btn btn-primary px-25 text-14 disables" disabled>
                {{ __('proceed_to_payment') }}
            </button>
        </div>
    </form>

    <div class="row justify-content-center p-3 pt-0 mb-4 d-none" id="offline_payment">
        <div class="col-md-10">
            <h4 class="section-title">{{ __('offline_payment_details') }}</h4>
            <div class="bg-white redious-border p-20 p-sm-30 pt-sm-30">
                <form action="{{ route('client.offline.claim') }}" class="form-validate offline_form" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="plan_id" value="{{ @$package_details->id }}">
                    <input type="hidden" name="payment_type" value="{{ @$payment_type }}">
                    <input type="hidden" name="video_type" value="{{ @$video_type }}">

                    {!! setting('offline_payment_instruction') !!}

                    <!-- Transaction Key (Required) -->
                    <div class="form-group mb-3">
                        <label for="transaction_key">{{ __('transaction_key') }} <span
                                class="text-danger">*</span></label>
                        <input type="text" name="transaction_key" id="transaction_key"
                            placeholder="{{ __('transaction_key') }}" class="form-control" required>
                    </div>

                    <!-- File Upload (Optional) -->
                    <div class="form-group mb-3">
                        <label for="transaction_file">{{ __('upload_file') }} ({{ __('optional') }})</label>
                        <input type="file" name="transaction_file" id="transaction_file" class="form-control">
                    </div>

                    <div class="d-flex justify-content-end align-items-center mt-30">
                        <button type="submit" class="btn btn-primary">{{ __('claim') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</div>

<script>
    "use strict";
    $(document).ready(function() {
        function updateOfflineFormAndButton() {
            const offlineSelected = $('#payment-card-offline').is(':checked');
            const policyChecked = $('#login-policyChecks').is(':checked');

            // Show or hide offline form
            if (offlineSelected) {
                $('#offline_payment').removeClass('d-none');
            } else {
                $('#offline_payment').addClass('d-none');
            }

            // Enable Claim button only if offline selected AND policy checked
            $('#offline_payment button[type="submit"]').prop('disabled', !(offlineSelected && policyChecked));
        }

        // Run on radio change and checkbox change
        $('input[name="payment_gateway"], #login-policyChecks').on('change', updateOfflineFormAndButton);

        // Initialize on page load
        updateOfflineFormAndButton();

        function toggle_payment_gateway() {
            if ($('#payment-card-offline').is(':checked')) {
                $('#offline_payment').removeClass('d-none'); // Show offline form
                $('#proceedDiv').addClass('d-none');
            } else {
                $('#offline_payment').addClass('d-none'); // Hide offline form
                $('#proceedDiv').removeClass('d-none');
            }
        }

        // Run updateUI on radio button change
        $('input[name="payment_gateway"]').on('change', toggle_payment_gateway);

        // Initialize UI on page load
        toggle_payment_gateway();
    });

    $(document).ready(function() {
        // Button Hide by default
        $('#proceedBtn').addClass('disables').attr('disabled', true);

        window.requiredCheck = function() {
            let paymentSelected = $("input[name='payment_gateway']:checked").length > 0;
            let termsChecked = $("#login-policyChecks").is(":checked");
            let paymentMethod = $("input[name='payment_gateway']:checked").val();

            if (paymentMethod == 'stripe') {
                var url = '{{ route('client.stripe.redirect') }}' + '?trx_id={{ $trx_id }}' + '' +
                    '&payment_type=stripe';
            } else if (paymentMethod == 'paypal') {
                var url = '{{ route('client.paypal.redirect') }}' + '?trx_id={{ $trx_id }}' + '' +
                    '&payment_type=paypal';
            } else if (paymentMethod == 'paddle') {
                var url = '{{ route('client.paddle.redirect') }}' + '?trx_id={{ $trx_id }}' + '' +
                    '&payment_type=paddle';
            } else if (paymentMethod == 'mercadopago') {
                var url = '{{ route('client.mercadopago.redirect') }}' + '?trx_id={{ $trx_id }}' + '' +
                    '&payment_type=mercadopago';
            } else if (paymentMethod == 'razor_pay') {
                var url = '{{ route('client.razor.pay.redirect') }}' + '?trx_id={{ $trx_id }}' + '' +
                    '&payment_type=razor_pay';
            } else if (paymentMethod == 'offline') {

                if (paymentMethod == 'offline') {
                    $('#offline_payment').removeClass('d-none');
                    $('#proceedBtn').addClass('d-none');
                } else {
                    btn_selector.removeClass('d-none');
                    $('#offline_payment').addClass('d-none');
                    $('#proceedBtn').removeClass('d-none');
                }
            }
            $('#proceedBtn').removeClass('d-none');

            $('.payment_form').attr('action', url);

            if (paymentSelected && termsChecked) {
                $('#proceedBtn').removeClass('disables').attr('disabled', false);
            } else {
                $('#proceedBtn').addClass('disables').attr('disabled', true);
            }
        }
        /*********************************
        /*  Rent Card toggle
        *********************************/
        $(document).ready(function() {
            $("#toggleHeader").click(function() {
                $("#toggleDetails").slideToggle();
            });
        });
    });
</script>
