@extends('website.layouts.master')
@section('title', __('contact_us'))
@section('content')

        <!-- Breadcrumb Start -->
        <div class="breadcrumb__area">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb__title">
                            <ul class="link">
                                <li><a href="{{ route('home') }}">{{ __('home') }}</a></li>
                                <li>{{ __('help_center') }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Breadcrumb End -->

        <!-- Contact Section Start -->
        <section class="contact__section pt-35 pb-80">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="tabHeader">
                            <h4 class="title"> {{__('contact_us')}} </h4>
                            <div class="tablist">
                                <div class="custom__tabs text-center">
                                    <ul class="nav">
                                        <li class="nav-item">
                                            <a class="btn btn-outline border-none rounded-pill text-white py-2"
                                                href="{{route('faqs')}}"> {{__('faqs')}} </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="btn btn-primary rounded-pill py-2" href="{{route('contact-us')}}">
                                                {{__('contact_us')}} </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <div class="contact__area">
                            <form action="{{ route('contact_us.store') }}" method="POST" class="contact__form">
                                @csrf
                                <h4 class="form__title">{{__('send_message')}}</h4>

                                <!-- First Name -->
                                <div class="flex__input">
                                    <div class="form-group">
                                        <label for="contact_name">{{__('first_name')}}</label>
                                        <input type="text" class="form-control" id="contact_name" name="name"
                                            value="{{ old('name') }}" placeholder="Name" />
                                        @error('name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <!-- Email -->
                                    <div class="form-group">
                                        <label for="contact_email">{{__('email')}}</label>
                                        <input type="email" class="form-control" id="contact_email" name="email"
                                            value="{{ old('email', auth()->check() ? auth()->user()->email : '') }}"
                                            placeholder="Your Email" />
                                        @error('email')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Subject -->
                                <div class="form-group">
                                    <label for="contact_subject">{{__('subject')}}</label>
                                    <input type="text" class="form-control" id="contact_subject" name="subject"
                                        value="{{ old('subject') }}" placeholder="Your Subject" />
                                    @error('subject')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <!-- Message -->
                                <div class="form-group">
                                    <label for="contact_message">{{__('message')}}</label>
                                    <textarea name="message" class="form-control" id="contact_message" cols="30" rows="5"
                                        placeholder="Write your message">{{ old('message') }}</textarea>
                                    @error('message')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
    @if (get_config('is_recaptcha_activated') && get_config('recaptcha_site_key'))
        <div class="mb-30">
            <div id="html_element" class="g-recaptcha" data-sitekey="{{get_config('recaptcha_site_key')}}"></div>
        </div>
    @endif
                                <!-- Submit Button -->
                                <div class="btn__group mt-30">
                                    <button type="submit" name="btn" class="btn btn-primary">{{__('send')}}</button>
                                </div>
                            </form>

                            <div class="contact__thumb">
                                <img src="{{static_asset('website/images/contact-thumb.jpg')}}" alt="contact" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Contact Section End -->

@endsection