@php
    $selectedRatings = explode('-', request()->get('ratings', ''));
    $selectedGenres = explode('-', request()->get('genres', ''));
    $selected_countries = explode('-', request()->get('countries', ''));
    $selected_languages = explode('-', request()->get('languages', ''));
    $selected_years = explode('-', request()->get('years', ''));
@endphp
<form id="filterForm" method="GET" action="{{ url()->current() }}">
    <div class="filter__wrapper">
        <div class="filter__dropdown">
            <div class="selected"> {{ __('rating') }} </div>
            <ul class="filter__list">

                @for ($i = 1; $i <= 10; $i++)
                    <li class="custom__checkbox">
                        <input type="checkbox" name="ratings" id="{{ $i }}star" value="{{ $i }}"
                            {{ in_array($i, $selectedRatings) ? 'checked' : '' }} />
                        <label for="{{ $i }}star">{{ $i }}
                            {{ __('star') }}</label>
                    </li>
                @endfor
            </ul>
        </div>
        @if (!isset($is_genre))
            <div class="filter__dropdown">
                <div class="selected">{{ __('genre') }}</div>
                <ul class="filter__list">
                    @foreach (get_all_genres() as $genre)
                        <li class="custom__checkbox">
                            <input type="checkbox" name="genres" value="{{ $genre->slug }}"
                                {{ in_array($genre->slug, $selectedGenres) ? 'checked' : '' }}
                                id="genre-{{ $genre->id }}" />
                            <label for="genre-{{ $genre->id }}">
                                {{ $genre->name }}
                            </label>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="filter__dropdown">
            <div class="selected">{{ __('year') }}</div>
            <ul class="filter__list">
                @foreach ($years as $year)
                    <li class="custom__checkbox">
                        <input type="checkbox" name="years" id="year_{{ $year }}"
                            value="{{ $year }}" {{ in_array($year, $selected_years) ? 'checked' : '' }} />
                        <label for="year_{{ $year }}"> {{ $year }}</label>
                    </li>
                @endforeach
            </ul>
        </div>
        {{-- Language Filter --}}
        <div class="filter__dropdown">
            <div class="selected">{{ __('language') }}</div>
            <ul class="filter__list">
                @foreach ($languages as $language)
                    <li class="custom__checkbox">
                        <input type="checkbox" name="languages" value="{{ $language->slug }}"
                            id="lang-{{ $language->id }}"
                            {{ in_array($language->slug, $selected_languages) ? 'checked' : '' }} />
                        <label for="lang-{{ $language->id }}">{{ ucfirst($language->name) }}</label>
                    </li>
                @endforeach
            </ul>
        </div>

        {{-- Country Filter --}}
        @if (!isset($is_country))
            <div class="filter__dropdown">
                <div class="selected">{{ __('country') }}</div>
                <ul class="filter__list">
                    @foreach ($countries as $country)
                        <li class="custom__checkbox">
                            <input type="checkbox" name="countries" value="{{ $country->slug }}"
                                id="country-{{ $country->id }}"
                                {{ in_array($country->slug, $selected_countries) ? 'checked' : '' }} />
                            <label
                                for="country-{{ $country->id }}">{{ ucfirst($country->name) }}{{ $country->id }}</label>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>
</form>

@push('js')
    <script>
        "use strict";
        $(document).on('change', '#filterForm input[type="checkbox"]', function() {
            const form = $('#filterForm');
            const params = new URLSearchParams();

            // Collect and join checked values by name
            ['ratings', 'genres', 'years', 'languages', 'countries', 'type'].forEach(name => {
                let selected = form.find(`input[name="${name}"]:checked`).map(function() {
                    return $(this).val();
                }).get();

                if (selected.length > 0) {
                    params.set(name, selected.join('-'));
                }
            });

            // Redirect to the new URL
            window.location.href = `${form.attr('action')}?${params.toString()}`;
        });
    </script>
@endpush
