@php
    $footerAd = get_ads('footer', '728x90', 'object');
@endphp

@if ($footerAd)
    <!-- Ads Start -->
    <div class="ads__area my-5">
        @if ($footerAd->type == 'google')
            <div class="ads__google">
                {!! $footerAd->google_ads_code !!}
            </div>
        @elseif ($footerAd->type == 'mp4')
            <video class="ads__video" width="728" height="90" controls autoplay loop muted>
                <source src="{{ $footerAd->video_link }}" type="video/mp4">
            </video>
        @elseif ($footerAd->type == 'local')
            <a href="{{ $footerAd->url ?? '#' }}" class="ads__mid">
                <img src="{{ $footerAd->image_url }}" alt="ads" />
            </a>
        @endif
    </div>
    <!-- Ads End -->
@endif

<!-- Footer Section Start -->
<footer class="footer__section">
    <div class="container-fluid">
        <div class="footer__wrapper">
            <div class="row">
                <div class="col-xl-3 col-lg-5 col-md-6 col-sm-12">
                    <div class="footer__widget">
                        <div class="logo">
                            <a href="{{ route('home') }}"><img
                                    src="{{ getFileLink('original_image', get_config('light_logo'), 'logos', '360x95', 'original') }}"
                                    alt="footer-logo" /></a>
                        </div>
                        <p>{{ get_config('high_lighted_text') }}</p>
                    </div>
                </div>
                @if (get_config('show_payment_method_banner') == 1 ||
                        get_config('show_apple_device_btn_banner') == 1 ||
                        get_config('show_android_device_btn_banner') == 1)

                    <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-xs-6 order-3">
                        <div class="footer__widget">

                            @if (get_config('show_apple_device_btn_banner') == 1 ||
                                    get_config('show_android_device_btn_banner') == 1 ||
                                    get_config('show_android_tv_btn_banner') == 1)
                                <h4 class="widget__title">{{ __('download_our_app') }}</h4>
                                <div class="app__wrapper">
                                    @if (get_config('show_apple_device_btn_banner') == 1)
                                        <a href="{{ get_config('android_device_btn_link') }}"> <img
                                                src="{{ static_asset('website/images/app-store.svg') }}"
                                                alt="work image" /></a>
                                    @endif
                                    @if (get_config('show_android_device_btn_banner') == 1)
                                        <a href="{{ get_config('android_device_btn_link') }}"> <img
                                                src="{{ static_asset('website/images/google-play.svg') }}"
                                                alt="work image" /></a>
                                    @endif
                                    @if (get_config('show_android_tv_btn_banner') == 1)
                                        <a href="{{ get_config('android_tv_btn_link') }}"> <img
                                                src="{{ static_asset('website/images/android-tv.svg') }}"
                                                alt="work image" /></a>
                                    @endif
                                </div>
                            @endif
                            <h4 class="widget__title"> {{ __('payment_getaway') }} </h4>
                            <div class="app__wrapper">
                                <a href="{{ route('home') }}">
                                    <img src="{{ getFileLink('original_image', get_config('payment_method_banner'), 'payment_method_banners', '683x66') }}"
                                        alt="work image" />
                                </a>
                            </div>
                        </div>
                    </div>
                @endif
                @if (get_config('show_legal_page_links') == 1)
                    <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-xs-6">
                        <div class="footer__widget">
                            <h4 class="widget__title"> {{ __('legal_page') }} </h4>
                            <ul class="widget__list">
                                <li>
                                    <a href="{{ get_config('terms_and_conditions') }}"><i
                                            class="ri-arrow-right-s-line"></i>
                                        {{ __('terms_&_conditions') }} </a>
                                </li>
                                <li>
                                    <a href="{{ get_config('privacy_policy_link') }}"><i
                                            class="ri-arrow-right-s-line"></i>
                                        {{ __('privacy_policy') }} </a>
                                </li>
                                <li>
                                    <a href="{{ get_config('payment_policy_link') }}"><i
                                            class="ri-arrow-right-s-line"></i>
                                        {{ __('payment_policy') }} </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                @endif
                @if (get_config('show_help_center_links') == 1)
                    <div class="col-xl-2 col-lg-3 col-md-4 col-sm-4 col-xs-6">
                        <div class="footer__widget">
                            <h4 class="widget__title"> {{ __('help_center') }} </h4>
                            <ul class="widget__list">
                                <li>
                                    <a href="{{ route('faqs') }}"><i class="ri-arrow-right-s-line"></i>
                                        {{ __('faqs') }} </a>
                                </li>
                                <li>
                                    <a href="{{ route('contact-us') }}"><i class="ri-arrow-right-s-line"></i>
                                        {{ __('contact') }} </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                @endif
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-xs-6">
                    <div class="footer__widget">
                        <h4 class="widget__title"> {{ __('contact_us') }} </h4>
                        <ul class="widget__list">
                            <li>
                                <a href="tel:+{{ get_config('business_phone') }}"><i class="ri-phone-line"></i>
                                    {{ get_config('business_phone') }} </a>
                            </li>
                            <li>
                                <a href="mailto:{{ get_config('contact_email') }}"><i class="ri-mail-line"></i>
                                    {{ __('email') }} : {{ get_config('contact_email') }} </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="footer__bottom">
            <div class="row">
                <div class="col-12">
                    <div class="footer__content">
                        @if (get_config('show_social_links') == 1)
                            <div class="social__icon">
                                <h6 class="title">{{ __('follow_us') }}</h6>
                                <ul class="social__list">
                                    <li> <a href="{{ get_config('facebook_link') }}"><i
                                                class="ri-facebook-fill"></i></a>
                                    </li>
                                    <li><a href="{{ get_config('instagram_link') }}"><i
                                                class="ri-instagram-line"></i></a>
                                    </li>
                                    <li><a href="{{ get_config('linkedin_link') }}"><i
                                                class="ri-linkedin-fill"></i></a>
                                    </li>
                                    <li><a href="{{ get_config('pinterest_link') }}"><i
                                                class="ri-pinterest-line"></i></a>
                                    </li>
                                    <li><a href="{{ get_config('twitter_link') }}"><i
                                                class="ri-twitter-x-line"></i></a>
                                    </li>
                                </ul>
                            </div>
                        @endif
                        @if (get_config('show_copyright') == 1)
                            <div class="content">
                                <p>{{ get_config('admin_panel_copyright_text') }}</p>
                            </div>
                        @endif

                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- Footer Section End -->
