@php
    // Determine if this is a detail page and get the meta source
    $isDetail = request()->is('movie-details/*') ||
                request()->is('tv-shows-details/*') ||
                request()->is('tv-season-details/*') ||
                request()->is('tv-episode-details/*') ||
                request()->is('blog-details/*');

    $meta = null;
    if ($isDetail) {
        if (isset($movie)) {
            $meta = $movie;
        } elseif (isset($tv_show)) {
            $meta = $tv_show;
        } elseif (isset($blog)) {
            $meta = $blog;
        } elseif (isset($tv_season)) {
            $meta = $tv_season;
        } elseif (isset($tv_episode)) {
            $meta = $tv_episode;
        } elseif (isset($tv_channel)) {
            $meta = $tv_channel;
        }
    }
@endphp

@if ($isDetail && $meta)
    <!-- SEO -->
    <meta name="title" content="{{ $meta->seo_title ?? $meta->title ?? get_config('meta_title') }}" />
    <meta name="description" content="{{ $meta->meta_description ?? get_config('meta_description') }}" />
    <meta name="keywords" content="{{ $meta->focus_keyword ?? get_config('meta_keywords') }}" />
    <meta name="author" content="{{ get_config('author_name') }}">
    <!-- END SEO -->

    <!-- Open Graph -->
    <meta property="og:title" content="{{ $meta->seo_title ?? $meta->title ?? get_config('og_title') }}" />
    <meta property="og:description" content="{{ $meta->meta_description ?? get_config('meta_description') }}" />
    <meta property="og:url" content="{{ url()->current() }}" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="{{ app()->getLocale() }}" />
    <meta property="og:site_name" content="{{ get_config('system_name') }}" />
    <meta property="og:image" content="
        @if (request()->is('blog-details/*'))
            {{ getFileLink('original_image', $meta->image ?? '', 'blogs', '1200x630', 'original') }}
        @else
            {{ getFileLink('original_image', $meta->thumbnail ?? '', 'movies', '1200x630', 'original') }}
        @endif
    " />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <!-- END Open Graph -->

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="{{ get_config('system_name') }}" />
    <meta name="twitter:creator" content="{{ get_config('author_name') }}" />
    <meta name="twitter:title" content="{{ $meta->seo_title ?? $meta->title ?? get_config('meta_title') }}" />
    <meta name="twitter:description" content="{{ $meta->meta_description ?? get_config('meta_description') }}" />
    <meta name="twitter:image" content="
        @if (request()->is('blog-details/*'))
            {{ getFileLink('original_image', $meta->image ?? '', 'blogs', '1200x630', 'original') }}
        @else
            {{ getFileLink('original_image', $meta->thumbnail ?? '', 'movies', '1200x630', 'original') }}
        @endif
    " />
@else
    <!-- SEO -->
    <meta name="title" content="{{ get_config('meta_title') }}" />
    <meta name="description" content="{{ get_config('meta_description') }}" />
    <meta name="keywords" content="{{ get_config('meta_keywords') }}" />
    <meta name="author" content="{{ get_config('author_name') }}">
    <!-- END SEO -->

    <!-- Open Graph -->
    <meta property="og:title" content="{{ get_config('og_title') }}" />
    <meta property="og:description" content="{{ get_config('meta_description') }}" />
    <meta property="og:url" content="{{ url('/') }}" />
    <meta property="og:type" content="website" />
    <meta property="og:locale" content="{{ app()->getLocale() }}" />
    <meta property="og:site_name" content="{{ get_config('system_name') }}" />
    <meta property="og:image" content="{{ getFileLink('original_image', get_config('og_image'), 'og_images', '80x80') }}" />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <!-- END Open Graph -->

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:site" content="{{ get_config('system_name') }}" />
    <meta name="twitter:creator" content="{{ get_config('author_name') }}" />
    <meta name="twitter:title" content="{{ get_config('meta_title') }}" />
    <meta name="twitter:description" content="{{ get_config('meta_description') }}" />
    <meta name="twitter:image" content="{{ getFileLink('original_image', get_config('og_image'), 'og_images', '80x80') }}" />
@endif
