@php
    $sidebarAd1 = get_ads('movie_details_sidebar_1', '300x250', 'object');
    $sidebarAd2 = get_ads('movie_details_sidebar_2', '300x600', 'object');
@endphp

@if ($sidebarAd1)
    <div class="mb-4 d-block">
        @if ($sidebarAd1->type == 'google')
            <div class="ads__google">{!! $sidebarAd1->google_ads_code !!}</div>
        @elseif ($sidebarAd1->type == 'mp4')
            <video class="ads__video" width="100%" height="250" autoplay loop muted>
                <source src="{{ $sidebarAd1->video_link }}" type="video/mp4">
            </video>
        @elseif ($sidebarAd1->type == 'local')
            <a href="{{ $sidebarAd1->url ?? '#' }}" class="ads__mid">
                <img src="{{ $sidebarAd1->image_url }}" alt="ads-img" />
            </a>
        @endif
    </div>
@endif

@if ($sidebarAd2)
    <div>
        @if ($sidebarAd2->type == 'google')
            <div class="ads__google">{!! $sidebarAd2->google_ads_code !!}</div>
        @elseif ($sidebarAd2->type == 'mp4')
            <video class="ads__video" width="300" height="600" autoplay loop muted>
                <source src="{{ $sidebarAd2->video_link }}" type="video/mp4">
            </video>
        @elseif ($sidebarAd2->type == 'local')
            <a href="{{ $sidebarAd2->url ?? '#' }}" class="ads__mid">
                <img src="{{ $sidebarAd2->image_url }}" alt="ads-img" />
            </a>
        @endif
    </div>
@endif
