@php
    $currentYear = now()->year;
    $startYear = 1975;
    $years = range($currentYear, $startYear);

@endphp

<!-- Sidebar Start -->
<div class="sidebar">
    <div class="widget">
        <div class="header__search mw-100">
            <button type="submit"><i class="ri-search-line"></i></button>
            <input type="search" name="search" id="search" class="form-control" placeholder="Search" />
        </div>
    </div>
    <div class="widget">
        <h4 class="widget__title">{{ __('blog_categories') }}</h4>
        <div class="widget__info">
            @foreach (blogCategories() as $index => $category)
                <div class="custom__checkbox {{ $index >= 5 ? 'extra-category d-none' : '' }}">
                    <input type="checkbox" name="category_filter[]" class="category-checkbox" id="cat_{{ $category->id }}"
                        value="{{ $category->id }}" />
                    <label for="cat_{{ $category->id }}">{{ $category->title }}</label>
                </div>
            @endforeach

            @if (blogCategories()->count() > 5)
                <a href="javascript:void(0)" class="view__btn" id="toggleCategories">{{ __('view_all') }}</a>
            @endif
        </div>
    </div>
    <div class="widget">
        <h4 class="widget__title">{{ __('year') }}</h4>
        <div class="widget__info">
            @foreach ($years as $index => $year)
                <div class="custom__checkbox {{ $index >= 10 ? 'extra-year d-none' : '' }}">
                    <input type="checkbox" name="year_filter[]" class="year-checkbox" id="year_{{ $year }}"
                        value="{{ $year }}" {{ $year == $currentYear ? 'checked' : '' }} />
                    <label for="year_{{ $year }}">{{ $year }}</label>
                </div>
            @endforeach

            <a href="javascript:void(0)" class="view__btn" id="toggleYears">{{ __('view_all') }}</a>
        </div>
    </div>

    <div class="widget">
        <h4 class="widget__title">{{ __('top_5_blogs') }}</h4>
        <div class="post__wrapper">
            @foreach ($top_blogs as $blog)
                <!-- Post Item -->
                <div class="postItem">
                    <a href="{{ route('blog.details', ['id' => $blog->id, 'slug' => slugify($blog->title)]) }}"
                        class="postThumb">
                        <img src="{{ getFileLink('thumbnail', $blog->image, 'movies', '80x100') }}"
                            alt="postthumb" />
                    </a>
                    <div class="post__content">
                        <span class="date">{{ date('Y', strtotime($blog->created_at)) }}</span>
                        <h4 class="title">
                            <a href="{{ route('blog.details', ['id' => $blog->id, 'slug' => slugify($blog->title)]) }}">
                                {{ $blog->title }} </a>
                        </h4>
                        <p class="desc"> {{ $blog->focus_keyword }} </p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>