@foreach ($blogs as $blog)
    <div class="blogCard">
        @if ($blog->is_top > 0)
            <div class="badge">{{__('top_news')}}</div>
        @endif
        <a href="{{route('blog.details', ['slug' => slugify($blog->title)])}}" class="blogCard__thumb">
            <img src="{{ getFileLink('thumbnail', $blog->image, 'blogs', '540x280') }}"
                alt="blog" />
        </a>
        <div class="blogCard__content">
            <h4 class="title">
                <a
                    href="{{route('blog.details', ['slug' => slugify($blog->title)])}}">{{$blog->title}}</a>
            </h4>
            <p class="desc"> {{$blog->focus_keyword}} </p>
            <div class="blogCard__meta">
                <span><i class="ri-calendar-2-line"></i>{{date('d M y', strtotime($blog->created_at))}}</span>
                <a href="javascript:void(0)"><i class="ri-user-3-line"></i>{{adminInfo('first_name') . ' ' . adminInfo('last_name')}}</a>
                <a href="javascript:void(0)"><i class="ri-film-line"></i> {{$blog->category?->title}} </a>
            </div>
        </div>
    </div>
@endforeach