<div class="watch__history">
    @if (count($live_tvs) > 0)
        <div class="row mt-5">
            <div class="col-12">
                <div class="section__title">
                    <h2 class="title"> {{ __('watching_live_tv') }} </h2>
                </div>
            </div>
        </div>
        <div class="position-relative">
            <div class="swiper channel__slider">
                <div class="swiper-wrapper">
                    @foreach ($live_tvs as $item)
                        <!-- Slide -->
                        <div class="swiper-slide">
                            <a href="{{ route('live.tv.details', ['slug' => $item->channel->slug]) }}"
                                class="channel__card">
                                {{-- <div class="badge">Premium</div> --}}
                                <div class="card__thumb">
                                    <img src="{{ getFileLink('live_tv', $item->channel->thumbnail, 'live_tv_thumbs', '400x320') }}"
                                        alt="channel" />
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="swiper__navigation">
                <div class="channel-swipe-prev swiper-button-prev">
                    <i class="ri-arrow-left-s-line"></i>
                </div>
                <div class="channel-swipe-next swiper-button-next">
                    <i class="ri-arrow-right-s-line"></i>
                </div>
            </div>
        </div>
    @endif

    @if (isset($histories) && $histories->count() > 0)
        <div class="video__history mt-40">
            <div class="row">
                <div class="col-12">
                    <div class="section__title">
                        <h2 class="title"> {{ __('continue_watching') }} </h2>
                    </div>
                </div>
            </div>
            <div class="position-relative grid-6" id="watch-history-container">
                @foreach ($histories as $history)
                    @include('user.history_item')
                @endforeach
            </div>
        </div>
    @endif


    @if ($histories->hasMorePages())
        <div class="text-center mt-4">
            <a href="javascript:void(0)" id="load-more-history" class="btn btn-primary" data-page="2"
                data-url="{{ route('load.more.history') }}">
                {{ __('Load More') }}
            </a>
        </div>
    @endif

</div>

@push('js')
    <script>
        "use strict";
        document.getElementById('load-more-history').addEventListener('click', function() {
            const button = this;
            const page = button.getAttribute('data-page');
            const url = button.getAttribute('data-url');

            button.disabled = true;
            button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading...';

            fetch(`${url}?page=${page}`)
                .then(response => response.json())
                .then(data => {
                    if (data.html) {
                        document.getElementById('watch-history-container').insertAdjacentHTML('beforeend', data
                            .html);
                        button.setAttribute('data-page', parseInt(page) + 1);

                        if (!data.has_more) {
                            button.style.display = 'none';
                        }
                    }
                })
                .catch(error => console.error('Error:', error))
                .finally(() => {
                    button.disabled = false;
                    button.innerHTML = '{{ __('Load More') }}';
                });
        });
    </script>
@endpush
