<div class="userInfo__header">
    <h4 class="title">{{ __('subscription_status') }}</h4>
    @if (check_subscription())
    <a href="{{route('cancel.subscription', ['id' => get_subscription_info('id')])}}" class="cancel__btn"> {{__('cancel_plan')}} </a>
    @endif
</div>

@if (check_subscription())
<div class="subscription__plan">
    <div class="plan__card">
        <div class="plan__header">
            <div class="content">
                <div class="icon">
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_2233_9412)">
                            <path
                                d="M15.1773 3.044C14.9337 2.94252 14.6654 2.91585 14.4066 2.96738C14.1478 3.0189 13.9102 3.1463 13.724 3.33333L12 5.05733L8.94267 2C8.69263 1.75004 8.35355 1.60962 8 1.60962C7.64645 1.60962 7.30737 1.75004 7.05733 2L4 5.05733L2.276 3.33333C2.08953 3.14692 1.85198 3.01998 1.59338 2.96856C1.33477 2.91713 1.06673 2.94354 0.823127 3.04443C0.579528 3.14532 0.37131 3.31618 0.224798 3.53539C0.0782854 3.7546 5.62991e-05 4.01233 0 4.276L0 11.3333C0.00105857 12.2171 0.352588 13.0643 0.97748 13.6892C1.60237 14.3141 2.4496 14.6656 3.33333 14.6667H12.6667C13.5504 14.6656 14.3976 14.3141 15.0225 13.6892C15.6474 13.0643 15.9989 12.2171 16 11.3333V4.276C16.0001 4.01231 15.9219 3.75453 15.7755 3.53523C15.6291 3.31594 15.4209 3.14499 15.1773 3.044ZM14.6667 11.3333C14.6667 11.8638 14.456 12.3725 14.0809 12.7475C13.7058 13.1226 13.1971 13.3333 12.6667 13.3333H3.33333C2.8029 13.3333 2.29419 13.1226 1.91912 12.7475C1.54405 12.3725 1.33333 11.8638 1.33333 11.3333V4.276L3.52867 6.47133C3.65369 6.59632 3.82322 6.66653 4 6.66653C4.17678 6.66653 4.34631 6.59632 4.47133 6.47133L8 2.94267L11.5287 6.47133C11.6537 6.59632 11.8232 6.66653 12 6.66653C12.1768 6.66653 12.3463 6.59632 12.4713 6.47133L14.6667 4.276V11.3333Z"
                                fill="white"></path>
                        </g>
                    </svg>
                </div>
                <p> {{__('you_enrolled'). ' ' . get_subscription_plan('name') . ' ' . __('plan!')}} </p>
            </div>
            <span class="active__plan">● {{__('active_plan')}}</span>
        </div>

        <div class="plan__info">
            <p><span>{{__('plan_name')}}:</span> {{get_subscription_plan('name')}}</p>
            <p><span>{{__('plan_cost')}}:</span> {{get_currency(get_subscription_plan('price'))}}</p>
            <p><span>{{__('validated')}}:</span> {{get_subscription_plan('day').' '.__('days')}}</p>
            <p><span>{{__('screen_limit')}}:</span> {{get_subscription_plan('screens')}}</p>
            <p><span> {{__('expire_data')}}:</span> {{Carbon\Carbon::parse(get_subscription_plan('created_at'))->addDays(get_subscription_plan('day'))->format('d M Y') ?? __('n/a')}}</p>
            <p><span> {{__('ads')}}:</span> {{__('not_allowed')}}</p>
            <p><span>{{__('download')}}:</span> {{__('allowed')}}</p>
            <p><span>{{__('premium_content')}}:</span> {{__('allowed')}}</p>
        </div>

        <div class="plan__details">
            <h5 class="title">{{__('package_details')}}</h5>
            <ul class="list__item">
                <li>
                    <i class="ri-checkbox-circle-fill"></i>{{__('you_can_login') .' '.get_subscription_plan('screens') .' '. __('device_at_a_time')}}
                </li>
                <li><i class="ri-checkbox-circle-fill"></i> {{__('ads_free_content')}}
                </li>
                <li><i class="ri-checkbox-circle-fill"></i> {{__('switch_plans_or_cancel_anytime')}}
                </li>
                <li><i class="ri-checkbox-circle-fill"></i> {{__('world_famous_movies_dramas_tvs')}}
                </li>
                <li>
                    <i class="ri-checkbox-circle-line"></i>
                    {{ __('download_from_thousands_of_titles_to_watch_offline') }}
                </li>
                <li>
                    <i class="ri-checkbox-circle-line"></i>
                    {{ __('download_from_thousands_of_titles_to_watch') }}
                </li>
            </ul>
        </div>
    </div>
</div>
@endif