<div class="userInfo__header">
    <h4 class="title">{{ __('playlist') }}</h4>
    <span class="meta">{{ __('all') }}</span>
</div>
<div class="playlist__wrapper">
    <div class="grid-5">
        @foreach ($playLists as $playlist)
            <div class="playlist__item">
                <a href="{{ route('playlists.show', ['playlist' => $playlist->slug]) }}" class="thumb">
                    <img src="{{ getFileLink('thumbnail', $playlist->thumbnail, 'movies', '500x750') }}" alt="playlist" />
                </a>
                <div class="d-flex justify-content-between gap-10">
                    <div class="playlist__meta">
                        <a href="{{ route('playlists.show', ['playlist' => $playlist->slug]) }}" class="title">{{ $playlist->name }}</a>
                        <div class="meta">
                            <span>
                                <i class="ri-lock-line"></i>
                            </span>
                            <span>
                                <i class="ri-play-large-line"></i>
                                {{ $playlist->movies_count.' '.__('videos') }}
                            </span>
                        </div>
                    </div>
                    <div class="dropdown custom__dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <i class="ri-more-2-fill"></i>
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="movies_dropdown">
                            <li><a href="javascript:void(0)" class="dropdown-item btn-edit-playlist"
                                    data-id="{{ $playlist->id }}" data-name="{{ $playlist->name }}">
                                    {{__('edit')}}
                                </a></li>
                            <li><a href="javascript:void(0)" class="dropdown-item btn-delete-playlist"
                                    data-id="{{ $playlist->id }}">
                                    {{__('delete')}}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
