<div class="watch__history">
    <div class="userInfo__header">
        <h4 class="title">{{ __('tv_channel') }}</h4>
    </div>
    <div class="position-relative">
        <div class="swiper channel__slider">
            <div class="swiper-wrapper">
                @forelse($liveTvs as $item)
                    <div class="swiper-slide">
                        <a href="{{ route('live.tv.details', ['slug' => $item->channel->slug]) }}" class="channel__card">
                            <div class="card__thumb">
                                <img src="{{ getFileLink('live_tv', $item->channel->thumbnail, 'live_tv_thumbs', '400x320') }}" alt="channel" />
                            </div>
                        </a>
                    </div>
                @empty
                    <p>{{ __('no_live_tv_available') }}</p>
                @endforelse
            </div>
        </div>
        @if (count($liveTvs))
            <div class="swiper__navigation">
                <div class="channel-swipe-prev swiper-button-prev">
                    <i class="ri-arrow-left-s-line"></i>
                </div>
                <div class="channel-swipe-next swiper-button-next">
                    <i class="ri-arrow-right-s-line"></i>
                </div>
            </div>
        @endif
    </div>
</div>

<div class="watch__history">
    <div class="userInfo__header">
        <h4 class="title">{{ __('all_movies') }}</h4>
    </div>
    <div class="position-relative">
        <div class="swiper release__slider">
            <div class="swiper-wrapper">
                @forelse($movies as $movie)
                    <div class="swiper-slide">
                        <div class="video__card">
                            <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}" class="video__thumb">
                                <img src="{{ getFileLink('thumbnail', $movie->thumbnail, 'movies', '500x750') }}"
                                    alt="{{ __('playlist') }}" />

                                <div class="video__btn">
                                    <i class="ri-play-fill"></i>
                                </div>
                            </a>
                            @if ($movie->is_free == 1)
                            @elseif ($movie->is_rental == 1)
                                <div class="badge bg-purple">
                                    {{ __('rent:') . ' ' . get_currency($movie->rental_price) }}
                                </div>
                            @else
                                <div class="badge"> {{ __('premium') }} </div>
                            @endif
                            <div class="video__content">
                                <div class="content__left">
                                    <a href="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                        class="title">{{ $movie->name }}</a>
                                    <div class="video__meta">
                                        <div class="meta__item">
                                            {{ date('Y', strtotime($movie->release)) }}
                                        </div>
                                        <div class="meta__item">
                                            {{ get_rating($movie->imdb_rating) }}
                                        </div>
                                        <div class="meta__item">{{ $movie->duration }}</div>
                                    </div>
                                    <div class="video__tag">
                                        <span>{{ get_movie_genre($movie->genre) }}</span>
                                        @if (get_movie_category($movie->video_type))
                                            <span>{{ get_movie_category($movie->video_type) }}</span>
                                        @endif
                                        <span>{{ get_movie_quality($movie->video_quality) }}</span>
                                    </div>
                                </div>
                                <div class="content__right">
                                    <div class="action__btn">
                                        <a href="javascript:void(0)" class="share__btn share-btn" data-bs-toggle="modal"
                                            data-bs-placement="bottom"
                                            data-url="{{ route('movie.details', ['slug' => $movie->slug]) }}"
                                            data-bs-target="#shareModal" title="{{ __('share') }}"><i
                                                class="ri-share-line"></i></a>
                                        <a href="javascript:void(0)" data-movie-id="{{ $movie->id }}"
                                            class="open-save-playlist-modal" title="{{ __('add_playlist') }}"><i
                                                class="ri-add-line"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <p>{{ __('no_movie_available') }}</p>
                @endforelse
            </div>
        </div>
        @if (count($movies))
            <div class="swiper__navigation">
                <div class="release-swipe-prev swiper-button-prev">
                    <i class="ri-arrow-left-s-line"></i>
                </div>
                <div class="release-swipe-next swiper-button-next">
                    <i class="ri-arrow-right-s-line"></i>
                </div>
            </div>
        @endif
    </div>
</div>

<div class="watch__history">
    <div class="userInfo__header">
        <h4 class="title"> {{ __('popular_tv_shows') }} </h4>
    </div>
    <div class="position-relative">
        <div class="swiper tvShow__slider">
            <div class="swiper-wrapper">
                @forelse($tvShows as $tvShow)
                    <div class="swiper-slide">
                        <div class="video__card">
                            <a href="{{ route('series.details', ['slug' => $tvShow->slug]) }}" class="video__thumb">
                                <img src="{{ getFileLink('thumbnail', $tvShow->thumbnail, 'tv_shows', '500x750') }}"
                                    alt="{{ __('tv_show') }}" />
                                <div class="video__btn">
                                    <i class="ri-play-fill"></i>
                                </div>
                            </a>
                            @if ($tvShow->is_free == 1)
                            @elseif ($tvShow->is_rental == 1)
                                <div class="badge bg-purple">
                                    {{ __('rent:') . ' ' . get_currency($tvShow->rental_price) }}
                                </div>
                            @else
                                <div class="badge"> {{ __('premium') }} </div>
                            @endif
                            <div class="video__content">
                                <div class="content__left">
                                    <a href="{{ route('series.details', ['slug' => $tvShow->slug]) }}"
                                        class="title">{{ $tvShow->title }}</a>
                                    <div class="video__meta">
                                        <div class="meta__item">
                                            {{ date('Y', strtotime($tvShow->release)) }}
                                        </div>
                                        <div class="meta__item">
                                            {{ get_rating($tvShow->imdb_rating) }}
                                        </div>
                                        <div class="meta__item">{{ $tvShow->duration }}</div>
                                    </div>
                                    <div class="video__tag">
                                        <span>{{ get_movie_genre($tvShow->genre) }}</span>
                                        @if (get_movie_category($tvShow->video_type))
                                            <span>{{ get_movie_category($tvShow->video_type) }}</span>
                                        @endif
                                        <span>{{ get_movie_quality($tvShow->video_quality) }}</span>
                                    </div>
                                </div>
                                <div class="content__right">
                                    <div class="action__btn">
                                        <a href="javascript:void(0)" class="share__btn share-btn" data-bs-toggle="modal"
                                            data-bs-placement="bottom"
                                            data-url="{{ route('series.details', ['slug' => $tvShow->slug]) }}"
                                            data-bs-target="#shareModal" title="{{ __('share') }}"><i
                                                class="ri-share-line"></i></a>
                                        <a href="javascript:void(0)" data-movie-id="{{ $tvShow->id }}"
                                            class="open-save-playlist-modal" title="{{ __('add_playlist') }}"><i
                                                class="ri-add-line"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <p>{{ __('no_tv_shows_available') }}</p>
                @endforelse
            </div>
        </div>
        @if (count($tvShows))
            <div class="swiper__navigation">
                <div class="tvShow-swipe-prev swiper-button-prev">
                    <i class="ri-arrow-left-s-line"></i>
                </div>
                <div class="tvShow-swipe-next swiper-button-next">
                    <i class="ri-arrow-right-s-line"></i>
                </div>
            </div>
        @endif
    </div>
</div>
