@extends('website.layouts.master')
@section('title', __('user_dashboard'))
@section('content')

    <!-- user_dashboard Start -->
    <section class="user__dashboard pt-75 pb-120">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- User Panel Start -->
                    <div class="user__pannel">
                        <div class="user__wrapper">
                            <div class="user__thumb">
                                <img src="{{ getFileLink('original_image', auth()->user()->image, 'users', '100x100') }}"
                                    alt="user-thumb" />
                            </div>
                            <div class="user__info">
                                <h4 class="title">{{ auth()->user()->first_name . ' ' . auth()->user()->last_name }}</h4>
                                <span>{{ auth()->user()->email }}</span>
                            </div>
                        </div>
                        <div class="user__wrapper">
                            <a href="{{ route('logout') }}" class="logOut"><i
                                    class="ri-logout-box-r-line"></i>{{ __('logout') }}</a>
                        </div>
                    </div>
                    <!-- User Panel End -->

                    <!-- User Tab Start -->
                    <div class="userTab__area mt-20">
                        <!-- Tab Header -->
                        <div class="tabHeader">
                            <div class="tablist">
                                <div class="custom__tabs text-center">
                                    <ul class="nav nav-pills" id="pills-tab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link {{ $tab == 'account' ? 'active' : '' }}"
                                                id="account-tab" data-bs-toggle="pill" data-bs-target="#account"
                                                type="button" role="tab" aria-controls="account" aria-selected="true">
                                                {{ __('my_account') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link {{ $tab == 'watch-history' ? 'active' : '' }}"
                                                id="watch_history-tab" data-bs-toggle="pill" data-bs-target="#watch_history"
                                                type="button" role="tab" aria-controls="watch_history"
                                                aria-selected="false" tabindex="-1">
                                                {{ __('watch_history') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link {{ $tab == 'favorite' ? 'active' : '' }}"
                                                id="favorite-tab" data-bs-toggle="pill" data-bs-target="#favorite"
                                                type="button" role="tab" aria-controls="favorite" aria-selected="false"
                                                tabindex="-1">
                                                {{ __('favorite') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link {{ $tab == 'playlist' ? 'active' : '' }}"
                                                id="playlist-tab" data-bs-toggle="pill" data-bs-target="#playlist"
                                                type="button" role="tab" aria-controls="playlist" aria-selected="false"
                                                tabindex="-1">
                                                {{ __('playlist') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link {{ $tab == 'subscription' ? 'active' : '' }}"
                                                id="subscription-_historytab" data-bs-toggle="pill"
                                                data-bs-target="#subscription_history" type="button" role="tab"
                                                aria-controls="subscription_history" aria-selected="false" tabindex="-1">
                                                {{ __('subscription') }}
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link {{ $tab == 'payment_history' ? 'active' : '' }}"
                                                id="payment_history-tab" data-bs-toggle="pill"
                                                data-bs-target="#payment_history" type="button" role="tab"
                                                aria-controls="payment_history" aria-selected="false" tabindex="-1">
                                                {{ __('payment_history') }}
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="subscription__btn">
                                <a href="{{ route('packages') }}" class="btn btn-primary">
                                    @if (check_subscription())
                                        {{ __('update_subscription') }}
                                    @else
                                        {{ __('subscription') }}
                                    @endif
                                </a>
                            </div>
                        </div>
                        <!-- Tab Content Start -->
                        <div class="tab-content">
                            <div class="tab-pane fade show {{ $tab == 'account' ? 'active' : '' }}" id="account"
                                role="tabpanel">
                                @include('user.account')
                            </div>
                            <div class="tab-pane fade show {{ $tab == 'watch-history' ? 'active' : '' }}"
                                id="watch_history" role="tabpanel">
                                @include('user.watch_history')
                            </div>
                            <div class="tab-pane fade show {{ $tab == 'favorite' ? 'active' : '' }}" id="favorite"
                                role="tabpanel">
                                @include('user.favorite')
                            </div>
                            <div class="tab-pane fade show {{ $tab == 'subscription' ? 'active' : '' }}"
                                id="subscription_history" role="tabpanel">
                                @include('user.subscription')
                            </div>
                            <div class="tab-pane fade show {{ $tab == 'playlist' ? 'active' : '' }}" id="playlist"
                                role="tabpanel">
                                @include('user.playlist')
                            </div>

                            <div class="tab-pane fade show {{ $tab == 'payment_history' ? 'active' : '' }}"
                                id="payment_history" role="tabpanel">
                                @include('user.payment_history')
                            </div>
                        </div>
                    </div>
                    <!-- User Tab End -->
                </div>
            </div>
        </div>
    </section>
    <!-- user_dashboard End -->
    <!-- modal to update user details -->
    <!-- Edit Info Modal Start -->
    <div class="modal fade custom__popup" id="editUserDetailsModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered mw-60">
            <div class="modal-content">
                <div class="modal-header">
                    <!-- <h2 class="form__title" id="loginLabel">Edit</h2> -->
                    <button type="button" class="close ms-auto" data-bs-dismiss="modal" aria-label="Close">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body p-0">
                    <div class="form__wrapper mw-100 pb-30">
                        <form action="{{ route('update.user.details') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="heading__content">
                                <h4 class="title"> {{ __('edit_details') }} </h4>
                                <p class="desc"> {{ __('please_enter_your_details') }} </p>
                            </div>
                            <hr />
                            <div class="flex__input">
                                <div class="form-group">
                                    <label for="first_name" class="form-label">{{ __('first_name') }}</label>
                                    <input type="text" class="form-control" id="first_name" name="first_name"
                                        value="{{ old('first_name', Auth::user()->first_name) }}">
                                </div>
                                <div class="form-group mb-3">
                                    <label for="last_name" class="form-label">{{ __('last_name') }}</label>
                                    <input type="text" class="form-control" id="last_name" name="last_name"
                                        value="{{ old('last_name', Auth::user()->last_name) }}">
                                </div>
                            </div>
                            <div class="flex__input">
                                <div class="form-group">
                                    <label for="email" class="form-label">{{ __('email') }}</label>
                                    <input type="email" class="form-control" id="email" name="email"
                                        value="{{ old('email', Auth::user()->email) }}">
                                </div>
                                <div class="form-group">
                                    <label for="phone" class="form-label">{{ __('phone') }}</label>
                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="{{ old('phone', Auth::user()->phone) }}">
                                </div>
                            </div>
                            <div class="flex__input">
                                <div class="form-group">
                                    <label for="date_of_birth" class="form-label">{{ __('date_of_birth') }}</label>
                                    <input type="date" class="form-control" id="date_of_birth" name="date_of_birth"
                                        value="{{ old('date_of_birth', Auth::user()->date_of_birth) }}">
                                </div>
                                <div class="form-group">
                                    <label for="profile" class="form-label">{{ __('profile_image') }}</label>
                                    <input type="file" class="form-control" id="profile" name="profile">
                                </div>
                            </div>
                            <div class="flex__input">
                                <div class="form-group">
                                    <label for="current_password" class="form-label">{{ __('current_password') }}</label>
                                    <input type="password" class="form-control" id="current_password"
                                        name="current_password" placeholder="{{ __('current_password') }}">
                                </div>
                                <div class="form-group">
                                    <label for="new_password" class="form-label">{{ __('new_password') }}</label>
                                    <input type="password" class="form-control" id="new_password" name="new_password"
                                        placeholder="{{ __('new_password') }}">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="dateOf-birth"> {{ __('gender') }} </label>
                                <div class="d-flex align-items-center gap-5">
                                    <div class="form-check mb-0">
                                        <input class="form-check-input" type="radio" name="gender" id="male"
                                            value="1"
                                            {{ old('gender', Auth::user()->gender) == '1' ? 'checked' : '' }} />
                                        <label class="form-check-label" for="male"> {{ __('male') }} </label>
                                    </div>
                                    <div class="form-check mb-0">
                                        <input class="form-check-input" type="radio" name="gender" id="female"
                                            value="2"
                                            {{ old('gender', Auth::user()->gender) == '2' ? 'checked' : '' }} />
                                        <label class="form-check-label" for="female"> {{ __('female') }} </label>
                                    </div>
                                    <div class="form-check mb-0">
                                        <input class="form-check-input" type="radio" name="gender" id="others"
                                            value="0"
                                            {{ old('others', Auth::user()->gender) == '0' ? 'checked' : '' }} />
                                        <label class="form-check-label" for="others"> {{ __('others') }} </label>
                                    </div>
                                </div>
                            </div>
                            <hr />
                            <div class="btn__group text-end">
                                <button type="submit" name="btn" class="btn btn-primary"> {{ __('update') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Edit Info Modal End-->

    <!-- add edit modal for playlist -->
    <div class="modal fade" id="editPlaylistModal" tabindex="-1" aria-labelledby="editPlaylistModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <form id="editPlaylistForm">
                @csrf
                @method('PUT')
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('edit_playlist') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="playlist_id">
                        <div class="mb-3">
                            <label for="playlist_name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="playlist_name" name="name">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">{{ __('save_changes') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script>
        "use strict";
        $(document).ready(function() {
            $('.btn-edit-playlist').on('click', function() {
                const id = $(this).data('id');
                const name = $(this).data('name');

                $('#playlist_id').val(id);
                $('#playlist_name').val(name);

                new bootstrap.Modal(document.getElementById('editPlaylistModal')).show();
            });

            $('#editPlaylistForm').on('submit', function(e) {
                e.preventDefault();

                const id = $('#playlist_id').val();
                const formData = new FormData(this);
                var url = "{{ route('playlists.update', ['playlist' => ':id']) }}";
                url = url.replace(':id', id);

                $.ajax({
                    url: url,
                    method: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    headers: {
                        'X-CSRF-TOKEN': formData.get('_token'),
                        'Accept': 'application/json',
                    },
                    success: function(data) {
                        location.reload();
                    },
                    error: function(xhr) {
                        console.error(xhr.responseJSON);
                    }
                });
            });

            $('.btn-delete-playlist').on('click', function() {
                const id = $(this).data('id');
                const $el = $(this).closest('.playlist__item');
                var url = "{{ route('playlists.destroy', ['playlist' => ':id']) }}";
                url = url.replace(':id', id);
                Swal.fire({
                    title: '{{ __('are_you_sure') }}',
                    text: "{{ __('this_playlist_will_be_deleted') }}",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: '{{ __('yes_delete_it') }}',
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: url,
                            method: 'DELETE',
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function(data) {
                                Swal.fire('{{ __('Deleted!') }}',
                                    '{{ __('playlist_deleted') }}', 'success');
                                $el.remove();
                            },
                            error: function() {
                                Swal.fire('{{ __('Error!') }}',
                                    '{{ __('something_went_wrong') }}', 'error');
                            }
                        });
                    }
                });
            });
        });
    </script>
@endpush
