<div class="p-5">
    <div class="heading__content">
        <h2 class="title">{{ __('login_with_phone!') }}</h2>
        <p class="desc">{{ __('please_enter_your_phone_number') }}</p>
    </div>
    <div class="form-group">
        <label for="login-phone">
            {{ __('phone_number') }}
            <span class="required">*</span>
        </label>
        <input type="phone" class="form-control" name="phone" id="phone"
            placeholder="{{ __('your_phone_number_with_country_code') }}" />
        <span id="error-phone" class="text-danger"></span>
    </div>
    <div id="recaptcha-container"></div>

    <button type="button" id="sendOTP" name="btn" class="btn btn-primary w-100">{{ __('sent_code') }}</button>
</div>


<script>
    "use strict";
    $(document).ready(function() {
        $('#sendOTP').on('click', function() {
            const phoneNumber = $('#phone').val();
            const phoneRegex = /^\+\d{10,15}$/;

            let cleanedPhone = phoneNumber.replace(/[\s\-()]/g, '');

            if (!cleanedPhone) {
                $('#error-phone').text("{{ __('phone_number_is_required') }}");
                return;
            }

            if (!phoneRegex.test(cleanedPhone)) {
                $('#error-phone').text("{{ __('phone_with_country_code') }}");
                return;
            }

            $('#error-phone').text("");

            $.ajax({
                url: 'auth/send-otp',
                method: 'POST',
                data: {
                    phone: cleanedPhone,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    ajaxModal('modal-md', 'auth/verify/otp?phone=' + cleanedPhone);
                    toastr.success('otp sent')
                },
                error: function() {
                    $('#error-phone').text("{{ __('failed_to_send_otp') }}");
                    toastr.error('error while sending otp')

                }
            });
        });

    });
</script>
