@extends('admin.layouts.master')
@section('title', __('theme_options'))
@section('content')
    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                @include('admin.website.sidebar_component')
                <div class="col-xxl-9 col-lg-8 col-md-8">
                    <h3 class="section-title">{{ __('theme_options') }}</h3>
                    <div class="bg-white redious-border p-20 p-sm-30">
                        <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                            <form action="{{ route('admin.theme.options.post') }}" method="POST" class="form"
                                enctype="multipart/form-data">@csrf
                                <input type="hidden" name="menu_name" value="header_menu">
                                <div class="row gx-20">
                                    <div class="col-lg-12 input_file_div mb-4">
                                        <div class="mb-3">
                                            <label class="form-label mb-1">{{ __('light_logo') }}
                                                ({{ __('360x95') }})</label>
                                            <label for="light_logo" class="file-upload-text">
                                                <p>{{ __('select_file_from_device') }}</p>
                                                <span class="file-btn">{{ __('choose_file') }}</span>
                                            </label>
                                            <input class="d-none file_picker" type="file" id="light_logo"
                                                name="light_logo" accept=".jpg,.png">
                                            <div class="nk-block-des text-danger">
                                                <p class="light_logo_error error">{{ $errors->first('light_logo') }}</p>
                                            </div>
                                        </div>
                                        <div class="selected-files d-flex flex-wrap gap-20">
                                            <div class="selected-files-item">
                                                <img class="selected-img"
                                                    src="{{ getFileLink('original_image', get_config('light_logo'), 'light_logos', '360x95') }}"
                                                    alt="light_logo">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 input_file_div mb-4">
                                        <div class="mb-3">
                                            <label class="form-label mb-1">{{ __('favicon (96x96)') }}</label>
                                            <label for="favicon" class="file-upload-text">
                                                <p>{{ __('select_file_from_device') }}</p>
                                                <span class="file-btn">{{ __('choose_file') }}</span>
                                            </label>
                                            <input class="d-none file_picker" type="file" id="favicon" name="favicon"
                                                accept=".jpg,.png">
                                            <div class="nk-block-des text-danger">
                                                <p class="favicon_error error">{{ $errors->first('favicon') }}</p>
                                            </div>
                                        </div>
                                        <div class="selected-files d-flex flex-wrap gap-20">
                                            <div class="selected-files-item">
                                                <img class="selected-img"
                                                    src="{{ getFileLink('original_image', get_config('favicon'), 'favicons', '96x96') }}"
                                                    alt="favicon">
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-lg-12 input_file_div mb-4">
                                        <div class="mb-3">
                                            <label class="form-label mb-1">{{ __('promotion (1700x275)') }}</label>
                                            <label for="promotion" class="file-upload-text">
                                                <p>{{ __('select_file_from_device') }}</p>
                                                <span class="file-btn">{{ __('choose_file') }}</span>
                                            </label>
                                            <input class="d-none file_picker" type="file" id="promotion" name="promotion"
                                                accept=".jpg,.png">
                                            <div class="nk-block-des text-danger">
                                                <p class="promotion_error error">{{ $errors->first('promotion') }}</p>
                                            </div>
                                        </div>
                                        <div class="selected-files d-flex flex-wrap gap-20">
                                            <div class="selected-files-item">
                                                <img class="selected-img"
                                                    src="{{ getFileLink('original_image', get_config('promotion'), 'settingss', '1700x275') }}"
                                                    alt="promotion">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 input_file_div mb-4">
                                        <div class="mb-3">
                                            <label for="promo_movie" class="form-label">{{ __('promo_movie') }}</label>
                                            <select class="form-select form-select-lg mb-3 with_search" name="promo_movie"
                                                id="promo_movie">
                                                <option value=""> {{ __('select_movie') }}</option>
                                                @foreach ($movies as $movie)
                                                    <option value="{{ $movie->id }}"
                                                        {{ get_config('promo_movie') == $movie->id ? 'selected' : '' }}>
                                                        {{ $movie->title }}</option>
                                                @endforeach
                                            </select>
                                            <div class="nk-block-des text-danger">
                                                <p class="error">{{ $errors->first('promo_movie') }}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 input_file_div mb-4">
                                        <div class="mb-3">
                                            <label class="form-label mb-1">{{ __('logo_for_player(130x50)') }}</label>
                                            <label for="player_logo" class="file-upload-text">
                                                <p>{{ __('select_file_from_device') }}</p>
                                                <span class="file-btn">{{ __('choose_file') }}</span>
                                            </label>
                                            <input class="d-none file_picker" type="file" id="player_logo" name="player_logo"
                                                accept=".jpg,.png">
                                            <div class="nk-block-des text-danger">
                                                <p class="player_logo_error error">{{ $errors->first('player_logo') }}</p>
                                            </div>
                                        </div>
                                        <div class="selected-files d-flex flex-wrap gap-20">
                                            <div class="selected-files-item">
                                                <img class="selected-img"
                                                    src="{{ getFileLink('original_image', get_config('player_logo'), 'player_logos', '130x50') }}"
                                                    alt="favicon">
                                            </div>
                                        </div>
                                    </div>



                                    <div class="d-flex justify-content-between align-items-center mt-30">
                                        <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                        @include('admin.common.loading-btn', [
                                            'class' => 'btn sg-btn-primary',
                                        ])
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>

    @include('admin.website.component.new_menu')
@endsection
