@extends('admin.layouts.master')
@section('title', __('app_link_settings'))
@section('content')
    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                @include('admin.website.sidebar_component')
                <div class="col-xxl-9 col-lg-8 col-md-8">
                    <h3 class="section-title">{{ __('app_link_settings') }}</h3>
                    <div
                        class="default-tab-list default-tab-list-v2  bg-white redious-border website-setting-social-link p-20 p-sm-30">
                        @include('admin.website.component.footer_setting_sidebar')
                        <form action="{{ route('footer.update-setting') }}" method="POST" class="form">@csrf
                            <div class="row gx-20">
                                <div class="col-lg-6">
                                    <div class="d-flex gap-12 sandbox_mode_div mb-4">
                                        <input type="hidden" name="show_apple_device_btn_banner"
                                            value="{{ get_config('show_apple_device_btn_banner') == 1 ? 1 : 0 }}">
                                        <label class="form-label"
                                            for="show_apple_device_btn_banner">{{ __('show_apple_device_btn_banner') }}</label>
                                        <div class="setting-check">
                                            <input type="checkbox" value="1" id="show_apple_device_btn_banner"
                                                class="sandbox_mode" {{ get_config('show_apple_device_btn_banner') == 1 ? 'checked' : '' }}>
                                            <label for="show_apple_device_btn_banner"></label>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <div class="d-flex align-items-center gap-2">
                                            <label for="apple_device_btn_link"
                                                class="form-label">{{ __('apple_device_btn_link') }}</label>
                                        </div>
                                        <input type="text" class="form-control rounded-2" id="apple_device_btn_link"
                                            name="apple_device_btn_link" value="{{ get_config('apple_device_btn_link') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="apple_device_btn_link_error error"></p>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-lg-6">
                                    <div class="d-flex gap-12 sandbox_mode_div mb-4">
                                        <input type="hidden" name="show_android_device_btn_banner"
                                            value="{{ get_config('show_android_device_btn_banner') == 1 ? 1 : 0 }}">
                                        <label class="form-label"
                                            for="show_android_device_btn_banner">{{ __('show_android_device_btn_banner') }}</label>
                                        <div class="setting-check">
                                            <input type="checkbox" value="1" id="show_android_device_btn_banner"
                                                class="sandbox_mode" {{ get_config('show_android_device_btn_banner') == 1 ? 'checked' : '' }}>
                                            <label for="show_android_device_btn_banner"></label>
                                        </div>
                                    </div>


                                    <div class="mb-4">
                                        <div class="d-flex align-items-center gap-2">
                                            <label for="android_device_btn_link"
                                                class="form-label">{{ __('android_device_btn_link') }}</label>
                                        </div>
                                        <input type="text" class="form-control rounded-2" id="android_device_btn_link"
                                            name="android_device_btn_link"
                                            value="{{ get_config('android_device_btn_link') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="android_device_btn_link_error error"></p>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-lg-6">
                                    <div class="d-flex gap-12 sandbox_mode_div mb-4">
                                        <input type="hidden" name="show_android_tv_btn_banner"
                                            value="{{ get_config('show_android_tv_btn_banner') == 1 ? 1 : 0 }}">
                                        <label class="form-label"
                                            for="show_android_tv_btn_banner">{{ __('show_android_tv_btn_banner') }}</label>
                                        <div class="setting-check">
                                            <input type="checkbox" value="1" id="show_android_tv_btn_banner"
                                                class="sandbox_mode" {{ get_config('show_android_tv_btn_banner') == 1 ? 'checked' : '' }}>
                                            <label for="show_android_tv_btn_banner"></label>
                                        </div>
                                    </div>

                                    <div class="mb-4">
                                        <div class="d-flex align-items-center gap-2">
                                            <label for="android_tv_btn_link"
                                                class="form-label">{{ __('android_tv_btn_link') }}</label>
                                        </div>
                                        <input type="text" class="form-control rounded-2" id="android_tv_btn_link"
                                            name="android_tv_btn_link" value="{{ get_config('android_tv_btn_link') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="android_tv_btn_link_error error"></p>
                                        </div>
                                    </div>

                                </div>


                                <div class="d-flex justify-content-start align-items-center mt-30">
                                    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                    @include('admin.common.loading-btn', ['class' => 'btn sg-btn-primary'])
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('js')
    <script src="{{ static_asset('admin/js/countries.js') }}"></script>
@endpush