
<div class="{{ $og_title_class ?? 'col-12'}}">
    <div class="mb-4">
        <label for="og_title" class="form-label">{{__('og_title') }}</label>
        <input type="text" class="form-control rounded-2" id="og_title" name="og_title"
               placeholder="{{ __('enter_og_title') }}" value="{{ $og_title ?? '' }}">
        <div class="nk-block-des text-danger">
            <p class="og_title_error error">{{ $errors->first('og_title') }}</p>
        </div>
    </div>
</div>

<div class="{{ $og_description_class ?? 'col-12'}}">
    <div class="mb-4">
        <label for="og_description" class="form-label">{{__('og_description') }}</label>
        <textarea class="form-control" id="og_description" name="og_description" placeholder="{{ __('enter_og_description') }}">{{ $og_description ?? '' }}</textarea>
        <div class="nk-block-des text-danger">
            <p class="og_description_error error">{{ $errors->first('og_description') }}</p>
        </div>
    </div>
</div>

<div class="{{ $meta_image_class ?? 'col-12'}}">
    <div class="col-lg-12 input_file_div mb-3">
        <div class="mb-3">
            <label for="ogUpload" class="form-label mb-1">{{ __('image') }} (1200x630)</label>
            <label for="ogUpload" class="file-upload-text">
                <p>{{__('select_file_from_device') }}</p>
                <span class="file-btn">{{ __('select_file_from_device') }}</span>
            </label>
            <input class="d-none file_picker" type="file" name="og_image" id="ogUpload">
        </div>
        <div class="selected-files d-flex flex-wrap gap-20">
            <div class="selected-files-item">
                <img class="selected-img" src="{{ getFileLink('original_image', get_config('og_image'), 'og_images', '1200x630') }}" alt="favicon">
            </div>
        </div>
    </div>
</div>
