<form action="{{ route('admin.video.quality.update',['id'=> $quality->id]) }}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="mb-2">
        <label for="quality" class="form-label"> {{ __('video_quality') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="quality" name="quality" value="{{ $quality->quality }}"
            placeholder="{{ __('enter_quality_title') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('quality') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="quality" class="form-label"> {{ __('description') }} </label>
        <textarea name="description" class="form-control rounded-2" id="description" cols="30" rows="4"
            placeholder="{{ __('enter_quality_description') }}">{{ $quality->description }}</textarea>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('description') }}</p>
        </div>
    </div>
    <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
        <input type="hidden" name="status" value="{{$quality->status}}">
        <label class="form-label" for="status"> {{ __('status') }} </label>
        <div class="setting-check">
            <input type="checkbox" value="1" id="status" {{$quality->status == 1 ? 'checked':''}} class="sandbox_mode">
            <label for="status"></label>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])

</form>
