@extends('admin.layouts.master')
@section('title', __('tv_show_settings'))
@section('content')
<section class="oftions">
    <div class="container-fluid">
        <div class="row">
            <div class="col col-md-12">
                <div class="header-top d-flex justify-content-between align-items-center">
                    <h3 class="section-title">{{__('tv_show_settings') }}</h3>
                    <div class="oftions-content-right mb-12">
                        @can('admin.tv.show.add')
                        <a href="{{route('admin.tv.show.add')}}" class="d-flex align-items-center btn sg-btn-primary gap-2">
                            <i class="las la-plus"></i>
                            <span>{{__('add_tv_show') }}</span>
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-sm-6 bg-white redious-border rounded-20 p-20 p-sm-30">
                        <form action="{{route('admin.tv.show.config')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                <input type="hidden" name="tv_show_primary_menu" value="{{ configHelper('tv_show_primary_menu') ?? 0 }}">
                                <label class="form-label" for="tv_show_primary_menu"> {{ __('primary_menu') }} </label>
                                <div class="setting-check">
                                    <input type="checkbox" value="1" id="tv_show_primary_menu" {{ configHelper('tv_show_primary_menu') > 0 ? 'checked':''}} class="sandbox_mode">
                                    <label for="tv_show_primary_menu"></label>
                                </div>
                            </div>
                            <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                <input type="hidden" name="tv_show_footer_menu" value="{{ configHelper('tv_show_footer_menu') ?? 0 }}">
                                <label class="form-label" for="tv_show_footer_menu"> {{ __('footer_menu') }} </label>
                                <div class="setting-check">
                                    <input type="checkbox" value="1" id="tv_show_footer_menu" {{ configHelper('tv_show_footer_menu') > 0 ? 'checked':''}} class="sandbox_mode">
                                    <label for="tv_show_footer_menu"></label>
                                </div>
                            </div>
                            <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                <input type="hidden" name="tv_show_published" value="{{ configHelper('tv_show_published') ?? 0 }}">
                                <label class="form-label" for="tv_show_published"> {{ __('published') }} </label>
                                <div class="setting-check">
                                    <input type="checkbox" value="1" id="tv_show_published" {{ configHelper('tv_show_published') > 0 ? 'checked':''}} class="sandbox_mode">
                                    <label for="tv_show_published"></label>
                                </div>
                            </div>
                            <div class="mb-4 row align-items-center justify-content-between">
                                <div class="col-sm-6">
                                    <label for="season_order" class="form-label">{{ __('season_order') }}</label>
                                </div>
                                <div class="col-sm-6">
                                    <select class="form-select form-select-lg mb-3 with_search" name="season_order"
                                        id="season_order">
                                        <option value=""> {{ __('select_season_order') }}</option>
                                        <option value="ascending" {{configHelper('season_order') == 'ascending' ? 'selected' : ''}}> {{ __('ascending') }}</option>
                                        <option value="descending" {{configHelper('season_order') == 'descending' ? 'selected' : ''}}> {{ __('descending') }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="mb-4 row align-items-center justify-content-between">
                                <div class="col-sm-6">
                                    <label for="episode_order" class="form-label">{{ __('episode_order') }}</label>
                                </div>
                                <div class="col-sm-6">
                                    <select class="form-select form-select-lg mb-3 with_search" name="episode_order"
                                        id="episode_order">
                                        <option value=""> {{ __('select_episode_order') }}</option>
                                        <option value="ascending" {{configHelper('episode_order') == 'ascending' ? 'selected' : ''}}> {{ __('ascending') }}</option>
                                        <option value="descending" {{configHelper('episode_order') == 'descending' ? 'selected' : ''}}> {{ __('descending') }}</option>
                                    </select>
                                </div>
                            </div>
                            <button type="submit" class="btn sg-btn-primary">{{ __('save') }}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection