<form action="{{ route('admin.episode.download.store') }}" method="post" enctype="multipart/form-data"
    class="form-validate form">
    @csrf
    <input type="number" class="d-none" name="season_id" value="{{ $season_id }}">
    <div class="mb-2">
        <label for="link_title" class="form-label"> {{ __('link_title') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="link_title" name="link_title"
            value="{{ old('link_title') }}" placeholder="{{ __('enter_link_title') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('link_title') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="resolution" class="form-label"> {{ __('resolution') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="resolution" name="resolution"
            value="{{ old('resolution') }}" placeholder="{{ __('enter_resolution') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('resolution') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="file_size" class="form-label"> {{ __('file_size') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="file_size" name="file_size"
            value="{{ old('file_size') }}" placeholder="{{ __('enter_file_size') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('file_size') }}</p>
        </div>
    </div>

    <div class="mb-4">
        <label for="download_url" class="form-label"> {{ __('download_url') }} <span class="text-danger">*</span>
        </label>
        <input type="url" class="form-control rounded-2" id="download_url" name="download_url"
            value="{{ old('download_url') }}" placeholder="{{ __('enter_download_url') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('download_url') }}</p>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
</script>
