<form action="{{ route('admin.payment.config.update', ['identifier' => $gateway->identifier]) }}" method="post"
    enctype="multipart/form-data" class="form-validate form">
    @csrf

    @foreach (json_decode($gateway->config) as $key => $config)
        @if ($key == 'type')
            <div class="mb-2 mt-3">
                <label for="{{ $key }}" class="form-label"> {{ __($key) }} <span class="text-danger">*</span>
                </label>
                <select class="form-select form-select-lg mb-3 select2 with_search" name="{{ $key }}"
                    id="{{ $key }}">
                    <option value=""> {{ __('select_payment_gateway_mode') }} </option>
                    <option value="sandbox" {{ $config == 'sandbox' ? 'selected' : '' }}> {{ __('sandbox') }} </option>
                    <option value="production" {{ $config == 'production' ? 'selected' : '' }}> {{ __('production') }}
                    </option>
                </select>
                <div class="nk-block-des text-danger">
                    <p class="error">{{ $errors->first($key) }}</p>
                </div>
            </div>
        @else
            <div class="mb-2">
                <label for="{{ $key }}" class="form-label"> {{ __($key) }} <span
                        class="text-danger">*</span> </label>
                <input type="text" class="form-control rounded-2" id="{{ $key }}"
                    name="{{ $key }}" value="{{ old($key, $config) }}"
                    placeholder="{{ __('enter_' . $key) }}">
                <div class="nk-block-des text-danger">
                    <p class="error">{{ $errors->first($key) }}</p>
                </div>
            </div>
        @endif
    @endforeach

    {{-- <div class="mb-2 mt-3">
        <input type="text" class="form-control rounded-2" name="type" value="sandbox"
            placeholder="{{ __('enter_name') }}">
        <input type="text" class="form-control rounded-2" name="test_public_key" value="sandbox"
            placeholder="{{ __('enter') }}">
        <input type="text" class="form-control rounded-2" name="test_secret_key" value="sandbox"
            placeholder="{{ __('enter_name') }}">
        <input type="text" class="form-control rounded-2" name="production_public_key" value="sandbox"
            placeholder="{{ __('enter_name') }}">
        <input type="text" class="form-control rounded-2" name="production_secret_key" value="sandbox"
            placeholder="{{ __('enter_name') }}">
    </div> --}}

    <button type="submit" class="btn sg-btn-primary mt-3">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
</script>
