<form action="{{ route('create.subscription') }}" method="post" class="form" enctype="multipart/form-data">
    @csrf
    <div class="">
        <div class="row gx-20 add-coupon">
            <div class="col-lg-12">
                <div class="mb-2">
                    <label for="client_id" class="form-label">{{ __('client') }}<span
                            class="text-danger">*</span></label>
                    <select class="form-select rounded-0 w-100 mb-3 select2 with_search" aria-label=".form-select-lg example"
                        id="client_id" name="client_id">
                        <option value="" selected>{{ __('select_client') }}</option>
                        @foreach ($clients as $client)
                            <option value="{{ $client->id }}">{{ $client->company_name }}</option>
                        @endforeach
                    </select>
                    <div class="nk-block-des text-danger">
                        <p class="client_id_error error"></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="mb-2">
                    <label for="plan_id" class="form-label">{{ __('plan') }}<span
                            class="text-danger">*</span></label>
                    <select class="form-select rounded-0 mb-3 select2 without_search w-100"
                        aria-label=".form-select-lg example" id="plan_id" name="plan_id">
                        <option value="" selected>{{ __('select_plan') }}</option>
                        @foreach ($packages as $plan)
                            <option value="{{ $plan->id }}" data-price="{{ $plan->price }}">{{ $plan->name }} -
                                {{ __($plan->type) }}</option>
                        @endforeach
                    </select>
                    <div class="nk-block-des text-danger">
                        <p class="plan_id_error error"></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="mb-2">
                    <label for="transaction_id" class="form-label">{{ __('transaction_id') }}<span
                            class="text-danger">*</span></label>
                    <input type="text" class="form-control rounded-2" id="transaction_id" name="transaction_id"
                        placeholder="{{ __('transaction_id') }}">
                    <div class="nk-block-des text-danger">
                        <p class="transaction_id_error error"></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="mb-2">
                    <label for="price" class="form-label">{{ __('price') }}<span
                            class="text-danger">*</span></label>
                    <input type="number" class="form-control rounded-2" id="price" name="price"
                        placeholder="{{ __('price') }}">
                    <div class="nk-block-des text-danger">
                        <p class="price_error error"></p>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-end align-items-center mt-30">
                <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                @include('.layouts.loading_button', ['class' => 'btn sg-btn-primary'])
            </div>
        </div>
    </div>
</form>

<script>
    "use strict";
    $(document).ready(function() {
        $('#plan_id').on('change', function() {
            const selectedOption = $(this).find(':selected');
            const packagePrice = selectedOption.data('price');

            if (packagePrice) {
                $('#price').val(packagePrice);
            } else {
                $('#price').val('');
            }
        });
    });

    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
</script>
