@extends('admin.layouts.master')
@section('title', __('add_staff'))
@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('add_staff') }}</h3>
                <form action="{{route('admin.staff.store')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <div class="mb-2">
                                    <label for="first_name" class="form-label"> {{ __('first_name') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="first_name" name="first_name"
                                        value="{{ old('first_name') }}" placeholder="{{ __('enter_first_name') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('first_name') }}</p>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label for="last_name" class="form-label"> {{ __('last_name') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="last_name" name="last_name"
                                        value="{{ old('last_name') }}" placeholder="{{ __('enter_last_name') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('last_name') }}</p>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label for="phone" class="form-label"> {{ __('phone_number') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="phone" name="phone"
                                        value="{{ old('phone') }}" placeholder="{{ __('enter_phone_number') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('phone') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="gender" class="form-label">{{ __('gender') }}</label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="gender" id="gender">
                                        <option value="1"> {{__('male')}} </option>
                                        <option value="2"> {{__('female')}} </option>
                                        <option value="0"> {{__('rather_not_say')}} </option>
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('gender') }}</p>
                                    </div>
                                </div>
                                <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="status" value="1">
                                    <label class="form-label" for="status"> {{__('staff_status')}} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="status" checked class="sandbox_mode">
                                        <label for="status"></label>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label for="email" class="form-label"> {{ __('Email') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="email" name="email"
                                        value="{{ old('email') }}" placeholder="{{ __('enter_email') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('email') }}</p>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label for="password" class="form-label"> {{ __('password') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="password" name="password"
                                        value="{{ old('password') }}" placeholder="{{ __('enter_password') }}" required>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('password') }}</p>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label for="image" class="form-label"> {{ __('image') }} </label>
                                    <input type="file" class="form-control rounded-2" id="image" name="image"
                                        placeholder="{{ __('enter_image') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('image') }}</p>
                                    </div>
                                </div>
                                <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                                @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <div class="mb-4">
                                    <label for="role_id" class="form-label">{{ __('role_id') }}</label>
                                    <select id="role-select"
                                        class="form-select form-select-lg rounded-2 mb-3 change-role without_search"
                                        aria-label=".form-select-lg example" name="role_id">
                                        <option value="">{{__('select_role')}}</option>
                                        @foreach($roles as $role)
                                            <option value="{{ $role->id }}">{{ $role->name }}</option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('role_id') }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-3">
                                <div class="staff-role-heigh simplebar">
                                    <div class="default-list-table table-responsive staff-role-table">
                                        <table class="table" id="permissions-table">
                                            <tbody>
                                                @foreach($permissions as $permission)
                                                    <tr>
                                                        <td><span class="text-capitalize"> {{ $permission->name }} </span>
                                                        </td>
                                                        <td>
                                                            @foreach($permission->keywords as $key => $keyword)
                                                                <div class="custom-checkbox mb-2">
                                                                    <label>
                                                                        <input name="permissions[]" type="checkbox"
                                                                            value="{{ $keyword }}">
                                                                        <span class="text-capitalize">{{ str_replace('_', ' ', $key) }}</span>
                                                                    </label>
                                                                </div>
                                                            @endforeach
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@include('admin.staff.staff-script')