@extends('admin.layouts.master')
@section('title', __('tmdb_settings'))
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-md-center">
            <div class="col col-lg-6 col-md-8">
                <h3 class="section-title">{{ __('tmdb_settings') }}</h3>
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <form action="{{route('admin.setting.update', ['type' => 'tmdb_settings'])}}" method="post"
                        enctype="multipart/form-data">
                        @csrf

                        <div class="mb-2">
                            <label for="tmdb_api_key" class="form-label"> {{ __('tmdb_api_key') }} </label>
                            <input type="text" class="form-control rounded-2" id="tmdb_api_key" name="tmdb_api_key"
                                value="{{ isDemoMode()? '' : get_config('tmdb_api_key') }}" placeholder="{{ __('tmdb_api_key') }}">
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('tmdb_api_key') }}</p>
                            </div>
                        </div>
                        <div class="mb-2">
                            <label for="tmdb_default_language" class="form-label">{{ __('tmdb_default_language') }} </label>
                            <select class="form-select form-select-lg mb-3 with_search" name="tmdb_default_language"
                                id="tmdb_default_language">
                                @foreach ($movie_languages as $language)
                                    <option value="{{$language->slug}}" {{$language->slug == get_config('tmdb_default_language') ? 'selected' : ''}}> {{$language->name}} </option>
                                @endforeach
                            </select>
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('tmdb_default_language') }}</p>
                            </div>
                        </div>

                        <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                        @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection