@extends('admin.layouts.master')
@section('title', __('social_settings'))
@section('content')
    <div class="container-fluid">
        <div class="row">
            <h3 class="section-title">{{ __('social_settings') }}</h3>
            <div class="col-lg-6">
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <form action="{{ route('admin.setting.update') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <h3 class="section-title">{{__('google_login_config') }}</h3>

                        <div class="row">
                            <div class="col-sm-12 mb-2">
                                <label for="google_client_id" class="form-label"> {{ __('google_client_id') }} </label>
                                <input type="text" class="form-control rounded-2" id="google_client_id"
                                    name="google_client_id" value="{{ isDemoMode()? '' : get_config('google_client_id') }}"
                                    placeholder="{{ __('google_client_id') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('google_client_id') }}</p>
                                </div>
                            </div>
                            <div class="col-sm-12 mb-2">
                                <label for="google_client_secret" class="form-label"> {{ __('google_client_secret') }}
                                </label>
                                <input type="text" class="form-control rounded-2" id="google_client_secret"
                                    name="google_client_secret" value="{{ isDemoMode()? '' : get_config('google_client_secret') }}"
                                    placeholder="{{ __('google_client_secret') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('google_client_secret') }}</p>
                                </div>
                            </div>

                            <div class="col-sm-12 mb-2">
                                <label for="google_redirect_url" class="form-label"> {{ __('google_redirect_url') }}
                                </label>
                                <input type="text" class="form-control rounded-2" id="google_redirect_url" disabled
                                    value="{{ route('auth.google.callback') }}"
                                    placeholder="{{ __('google_redirect_url') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('google_redirect_url') }}</p>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn sg-btn-primary mt-3">{{ __('submit') }}</button>
                        @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                    </form>
                </div>
            </div>
            <div class="col-lg-6 mt-3 mt-md-0">
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <form action="{{ route('admin.setting.update') }}" method="post"
                        enctype="multipart/form-data" class="form-validate form ">
                        @csrf
                        <h3 class="section-title">{{__('facebook_login_config') }}</h3>
                        <div class="row">
                            <div class="col-sm-12 mb-2">
                                <label for="facebook_client_id" class="form-label"> {{ __('facebook_client_id') }} </label>
                                <input type="text" class="form-control rounded-2" id="facebook_client_id"
                                    name="facebook_client_id" value="{{ isDemoMode()? '' : get_config('facebook_client_id') }}"
                                    placeholder="{{ __('facebook_client_id') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('facebook_client_id') }}</p>
                                </div>
                            </div>
                            <div class="col-sm-12 mb-2">
                                <label for="facebook_client_secret" class="form-label"> {{ __('facebook_client_secret') }}
                                </label>
                                <input type="text" class="form-control rounded-2" id="facebook_client_secret"
                                    name="facebook_client_secret" value="{{ isDemoMode()? '' : get_config('facebook_client_secret') }}"
                                    placeholder="{{ __('facebook_client_secret') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('facebook_client_secret') }}</p>
                                </div>
                            </div>

                            <div class="col-sm-12 mb-2">
                                <label for="facebook_redirect_url" class="form-label"> {{ __('facebook_redirect_url') }}
                                </label>
                                <input type="text" class="form-control rounded-2" id="facebook_redirect_url" disabled
                                    value="{{ route('auth.facebook.callback') }}"
                                    placeholder="{{ __('facebook_redirect_url') }}">
                                <div class="nk-block-des text-danger">
                                    <p class="error">{{ $errors->first('facebook_redirect_url') }}</p>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn sg-btn-primary mt-3">{{ __('submit') }}</button>
                        @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection