@extends('admin.layouts.master')
@section('title', __('settings'))
@section('content')

    @php
        $tab = $tab_type ?? session('tab_type');
    @endphp

    <div class="container-fluid">
        <div class="d-flex align-items-start">
            <div class="nav flex-column nav-pills me-3 default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30"
                id="v-pills-tab" role="tablist" aria-orientation="vertical">
                <button class="nav-link {{ !$tab || $tab == 'system_settings' ? 'active' : '' }}"
                    id="v-pills-system-settings-tab" data-bs-toggle="pill" data-bs-target="#v-pills-system-settings"
                    type="button" role="tab" aria-controls="v-pills-system-settings" aria-selected="true">
                    {{ __('system_settings') }} </button>
                <button class="nav-link {{ $tab == 'email_settings' ? 'active' : '' }}" id="v-pills-email-settings-tab"
                    data-bs-toggle="pill" data-bs-target="#v-pills-email-settings" type="button" role="tab"
                    aria-controls="v-pills-email-settings" aria-selected="false"> {{ __('email_settings') }} </button>
                <button class="nav-link {{ $tab == 'tmdb_settings' ? 'active' : '' }}" id="v-pills-tmdb-settings-tab"
                    data-bs-toggle="pill" data-bs-target="#v-pills-tmdb-settings" type="button" role="tab"
                    aria-controls="v-pills-tmdb-settings" aria-selected="false"> {{ __('tmdb_settings') }} </button>
                <button class="nav-link {{ $tab == 'terms_condition' ? 'active' : '' }}" id="v-pills-terms-conditions-tab"
                    data-bs-toggle="pill" data-bs-target="#v-pills-terms-conditions" type="button" role="tab"
                    aria-controls="v-pills-terms-conditions" aria-selected="false"> {{ __('terms_&_conditions') }} </button>
                <button class="nav-link {{ $tab == 'privacy_policy' ? 'active' : '' }}" id="v-pills-privacy-policy-tab"
                    data-bs-toggle="pill" data-bs-target="#v-pills-privacy-policy" type="button" role="tab"
                    aria-controls="v-pills-privacy-policy" aria-selected="false"> {{ __('privacy_policy') }} </button>
                <button class="nav-link {{ $tab == 'payment_policy' ? 'active' : '' }}" id="v-pills-payment-policy-tab"
                    data-bs-toggle="pill" data-bs-target="#v-pills-payment-policy" type="button" role="tab"
                    aria-controls="v-pills-payment-policy" aria-selected="false"> {{ __('payment_policy') }} </button>
                <button class="nav-link {{ $tab == 'social_settings' ? 'active' : '' }}" id="v-pills-social-login-tab"
                    data-bs-toggle="pill" data-bs-target="#v-pills-social-login" type="button" role="tab"
                    aria-controls="v-pills-social-login" aria-selected="false"> {{ __('social_settings') }} </button>

            </div>

            <div class="tab-content w-100 default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30"
                id="v-pills-tabContent">
                <div class="tab-pane fade show {{ !$tab || $tab == 'system_settings' ? 'active' : '' }}"
                    id="v-pills-system-settings" role="tabpanel" aria-labelledby="v-pills-system-settings-tab"
                    tabindex="0">
                    <h3 class="section-title">{{ __('system_settings') }}</h3>
                    @include('admin.settings.system_settings')
                </div>
                <div class="tab-pane fade show {{ $tab == 'email_settings' ? 'active' : '' }}" id="v-pills-email-settings"
                    role="tabpanel" aria-labelledby="v-pills-email-settings-tab" tabindex="0">
                    <h3 class="section-title">{{ __('email_settings') }}</h3>
                    @include('admin.settings.email_settings')
                </div>
                <div class="tab-pane fade show {{ $tab == 'tmdb_settings' ? 'active' : '' }}" id="v-pills-tmdb-settings"
                    role="tabpanel" aria-labelledby="v-pills-tmdb-settings-tab" tabindex="0">
                    <h3 class="section-title">{{ __('tmdb_settings') }}</h3>
                    @include('admin.settings.tmdb_settings')
                </div>
                <div class="tab-pane fade show {{ $tab == 'terms_condition' ? 'active' : '' }}" id="v-pills-terms-conditions"
                    role="tabpanel" aria-labelledby="v-pills-terms-conditions-tab" tabindex="0">
                    <h3 class="section-title">{{ __('terms_&_conditions') }}</h3>
                    @include('admin.settings.terms_conditions')
                </div>
                <div class="tab-pane fade show {{ $tab == 'privacy_policy' ? 'active' : '' }}" id="v-pills-privacy-policy"
                    role="tabpanel" aria-labelledby="v-pills-privacy-policy-tab" tabindex="0">
                    <h3 class="section-title">{{ __('privacy_policy') }}</h3>
                    @include('admin.settings.privacy_policy')
                </div>
                <div class="tab-pane fade show {{ $tab == 'payment_policy' ? 'active' : '' }}" id="v-pills-payment-policy"
                    role="tabpanel" aria-labelledby="v-pills-payment-policy-tab" tabindex="0">
                    <h3 class="section-title">{{ __('payment_policy') }}</h3>
                    @include('admin.settings.payment_policy')
                </div>
                <div class="tab-pane fade show {{ $tab == 'social_settings' ? 'active' : '' }}" id="v-pills-social-login"
                    role="tabpanel" aria-labelledby="v-pills-social-login-tab" tabindex="0">
                    <h3 class="section-title">{{ __('google_login_config') }}</h3>
                    @include('admin.settings.social_settings')
                </div>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script>
        "use strict";
        $('.legal-content').summernote({
            height: 210,
        });
    </script>
@endpush
