@extends('admin.layouts.master')
@section('title', __('google_recaptcha_settngs'))
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-md-center">
            <div class="col col-lg-6 col-md-8">
                <h3 class="section-title">{{ __('google_recaptcha_settngs') }}</h3>
                <div class="default-tab-list default-tab-list-v2 bg-white redious-border p-20 p-sm-30">
                    <form action="{{ route('admin.setting.update') }}" method="POST">
                        @csrf
                        <div class="d-flex gap-12 sandbox_mode_div mb-4">
                            <input type="hidden" name="is_recaptcha_activated"
                                value="{{ get_config('is_recaptcha_activated') == 1 ? 1 : 0 }}">
                            <label class="form-label"
                                for="is_recaptcha_activated">{{ __('is_recaptcha_activated')
                                                                                                                        }}</label>
                            <div class="setting-check">
                                <input type="checkbox" value="1" id="is_recaptcha_activated" class="sandbox_mode" {{
        get_config('is_recaptcha_activated') == 1 ? 'checked' : '' }}>
                                <label for="is_recaptcha_activated"></label>
                            </div>
                        </div>

                        <div class="mb-2">
                            <label for="recaptcha_site_key" class="form-label">{{ __('recaptcha_site_key') }}</label>
                            <input type="text" class="form-control rounded-2" id="recaptcha_site_key"
                                name="recaptcha_site_key" value="{{ isDemoMode()? '' : get_config('recaptcha_site_key') }}"
                                placeholder="{{ __('recaptcha_site_key') }}">
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('recaptcha_site_key') }}</p>
                            </div>
                        </div>

                        <div class="mb-2">
                            <label for="recaptcha_secret_key" class="form-label">{{ __('recaptcha_secret_key') }}</label>
                            <input type="text" class="form-control rounded-2" id="recaptcha_secret_key"
                                name="recaptcha_secret_key" value="{{ isDemoMode()? '' : get_config('recaptcha_secret_key') }}"
                                placeholder="{{ __('recaptcha_secret_key') }}">
                            <div class="nk-block-des text-danger">
                                <p class="error">{{ $errors->first('recaptcha_secret_key') }}</p>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn sg-btn-primary">{{ __('save_changes') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection