@extends('admin.layouts.master')
@section('title', __('mobile_api_settings'))
@section('content')

    <div class="container-fluid">
        <div class="row justify-content-md-center">
            <div class="col col-lg-8 col-md-9">
                <div class="header-top d-flex justify-content-between align-items-center">
                    <h3 class="section-title">{{ __('mobile_api_settings') }}</h3>
                    <div class="oftions-content-right mb-12">
                        @can('admin.api.key.add')
                            <a href="javascript:void(0)"
                                onclick="ajaxModal('modal-md', '{{ route('admin.api.key.add') }}', '{{ __('api_key_add') }}')"
                                class="d-flex align-items-center btn sg-btn-primary gap-2">
                                <i class="las la-plus"></i>
                                <span>{{ __('add_api_key') }}</span>
                            </a>
                        @endcan
                    </div>
                </div>
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <div class="mb-2">
                        <label for="api-url" class="form-label"> {{ __('api_url') }} </label>
                        <input type="text" class="form-control rounded-2" id="api-url" value="{{ url('api') }}"
                            disabled>
                    </div>

                    <h4 class="mt-4">{{ __('app_key') }}</h4>
                    <hr>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="default-list-table table-responsive apk-setting">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th scope="col" class="text-start">#</th>
                                            <th scope="col" class="text-center">{{ __('title') }}</th>
                                            <th scope="col" class="text-center">{{ __('key') }}</th>
                                            <th scope="col" class="text-end">{{ __('option') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($api_keys as $key => $api_key)
                                            <tr>
                                                <td class="text-start">{{ ++$key }}</td>
                                                <td class="text-center">{{ $api_key->title }}</td>
                                                <td class="text-center">
                                                    <div class="user-password d-flex align-items-center">
                                                        <input class="passField" type="password" readonly=""
                                                            value="{{ $api_key->key }}">
                                                        @if (!isDemoMode())
                                                            <label for="password3" class="toggle-password"><i
                                                                    class="lar la-eye"></i></label>
                                                        @endif
                                                    </div>
                                                </td>
                                                <td class="text-end">
                                                    <ul class="d-flex gap-3 justify-content-end">
                                                        @can('apikeys.revoke')
                                                            <li>
                                                                <a href="{{ route('admin.api.key.status', ['id' => $api_key->id, 'status' => $api_key->status]) }}"
                                                                    data-toggle="tooltip"
                                                                    data-original-title="{{ __('status_change') }}"><span
                                                                        class="title">{{ $api_key->status == 1 ?  __('inactive') :  __('revoke') }}</span></a></a>

                                                            </li>
                                                        @endcan
                                                        @can('apikeys.edit')
                                                            <li><a href="javascript:void(0)" onclick="ajaxModal('modal-md', '{{ route('admin.api.key.edit', ['id' => $api_key->id]) }}', '{{ __('api_key_update') }}')"><i
                                                                        class="las la-edit"></i></a></li>
                                                            @if ($api_key->status == 0)
                                                                <a onclick="delete_row('{{ route('admin.api.key.delete', $api_key->id) }}','{{$api_key->id}}', 'true')" href="javascript:void(0)" title="{{ __('delete') }}"><i class="las la-trash-alt"></i></a>
                                                            @endif
                                                        @endcan
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
