<form action="{{ route('admin.system.language.update', ['id' => $language->id]) }}" method="POST" class="form">
    @csrf
    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="mb-4">
                <label class="form-label">{{ __('language_name') }}<span class="text-danger">*</span></label>
                <input type="text" class="form-control rounded-2" placeholder="{{ __('language_name') }}"
                    name="name" value="{{ old('name', $language->name) }}">
                <div class="nk-block-des text-danger">
                    <p class="name_error error">{{ $errors->first('name') }}</p>
                </div>
            </div>
        </div>
        <!-- End Language Name -->

        <div class="col-lg-12">
            <div class="select-type-v2 mb-4 list-space">
                <label class="form-label">{{ __('locale') }}<span class="text-danger">*</span></label>
                <select class="form-select form-select-lg mb-3 with_search select2" name="locale">
                    <option value="">{{ __('select_local') }}</option>
                    @foreach (get_yrsetting('locale') as $locale)
                        <option value="{{ $locale }}" {{ $locale == $language->locale ? 'selected' : '' }}>
                            {{ Str::upper($locale) }}</option>
                    @endforeach
                </select>
                <div class="nk-block-des text-danger">
                    <p class="locale_error error">{{ $errors->first('locale') }}</p>
                </div>
            </div>
        </div>
        <!-- End Language Locale Selection -->
        <div class="col-lg-12">
            {{ $language->image }}
            <div class="select-type-v2 mb-4 list-space">
                <label class="form-label">{{ __('flag') }}<span class="text-danger">*</span></label>
                <select class="form-select form-select-lg mb-3 with_search select2" placeholder="" name="flag">
                    <option value="" selected>{{ __('select_flag') }}</option>
                    @foreach ($flags as $flag)
                        <option data-image="{{ static_asset($flag->image) }}" value='{{ $flag->image }}'
                            {{ $flag->image == $language->image ? 'selected' : '' }}>
                            {{ $flag->title }}</option>
                    @endforeach
                </select>
                <div class="nk-block-des text-danger">
                    <p class="flag_error error">{{ $errors->first('flag') }}</p>
                </div>
            </div>
        </div>
        <div class="col-sm-12">
            <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                <input type="hidden" name="status" value="{{ $language->status }}">
                <label class="form-label" for="status"> {{ __('status') }} </label>
                <div class="setting-check">
                    <input type="checkbox" value="1" {{ $language->status == 1 ? 'checked' : '' }} id="status"
                        class="sandbox_mode">
                    <label for="status"></label>
                </div>
            </div>
        </div>
    </div>
    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
</script>
