@extends('admin.layouts.master')
@section('title', __('admin_settings'))
@section('content')
    <div class="container-fluid">
        <div class="row justify-content-md-center">
            <div class="col col-lg-8 col-md-9">
                <h3 class="section-title">{{ __('admin_settings') }}</h3>
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <form action="{{ route('admin.setting.update') }}" method="post" enctype="multipart/form-data">@csrf
                        <input type="hidden" name="r" value="{{ url()->current() }}" class="r">
                        <div class="row gx-20">
                            <div class="col-lg-12 input_file_div mb-4">
                                <div class="mb-3">
                                    <label class="form-label mb-1">{{__('logo') }} (100X36)</label>
                                    <label for="admin_logo" class="file-upload-text">
                                        <p></p>
                                        <span class="file-btn">{{__('choose_file') }}</span>
                                    </label>
                                    <input class="d-none file_picker" type="file" id="admin_logo" name="admin_logo"
                                        accept=".jpg,.png">
                                    <div class="nk-block-des text-danger">
                                        <p class="admin_logo_error error">{{ $errors->first('admin_logo') }}</p>
                                    </div>
                                </div>
                                <div class="selected-files d-flex flex-wrap gap-20">
                                    <div class="selected-files-item">
                                        <img class="selected-img"
                                            src="{{ getFileLink('original_image', get_config('admin_logo'), 'admin_logos', '100x36') }}"
                                            alt="admin_logo">
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 input_file_div mb-4">
                                <div class="mb-3">
                                    <label class="form-label mb-1">{{__('mini_logo') }} (1:1)</label>
                                    <label for="admin_mini_logo" class="file-upload-text">
                                        <p></p>
                                        <span class="file-btn">{{__('choose_file') }}</span>
                                    </label>
                                    <input class="d-none file_picker" type="file" id="admin_mini_logo"
                                        name="admin_mini_logo" accept=".jpg,.png">
                                    <div class="nk-block-des text-danger">
                                        <p class="admin_mini_logo_error error">{{ $errors->first('admin_mini_logo') }}</p>
                                    </div>
                                </div>
                                <div class="selected-files d-flex flex-wrap gap-20">
                                    <div class="selected-files-item">
                                        <img class="selected-img"
                                            src="{{ getFileLink('original_image', get_config('admin_mini_logo'), 'admin_mini_logos', '80x80') }}"
                                            alt="admin_min_logo">
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 input_file_div mb-4">
                                <div class="mb-3">
                                    <label class="form-label mb-1">{{__('favicon') }}</label>
                                    <label for="admin_favicon" class="file-upload-text">
                                        <p></p>
                                        <span class="file-btn">{{__('choose_file') }}</span>
                                    </label>
                                    <input class="d-none file_picker" type="file" id="admin_favicon" name="admin_favicon"
                                        accept=".jpg,.png">
                                    <div class="nk-block-des text-danger">
                                        <p class="admin_favicon_error error">{{ $errors->first('admin_favicon') }}</p>
                                    </div>
                                </div>
                                <div class="selected-files d-flex flex-wrap gap-20">
                                    <div class="selected-files-item">
                                        <img class="selected-img"
                                            src="{{ getFileLink('original_image', get_config('admin_favicon'), 'admin_favicons', '80x80') }}"
                                            alt="admin_min_logo">

                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-4">
                                    <label for="admin_panel_copyright_text"
                                        class="form-label">{{ __('copyright_text') }}</label>
                                    <input type="text" class="form-control rounded-2" id="admin_panel_copyright_text"
                                        placeholder="{{__('copyright_text') }}" name="admin_panel_copyright_text"
                                        value="{{ old('admin_panel_copyright_text', get_config('admin_panel_copyright_text')) }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="admin_panel_copyright_text_error error"></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-start align-items-center">
                            <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                            @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection