@extends('admin.layouts.master')
@section('title', __('reports'))
@section('content')

    <section class="oftions">
        <div class="container-fluid">
            <div class="row">
                <div class="col col-md-12">
                    <div class="header-top d-flex justify-content-between align-items-center">
                        <h3 class="section-title">{{ __('reports') }}</h3>
                    </div>
                    <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="default-list-table table-responsive yajra-dataTable">
                                    {{ $dataTable->table() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@push('js')
    {{ $dataTable->scripts() }}
    <script>
        "use strict";
        $(document).on('click', '.report-action', function() {
            const button = $(this);
            const id = button.data('id');
            const status = button.data('status');

            const routeTemplate = "{{ route('admin.report.update', ':id') }}";
            const url = routeTemplate.replace(':id', id);

            Swal.fire({
                title: "{{ __('are_you_sure') }}",
                text: "{{ __('you_are_about_to_mark_this_report_as') }} \"" + status + "\".",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: "{{ __('yes_update_it') }}",
                cancelButtonText: "{{ __('cancel') }}"
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: url,
                        method: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content'),
                            status: status
                        },
                        success: function(res) {
                            Swal.fire({
                                title: "{{ __('success') }}",
                                text: "{{ __('report_status_updated') }}",
                                icon: 'success',
                                timer: 2000,
                                showConfirmButton: false
                            });

                            $('#dataTableBuilder').DataTable().ajax.reload(null, false);
                        },
                        error: function(xhr) {
                            Swal.fire({
                                title: "{{ __('error') }}",
                                text: "{{ __('failed_to_update_status') }}",
                                icon: 'error'
                            });
                            console.error(xhr);
                        }
                    });
                }
            });
        });
    </script>
@endpush
