@extends('admin.layouts.master')
@section('title', __('manage_profile'))
@section('content')

    <section class="oftions">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h3 class="section-title mb-0"> {{__('update_profile')}} </h3>
                    </div>
                    <div class="bg-white redious-border">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="admin-profile">
                                    <img src="{{ getFileLink('original_image', auth()->user()->image, 'users', '100x100') }}" alt="User Profile img">
                                </div>
                            </div>
                        </div>
                        <form method="POST" action="{{ route('admin.update.profile') }}"
                            enctype="multipart/form-data" class="form-validate form">
                            @csrf
                            <div class="row p-20 p-md-30">
                                <div class="col-lg-6">
                                    <div class="mb-4">
                                        <label for="first_name" class="form-label">{{__('first_name')}}</label>
                                        <input type="text" class="form-control rounded-2" id="first_name"
                                            placeholder="{{__('first_name')}}" name="first_name" value="{{auth()->user()->first_name}}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('first_name') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-4">
                                        <label for="last_name" class="form-label"> {{__('last_name')}} </label>
                                        <input type="text" class="form-control rounded-2" id="last_name"
                                            placeholder="{{__('last_name')}}" name="last_name" value="{{auth()->user()->last_name}}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('last_name') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Full Name -->

                                <div class="col-lg-6">
                                    <div class="mb-4">
                                        <label for="emailAddress" class="form-label">{{__('email_address')}}</label>
                                        <input type="text" class="form-control rounded-2" id="emailAddress"
                                            placeholder="{{__('email_address')}}" name="email" value="{{auth()->user()->email}}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('email') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Email Address -->

                                <div class="col-lg-6">
                                    <div class="mb-4">
                                        <label for="phone" class="form-label">{{ __('phone_number') }}</label>
                                        <input type="number" class="form-control rounded-2" id="phone"
                                            placeholder="{{ __('phone_number') }}" name="phone"
                                            value="{{auth()->user()->phone}}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('phone') }}</p>
                                        </div>
                                    </div>

                                </div>
                                <!-- End Phone Number Field -->
                                <div class="col-lg-6">
                                    <div class="mb-4">
                                        <label for="gender" class="form-label">{{ __('gender') }}</label>
                                        <select class="form-select form-select-lg mb-3 with_search" name="gender"
                                        id="gender">
                                            <option value=""> {{__('select_gender')}} </option>
                                            <option value="1" {{auth()->user()->gender == '1' ? 'selected' : ''}}> {{__('male')}} </option>
                                            <option value="2" {{auth()->user()->gender == '2' ? 'selected' : ''}}> {{__('female')}} </option>
                                            <option value="0" {{auth()->user()->gender == '0' ? 'selected' : ''}}> {{__('rather_not_say')}} </option>
                                    </select>
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('gender') }}</p>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-lg-6">
                                    <div class=" mb-4">
                                        <label for="date_of_birth" class="form-label mb-1">{{__('date_of_birth')}}</label>
                                        <input type="date" class="form-control rounded-2" id="date_of_birth"
                                            placeholder="{{__('date_of_birth')}}" name="date_of_birth" value="{{auth()->user()->date_of_birth}}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('date_of_birth') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Address -->

                                <div class="col-lg-6 input_file_div">
                                    <div class="mb-3">
                                        <label class="form-label mb-1">{{__('change_profile_photo')}}</label>
                                        <label for="profilePhoto" class="file-upload-text">
                                            <p>{{__('choose_file')}}</p>
                                            <span class="file-btn">{{__('choose_file')}}</span>
                                        </label>
                                        <input class="d-none file_picker" type="file" id="profilePhoto" name="image"
                                            accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="image_error error"></p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img" src="{{ getFileLink('original_image', auth()->user()->image, 'users', '100x100') }}" alt="favicon">
                                        </div>
                                    </div>
                                </div>
                                <!-- End Upload Profile Photo Input Field -->

                            </div>
                            <div class="d-flex align-items-center gap-3 m-4 mt-0">
                                <div>
                                    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                    @include('layouts.loading_button',['class' => 'btn sg-btn-primary'])
                                </div>
                                <a href="{{route('admin.change.password')}}" class="btn sg-btn-outline-primary"> {{__('change_password')}} </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
