@extends('admin.layouts.master')
@section('title', __('manage_profile'))
@section('content')

    <section class="oftions">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <h3 class="section-title mb-0"> {{ __('update_password') }} </h3>
                    </div>
                    <div class="bg-white redious-border">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="admin-profile">
                                    <img src="{{ getFileLink('original_image', auth()->user()->image, 'users', '100x100') }}" alt="User Profile img">
                                </div>
                            </div>
                        </div>
                        <form method="POST" action="{{ route('admin.password.update') }}" enctype="multipart/form-data"
                            class="form-validate form">
                            @csrf
                            <div class="row p-20 p-md-30">
                                <div class="col-lg-12">
                                    <div class="mb-4">
                                        <label for="current_password"
                                            class="form-label mb-1">{{ __('current_password') }}</label>
                                        <div class="admin-passwordField user-password">
                                            <div class="position-relative">
                                                <input type="password" class="passField form-control rounded-2"
                                                    id="current_password" placeholder="{{ __('current_password') }}"
                                                    name="current_password">
                                                <label for="password" class="toggle-password"><i
                                                        class="lar la-eye"></i></label>
                                            </div>
                                            <div class="nk-block-des text-danger">
                                                <p class="error">{{ $errors->first('current_password') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Password -->

                                <div class="col-lg-12">
                                    <div class="mb-4">
                                        <label for="new_password" class="form-label mb-1"> {{ __('new_password') }} </label>
                                        <div class="admin-passwordField user-password">
                                            <div class="position-relative">
                                                <input type="password" class="passField form-control rounded-2"
                                                    id="new_password" placeholder="{{ __('new_password') }}"
                                                    name="new_password">
                                                <label for="newPassword" class="toggle-password"><i
                                                        class="lar la-eye"></i></label>
                                            </div>
                                            <div class="nk-block-des text-danger">
                                                <p class="error">{{ $errors->first('new_password') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- End New Password -->

                                <div class="col-lg-12">
                                    <div class="">
                                        <label for="new_password_confirmation" class="form-label mb-1">
                                            {{ __('confirm_new_password') }} </label>
                                        <div class="admin-passwordField user-password">
                                            <div class="position-relative">
                                                <input type="password" class="passField form-control rounded-2"
                                                    id="new_password_confirmation"
                                                    placeholder="{{ __('new_password_confirmation') }}"
                                                    name="new_password_confirmation">
                                                <label for="confirmNewPassword" class="toggle-password"><i
                                                        class="lar la-eye"></i></label>
                                            </div>
                                            <div class="nk-block-des text-danger">
                                                <p class="error">{{ $errors->first('new_password_confirmation') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-center gap-3 m-4 mt-0">
                                <div>
                                    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
                                    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
                                </div>
                                <a href="{{ route('admin.manage.profile') }}" class="btn sg-btn-outline-primary">
                                    {{ __('manage_profile') }} </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
