<form action="{{ route('admin.package.store') }}" method="post" enctype="multipart/form-data" class="form-validate form">
    @csrf
    <div class="mb-2 mt-3">
        <label for="name" class="form-label"> {{ __('name') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="name" name="name" value="{{ old('name') }}"
            placeholder="{{ __('enter_name') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('name') }}</p>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="mb-2">
                <label for="revenue_cat_id" class="form-label">{{ __('revenue_cat_id') }} </label>
                <input type="text" value="{{ old('revenue_cat_id') }}" class="form-control rounded-2"
                    id="revenue_cat_id" name="revenue_cat_id" placeholder="{{ __('revenue_cat_id') }}">
                <div class="nk-block-des text-danger">
                    <p class="stripe_error error">{{ $errors->first('revenue_cat_id') }}</p>
                </div>
            </div>
        </div>
        @if (setting('is_stripe_activated') && setting('stripe_secret') && setting('stripe_key'))
            <div class="col-lg-6">
                <div class="mb-2">
                    <label for="stripe_plan_key" class="form-label">{{ __('stripe_plan_key') }}<span
                            class="text-danger">*</span></label>
                    <input type="text" value="{{ $stripe_key ?? '' }}" class="form-control rounded-2"
                        id="stripe_plan_key" name="stripe" placeholder="{{ __('stripe_plan_key') }}">
                    <div class="nk-block-des text-danger">
                        <p class="stripe_error error"></p>
                    </div>
                </div>
            </div>
        @endif
        @if (setting('paypal_client_id') && setting('paypal_client_secret') && setting('is_paypal_activated'))
            <div class="col-lg-6">
                <div class="mb-2">
                    <label for="paypal_plan_id" class="form-label">{{ __('paypal_plan_id') }}
                        <span class="text-danger">*</span></label>
                    <input type="text" class="form-control rounded-2" id="paypal_plan_id" name="paypal"
                        placeholder="{{ __('paypal_plan_id') }}" value="{{ $paypal ?? '' }}">
                    <div class="nk-block-des text-danger">
                        <p class="paypal_error error"></p>
                    </div>
                </div>
            </div>
        @endif
        @if (setting('paddle_api_key') && setting('is_paddle_activated'))
            <div class="col-lg-6">
                <div class="mb-2">
                    <label for="paypal_plan_id" class="form-label">{{ __('paddle_price_id') }}
                        <span class="text-danger">*</span></label>
                    <input type="text" class="form-control rounded-2" id="price_id" name="paddle"
                        placeholder="{{ __('paddle_price_id') }}" value="{{ $paddle ?? '' }}">
                    <div class="nk-block-des text-danger">
                        <p class="paddle_error error"></p>
                    </div>
                </div>
            </div>
        @endif
        @if (setting('razor_pay_key') && setting('razor_pay_secret') && setting('is_razor_pay_activated'))
            <div class="col-lg-6">
                <div class="mb-2">
                    <label for="paypal_plan_id" class="form-label">{{ __('razor_pay_plan_id') }}
                        <span class="text-danger">*</span></label>
                    <input type="text" class="form-control rounded-2" id="razor_pay_plan_id" name="razor_pay"
                        placeholder="{{ __('razor_pay_plan_id') }}" value="{{ $razor_pay ?? '' }}">
                    <div class="nk-block-des text-danger">
                        <p class="razor_pay_error error"></p>
                    </div>
                </div>
            </div>
        @endif

    </div>
    <div class="mb-2">
        <label for="day" class="form-label"> {{ __('validity(day)') }} <span class="text-danger">*</span> </label>
        <input type="number" class="form-control rounded-2" id="day" name="day" value="{{ old('day') }}"
            placeholder="{{ __('enter_day') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('day') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="package_type" class="form-label">{{ __('package_type') }} <span class="text-danger">*</span>
        </label>
        <select class="form-select form-select-lg mb-3 select2 with_search" name="type" id="package_type">
            <option value=""> {{ __('select_package_type') }} </option>
            <option value="monthly"> {{ __('monthly') }} </option>
            <option value="annually"> {{ __('annually') }} </option>
        </select>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('type') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="price" class="form-label"> {{ __('price') . '(' . get_currency_symbol() . ')' }} <span
                class="text-danger">*</span> </label>
        <input type="number" class="form-control rounded-2" id="price" name="price"
            value="{{ old('price') }}" placeholder="{{ __('enter_price') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('price') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="discount" class="form-label"> {{ __('discount') . '(' . get_currency_symbol() . ')' }} <span
                class="text-danger">*</span> </label>
        <input type="number" class="form-control rounded-2" id="discount" name="discount"
            value="{{ old('discount') }}" placeholder="{{ __('enter_discount') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('discount') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="screens" class="form-label"> {{ __('screens') }} <span class="text-danger">*</span> </label>
        <input type="number" class="form-control rounded-2" id="screens" name="screens"
            value="{{ old('screens') }}" placeholder="{{ __('enter_screens') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('screens') }}</p>
        </div>
    </div>
    <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-2">
        <input type="hidden" name="status" value="1">
        <label class="form-label" for="status"> {{ __('status') }} </label>
        <div class="setting-check">
            <input type="checkbox" value="1" id="status" checked class="sandbox_mode">
            <label for="status"></label>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    {{-- @include('layouts.loading_button', ['class' => 'btn sg-btn-primary']) --}}
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Ensure dropdown appears inside modal
    });
</script>
