@extends('admin.layouts.master')
@section('title', __('movie_file_upload'))
@section('content')

<section class="oftions">
    <div class="container-fluid">
        <div class="row">
            <div class="col col-md-12">
                <div class="header-top d-flex justify-content-between align-items-center">
                    <h3 class="section-title">{{__('manage_movie_files') }}</h3>
                    <div class="oftions-content-right mb-12">
                        @can('admin.download.links')
                        <a href="{{route('admin.download.links', ['type' => $type, 'videoId' => $movie_id])}}"
                            class="d-flex align-items-center btn sg-btn-primary gap-2">
                            <i class="las la-plus"></i>
                            <span>{{__('manage_download_links') }}</span>
                        </a>
                        @endcan
                        @can('admin.movie.file.add')
                        <a href="javascript:void(0)" class="d-flex align-items-center btn sg-btn-primary gap-2"
                            onclick="ajaxModal('modal-md', '{{route('admin.movie.file.add', ['movie_id' => $movie_id])}}', '{{__('movie_file_add')}}')">
                            <i class="las la-plus"></i>
                            <span>{{__('add_movie_file') }}</span>
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="default-list-table table-responsive yajra-dataTable">
                                {{ $dataTable->table() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
@push('js')
{{ $dataTable->scripts() }}
@endpush