<form action="{{ route('admin.movie.file.store') }}" method="post" enctype="multipart/form-data"
    class="form-validate form">
    @csrf
    <input type="text" class="d-none" name="video_id" value="{{ $movie_id }}">
    <div class="mb-2">
        <label for="label" class="form-label"> {{ __('video_label') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="label" name="label" value="{{ old('label') }}"
            placeholder="{{ __('video_label') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('label') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="order" class="form-label"> {{ __('video_order') }} <span class="text-danger">*</span></label>
        <input type="number" class="form-control rounded-2" id="order" name="order" value="{{ old('order') }}"
            placeholder="{{ __('video_order') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('order') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="source" class="form-label">{{ __('video_source') }} <span class="text-danger">*</span></label>
        <select class="form-select form-select-lg mb-3 with_search select2" name="source" id="source">
            <option value=""> {{ __('select_video_source') }} </option>
            <option value="local"> {{ __('local_video') }} </option>
            <option value="gdrive"> {{ __('google_drive') }} </option>
            <option value="youtube">{{ __('youtube') }}</option>
            <option value="amazone">{{ __('amazone_S3') }}</option>
            <option value="mp4">{{ __('mp4_from_url') }}</option>
            <option value="mkv">{{ __('mkv_from_url') }}</option>
            <option value="webm">{{ __('webm_from_url') }}</option>
            <option value="m3u8">{{ __('m3u8_from_url') }}</option>
            <option value="embed">{{ __('embed_url') }}</option>
        </select>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('source') }}</p>
        </div>
    </div>

    {{-- File Upload Field (only for "local" source) --}}
    <div class="mb-2 d-none" id="file_upload_wrapper">
        <label for="video_file" class="form-label">{{ __('upload_video_file') }} <span
                class="text-danger">*</span></label>
        <input type="file" class="form-control" name="video_file" id="video_file" accept="video/*">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('video_file') }}</p>
        </div>
    </div>

    {{-- URL Input Field (for all non-local sources) --}}
    <div class="mb-2" id="file_url_wrapper">
        <label for="file_url" class="form-label">{{ __('video_url') }} <span class="text-danger">*</span></label>
        <input type="url" class="form-control rounded-2" id="file_url" name="file_url"
            value="{{ old('file_url') }}" placeholder="{{ __('video_file_url') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('file_url') }}</p>
        </div>
    </div>
    <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>
<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal') // Optional for modal use
    });

    $('#source').on('change', function() {
        let source = $(this).val();
        if (source === 'local') {
            $('#file_url_wrapper').addClass('d-none');
            $('#file_upload_wrapper').removeClass('d-none');
        } else {
            $('#file_url_wrapper').removeClass('d-none');
            $('#file_upload_wrapper').addClass('d-none');
        }
    });

    // Trigger once on page load in case of old value
    $(document).ready(function() {
        $('#source').trigger('change');
    });
</script>
