@extends('admin.layouts.master')
@section('title', __('add_new_live_tv'))
@section('content')

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="section-title">{{ __('add_live_tv') }}</h3>
                <form action="{{ route('admin.live.tv.store') }}" method="post" enctype="multipart/form-data"
                    class="crud-form">
                    @csrf
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('live_tv_information') }} </h3>
                                <div class="mb-4">
                                    <label for="tv_name" class="form-label"> {{ __('tv_name') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="tv_name" name="tv_name"
                                        value="{{ old('tv_name') }}" placeholder="{{ __('tv_name') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('tv_name') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="slug" class="form-label"> {{ __('slug') }} <span
                                            class="text-danger">*</span> </label>
                                    <input type="text" class="form-control rounded-2" id="slug" name="slug"
                                        value="{{ old('slug') }}" placeholder="{{ __('slug') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('slug') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="live_tv_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('tv_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}" data-type="live_tv_description"
                                                data-title="" data-id="live_tv_description"
                                                class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="description" id="live_tv_description" cols="30" rows="4" class="form-control rounded-2"
                                        placeholder="{{ __('tv_description') }}">{{ old('description') }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="actor" class="form-label">{{ __('country') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="country_id"
                                        id="country">
                                        @foreach (get_all_countries() as $country)
                                            <option value="{{ $country->id }}"
                                                {{ old('country') == $country->id ? 'selected' : '' }}>
                                                {{ $country->name }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('country') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="actor" class="form-label">{{ __('category') }} <span
                                            class="text-danger">*</span></label>
                                    <select class="form-select form-select-lg mb-3 with_search" name="category"
                                        id="category">
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ old('category') == $category->id ? 'selected' : '' }}>
                                                {{ $category->live_tv_category }} </option>
                                        @endforeach
                                    </select>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('category') }}</p>
                                    </div>
                                </div>
                                <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="status" value="{{ old('status') ?? 1 }}">
                                    <label class="form-label" for="status"> {{ __('status') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="status"
                                            {{ old('status') > 0 ? 'checked' : 'checked' }} class="sandbox_mode">
                                        <label for="status"></label>
                                    </div>
                                </div>
                                <div class="d-flex gap-12 align-items-center justify-content-between sandbox_mode_div mb-4">
                                    <input type="hidden" name="featured" value="{{ old('featured') ?? 0 }}">
                                    <label class="form-label" for="featured"> {{ __('featured') }} </label>
                                    <div class="setting-check">
                                        <input type="checkbox" value="1" id="featured"
                                            {{ old('featured') > 0 ? 'checked' : '' }} class="sandbox_mode">
                                        <label for="featured"></label>
                                    </div>
                                </div>
                            </div>
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-3">
                                <h3 class="section-title"> {{ __('thumbnail') }} </h3>
                                <div class="input_file_div d-flex align-items-center gap-3">
                                    <div class="mb-3 w-75">
                                        <label for="thumbUpload"
                                            class="form-label mb-1">{{ __('tv_thumbnail_(500x500)') }}</label>
                                        <label for="thumbUpload" class="file-upload-text"></label>
                                        <input class="d-none file_picker" type="file" name="thumbnail"
                                            id="thumbUpload" accept=".jpg,.png">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('thumbnail') }}</p>
                                        </div>
                                    </div>
                                    <div class="selected-files d-flex flex-wrap gap-20">
                                        <div class="selected-files-item">
                                            <img class="selected-img"
                                                src="{{ getFileLink('live_tv', '', 'live_tvs', '500x500') }}"
                                                alt="thumbnail">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30">
                                <h3 class="section-title"> {{ __('stream_urls') }} </h3>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="mb-4">
                                        <label for="stream_from" class="form-label">{{ __('stream_from') }}</label>
                                        <select class="form-select form-select-lg mb-3 with_search" name="stream_from"
                                            id="stream_from">
                                            <option value="hls">{{ __('hls/m3u8/http') }}</option>
                                            <option value="youtube">{{ __('youtube_live') }}</option>
                                            <option value="embed">{{ __('embed') }}</option>
                                        </select>
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_from') }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <label for="stream_label" class="form-label"> {{ __('stream_label') }} </label>
                                        <input type="text" class="form-control rounded-2" id="stream_label"
                                            name="stream_label" value="{{ old('stream_label') }}"
                                            placeholder="{{ __('hd/sd/lq') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_label') }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <label for="stream_url" class="form-label"> {{ __('stream_url') }} </label>
                                        <input type="url" class="form-control rounded-2" id="stream_url"
                                            name="stream_url" value="{{ old('stream_url') }}"
                                            placeholder="{{ __('primary/high_quality_stream_url') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_url') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="mb-4">
                                        <label for="stream_from1"
                                            class="form-label">{{ __('stream_from(optional)') }}</label>
                                        <select class="form-select form-select-lg mb-3 with_search" name="stream_from1"
                                            id="stream_from1">
                                            <option value="hls">{{ __('hls/m2u8/http') }}</option>
                                            <option value="youtube">{{ __('youtube_live') }}</option>
                                            <option value="embed">{{ __('embed') }}</option>
                                        </select>
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_from1') }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <label for="stream_label1" class="form-label"> {{ __('stream_label(optional)') }}
                                        </label>
                                        <input type="text" class="form-control rounded-2" id="stream_label1"
                                            name="stream_label1" value="{{ old('stream_label1') }}"
                                            placeholder="{{ __('hd/sd/lq') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_label1') }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <label for="stream_url1" class="form-label"> {{ __('stream_url(optional)') }}
                                        </label>
                                        <input type="url" class="form-control rounded-2" id="stream_url1"
                                            name="stream_url1" value="{{ old('stream_url1') }}"
                                            placeholder="{{ __('primary/high_quality_stream_url') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_url1') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="mb-4">
                                        <label for="stream_from2"
                                            class="form-label">{{ __('stream_from(optional)') }}</label>
                                        <select class="form-select form-select-lg mb-3 with_search" name="stream_from2"
                                            id="stream_from2">
                                            <option value="hls">{{ __('hls/m3u8/http') }}</option>
                                            <option value="youtube">{{ __('youtube_live') }}</option>
                                            <option value="embed">{{ __('embed') }}</option>
                                        </select>
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_from2') }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <label for="stream_label2" class="form-label"> {{ __('stream_label(optional)') }}
                                        </label>
                                        <input type="text" class="form-control rounded-2" id="stream_label2"
                                            name="stream_label2" value="{{ old('stream_label2') }}"
                                            placeholder="{{ __('hd/sd/lq') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_label2') }}</p>
                                        </div>
                                    </div>
                                    <div class="mb-4">
                                        <label for="stream_url2" class="form-label"> {{ __('stream_url(optional)') }}
                                        </label>
                                        <input type="url" class="form-control rounded-2" id="stream_url2"
                                            name="stream_url2" value="{{ old('stream_url2') }}"
                                            placeholder="{{ __('primary/high_quality_stream_url') }}">
                                        <div class="nk-block-des text-danger">
                                            <p class="error">{{ $errors->first('stream_url2') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="default-tab-list default-tab-list-v2  bg-white redious-border p-20 p-sm-30 mt-3">
                                <h3 class="section-title"> {{ __('seo_and_marketing') }} </h3>
                                <div class="mb-4">
                                    <label for="seo_title" class="form-label"> {{ __('seo_title') }} </label>
                                    <input type="text" class="form-control rounded-2" id="seo_title" name="seo_title"
                                        value="{{ old('seo_title') }}" placeholder="{{ __('seo_title') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('seo_title') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="meta_description" class="form-label d-flex justify-content-between">
                                        <span>{{ __('meta_description') }}</span>
                                        <small class="generate-button">
                                            <button data-url="{{ route('ai-helper') }}"
                                                data-type="live_tv_meta_description" data-title=""
                                                data-id="meta_description"
                                                class="generate-content text-decoration-none text-danger">
                                                <span><i class="las la-robot"></i></span>
                                            </button>
                                        </small>
                                    </label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="3"
                                        class="form-control rounded-2" placeholder="{{ __('meta_description') }}">{{ old('meta_description') }}</textarea>
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('meta_description') }}</p>
                                    </div>
                                </div>
                                <div class="mb-4">
                                    <label for="focus_keyword" class="form-label"> {{ __('focus_keyword') }} </label>
                                    <input type="text" class="form-control rounded-2" id="focus_keyword"
                                        name="focus_keyword" value="{{ old('focus_keyword') }}"
                                        placeholder="{{ __('focus_focus_keyword') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('focus_keyword') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_focus_keyword') }})</p>
                                </div>
                                <div class="mb-4">
                                    <label for="tags" class="form-label"> {{ __('tags') }} </label>
                                    <input type="text" class="form-control rounded-2" id="tags" name="tags"
                                        value="{{ old('tags') }}" placeholder="{{ __('tags') }}">
                                    <div class="nk-block-des text-danger">
                                        <p class="error">{{ $errors->first('tags') }}</p>
                                    </div>
                                    <p class="text-muted">({{ __('use_comma_to_separate_tags') }})</p>
                                </div>

                                <button type="submit" class="btn sg-btn-primary">{{ __('submit') }}</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script>
        "use strict";
        $('#description').summernote({
            height: 210,
        });
        $("#tv_name").keyup(function() {
            var Text = $(this).val();
            Text = Text.toLowerCase();
            Text = Text.replace(/[^\w ]+/g, '');
            Text = Text.replace(/ +/g, '-');
            $("#slug").val(Text);
            
        });
    </script>
@endpush
