<header class="navbar-dark-v1">
    <div class="header-position">
        <span class="sidebar-toggler">
            <i class="las la-times"></i>
        </span>
        <div class="dashboard-logo d-flex justify-content-center align-items-center py-20">
            <a class="logo" href="{{ route('admin.dashboard') }}">

                <img src="{{ ($logo = json_decode(get_config('admin_logo'), true)) && isset($logo['original_image']) && is_file_exists($logo['original_image']) ? get_media($logo['original_image']) : get_media('images/default/logo/logo.png') }}"
                    alt="Logo">
            </a>
            <a class="logo-icon" href="{{ route('admin.dashboard') }}">
                <img src="{{ ($logo = json_decode(get_config('admin_mini_logo'), true)) && isset($logo['original_image']) && is_file_exists($logo['original_image']) ? get_media($logo['original_image']) : get_media('images/default/logo/logo-mini.png') }}"
                    alt="Logo">
            </a>
        </div>

        <nav class="side-nav">
            <ul id="accordionSidebar">
                @can('admin.dashboard')
                <li class="{{ menuActivation('admin/dashboard', 'active') }}">
                    <a href="{{ route('admin.dashboard') }}" role="button" aria-expanded="false"
                        aria-controls="dashboard">
                        <i class="las la-tachometer-alt"></i>
                        <span>{{ __('dashboard') }}</span>
                    </a>
                </li>
                @endcan
                @canany([
                'admin.movies',
                'admin.categories',
                'admin.video.qualities',
                'admin.download_links',
                'admin.countries',
                'admin.genres',
                'admin.stars',
                'admin.languages',
                'admin.movie_industries',
                'admin.reviews'
                ])
                <li
                    class="{{ menuActivation(['admin/movie*', 'admin/categories', 'admin/video-qualit*', 'admin/download-links*', 'admin/countries', 'admin/genres', 'admin/stars', 'admin/languages', 'admin/movie-industries', 'admin/reviews'], 'active') }}">
                    <a href="#movies" class="dropdown-icon" data-bs-toggle="collapse" role="button" aria-expanded="{{ menuActivation(['admin/movie*', 'admin/download-links*', 'admin/video-qualit*', 'admin/countries', 'admin/genres', 'admin/stars', 'admin/languages', 'admin/movie-industries', 'admin/reviews'], 'true', 'false') }}" aria-controls="movies">
                        <i class="las la-film"></i>
                        <span>{{ __('movies') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation([
        'admin/movie*',
        'admin/categories',
        'admin/video-qualit*',
        'admin/download-links*',
        'admin/countries',
        'admin/genres',
        'admin/stars',
        'admin/languages',
        'admin/movie-industries',
        'admin/reviews'
    ], 'show') }}" id="movies" data-bs-parent="#accordionSidebar">
                        @can('admin.movies')
                        <li>
                            <a class="{{ menuActivation(['admin/movie*', 'admin/download-links*'], 'active') }}"
                                href="{{ route('admin.movies') }}">{{ __('all_movie') }}</a>
                        </li>
                        @endcan

                        @can('admin.categories')
                        <li>
                            <a class="{{ menuActivation('admin/categories', 'active') }}"
                                href="{{ route('admin.categories') }}">{{ __('video_type') }}</a>
                        </li>
                        @endcan

                        @can('admin.video.qualities')
                        <li>
                            <a class="{{ menuActivation('admin/video-qualit*', 'active') }}"
                                href="{{ route('admin.video.qualities') }}">{{ __('video_quality') }}</a>
                        </li>
                        @endcan

                        @can('admin.countries')
                        <li>
                            <a class="{{ menuActivation('admin/countries', 'active') }}"
                                href="{{ route('admin.countries') }}">{{ __('country') }}</a>
                        </li>
                        @endcan

                        @can('admin.genres')
                        <li>
                            <a class="{{ menuActivation('admin/genres', 'active') }}"
                                href="{{ route('admin.genres') }}">{{ __('genre') }}</a>
                        </li>
                        @endcan

                        @can('admin.stars')
                        <li>
                            <a class="{{ menuActivation(['admin/stars'], 'active') }}"
                                href="{{ route('admin.stars') }}">
                                <span>{{ __('stars') }}</span>
                            </a>
                        </li>
                        @endcan

                        @can('admin.languages')
                        <li>
                            <a class="{{ menuActivation(['admin/languages'], 'active') }}"
                                href="{{ route('admin.languages') }}">
                                <span>{{ __('movie_language') }}</span>
                            </a>
                        </li>
                        @endcan

                        @can('admin.movie_industries')
                        <li>
                            <a class="{{ menuActivation(['admin/movie-industries'], 'active') }}" href="{{ route('admin.movie_industries') }}">
                                <span>{{ __('movie_industries') }}</span>
                            </a>
                        </li>
                        @endcan

                        @can('admin.reviews')
                        <li>
                            <a class="{{ menuActivation(['admin/reviews'], 'active') }}"
                                href="{{ route('admin.reviews') }}">
                                <span>{{ __('reviews') }}</span>
                            </a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany

                @canany([
                'admin.tv.shows',
                'admin.tv.show.settings'
                ])
                <li class="{{ menuActivation(['admin/tv-show*', 'admin/season*', 'admin/episode*'], 'active') }}">
                    <a href="#tv-show" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ menuActivation(['admin/tv-show*', 'admin/season*', 'admin/episode*'], 'true', 'false') }}"
                        aria-controls="tv-show">
                        <i class="las la-tv"></i>
                        <span>{{ __('series') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/tv-show*', 'admin/season*', 'admin/episode*'], 'show') }}"
                        id="tv-show" data-bs-parent="#accordionSidebar">
                        @can('admin.tv.shows')
                            <li>
                                <a class="{{ menuActivation(['admin/tv-show*'], 'active') }}"
                                href="{{route('admin.tv.shows')}}">{{ __('all_tv_shows') }}</a>
                            </li>
                        @endcan
                        @can('admin.seasons')
                        <li> <a class="{{ menuActivation(['admin/season*'], 'active') }}" href="{{route('admin.seasons')}}">{{ __('all_seasons') }}</a> </li>
                        @endcan
                        @can('admin.episodes')
                        <li> <a class="{{ menuActivation(['admin/episode*'], 'active') }}" href="{{route('admin.episodes')}}">{{ __('all_episodes') }}</a> </li>
                        @endcan
                        @can('admin.tv.show.settings')
                        <li> <a class="{{ menuActivation('admin/tv-show-settings', 'active') }}"
                                href="{{route('admin.tv.show.settings')}}">{{ __('setting') }}</a> </li>
                        @endcan
                    </ul>
                </li>
                @endcanany
                @can(['admin.live.tvs', 'admin.live.tv.categories'])
                <li
                    class="{{ menuActivation(['admin/live-tv-categories', 'admin/live-tvs-*', 'admin/live-tvs', 'admin/live-tv-categorie/*', 'admin/live-tv/*'], 'active') }}">
                    <a href="#live-tv" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ menuActivation(['admin/live-tv-categories', 'admin/live-tvs', 'admin/live-tv-categorie/*', 'admin/live-tv/*'], 'true', 'false') }}"
                        aria-controls="live-tv">
                        <i class="lab la-chromecast"></i>
                        <span>{{ __('live_tv') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/live-tv-categorie*', 'admin/live-tv*'], 'show') }}"
                        id="live-tv" data-bs-parent="#accordionSidebar">
                        @can('admin.live.tvs') <li> <a class="{{ menuActivation(['admin/live-tvs', 'admin/live-tvs-list'], 'active') }}"
                                href="{{route('admin.live.tvs')}}">{{ __('all_channels') }}</a> </li>
                        @endcan
                        @can('admin.live.tv.categories') <li> <a class="{{ menuActivation(['admin/live-tv-categories', 'admin/live-tv-categorie/*'], 'active') }}"
                                href="{{route('admin.live.tv.categories')}}">{{ __('categories') }}</a> </li>@endcan
                    </ul>
                </li>
                @endcan
                @can('admin.importer')
                <li class="{{ menuActivation(['admin/importer'], 'active') }}">
                    <a href="{{route('admin.importer')}}" role="button" aria-expanded="false" aria-controls="dashboard">
                        <i class="las la-file-import"></i>
                        <span>{{ __('tmdb_importer') }}</span>
                    </a>
                </li>
                @endcan
                @can('admin.interest')
                <li class="{{ menuActivation(['admin/interest'], 'active') }}">
                    <a href="{{route('admin.interest')}}" role="button" aria-expanded="false" aria-controls="dashboard">
                        <i class="lar la-heart"></i>
                        <span>{{ __('interest_list') }}</span>
                    </a>
                </li>
                @endcan
                @can('admin.customer_queries.index')
                <li class="{{ menuActivation(['admin/customer-queries'], 'active') }}">
                    <a href="{{route('admin.customer_queries.index')}}" role="button">
                        <i class="las la-ticket-alt"></i>
                        <span>{{ __('customer_queries') }}</span>
                    </a>
                </li>
                @endcan
                @can('admin.movie_requests')
                <li class="{{ menuActivation(['admin/request-movie'], 'active') }}">
                    <a href="{{route('admin.movie_requests')}}" role="button">
                        <i class="las la-paper-plane"></i>
                        <span>{{ __('movie_requests') }}</span>
                    </a>
                </li>
                @endcan
                @can('admin.reports')
                <li class="{{ menuActivation(['admin/reports'], 'active') }}">
                    <a href="{{route('admin.reports')}}" role="button">
                        <i class="las la-bug"></i>
                        <span>{{ __('reports') }}</span>
                    </a>
                </li>
                @endcan
                @canany(['admin.blogs', 'admin.blog.categories'])
                <li class="{{ menuActivation(['admin/blog-categories*', 'admin/blogs', 'admin/blog-*'], 'active') }}">
                    <a href="#blogs" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ menuActivation(['admin/blogs', 'admin/blog-categories', 'admin/blog-*'], 'true', 'false') }}"
                        aria-controls="staff">
                        <i class="las la-rss"></i>
                        <span>{{ __('blogs') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/blog-categories*', 'admin/blogs', 'admin/blog-*'], 'show') }}"
                        id="blogs" data-bs-parent="#accordionSidebar">
                        @can('admin.blogs')
                        <li> <a class="{{ menuActivation(['admin/blogs'], 'active') }}"
                                href="{{route('admin.blogs')}}">{{ __('all_post') }}</a> </li>
                        @endcan
                        @can('admin.blog.categories')
                        <li> <a class="{{ menuActivation('admin/blog-categories*', 'active') }}"
                                href="{{route('admin.blog.categories')}}">{{ __('category') }}</a> </li>@endcan
                    </ul>
                </li>
                @endcanany


                @canany([
                'admin.ads',
                'admin.ads.pre_roll.index',
                'admin.ads.mid_roll.index',
                'admin.ads.post_roll.index',
                ])
                <li class="{{menuActivation(['admin/ads*'], 'active')}}">
                    <a href="#monetization" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{menuActivation(['admin/ads*'], 'active')}}" aria-controls="monetization">
                        <i class="las la-hand-holding-usd"></i>
                        <span>{{ __('monetization') }}</span>
                    </a>

                    <ul class="sub-menu collapse {{ menuActivation(['admin/ads*'], 'show') }}" id="monetization"
                        data-bs-parent="#monetization">

                        @can('admin.ads')
                        <li>
                            <a class="{{menuActivation(['admin/ads'], 'active')}}"
                                href="{{route('admin.ads')}}">{{ __('website_ads') }}</a>
                        </li>
                        @endcan

                        @can('admin.ads.pre_roll.index')
                        <li>
                            <a class="{{menuActivation(['admin/ads/pre-roll*'], 'active')}}"
                                href="{{route('admin.ads.pre_roll.index')}}">{{ __('preroll_ads') }}</a>
                        </li>
                        @endcan

                        @can('admin.ads.mid_roll.index')
                        <li>
                            <a class="{{menuActivation(['admin/ads/mid-roll*'], 'active')}}"
                                href="{{route('admin.ads.mid_roll.index')}}">{{ __('midroll_ads') }}</a>
                        </li>
                        @endcan

                        @can('admin.ads.post_roll.index')
                        <li>
                            <a class="{{menuActivation(['admin/ads/post-roll*'], 'active')}}"
                                href="{{route('admin.ads.post_roll.index')}}">{{ __('postroll_ads') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany

                @canany([
                'admin.subscribers',
                'all.subscription',
                'rental.history',
                'admin.packages',
                'payment.gateway',
                'transaction.log',
                ])
                <li
                    class="{{menuActivation(['admin/package*', 'admin/rental-history*', 'admin/transaction-log*', 
                    'admin/payment-gateway*', 'admin/subscriber*', 
                    'admin/all-subscription'], 'active')}}">
                    <a href="#subscription" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{menuActivation(['admin/package*', 'admin/rental-history*',
                         'admin/transaction-log*', 'admin/payment-gateway*', 'admin/subscriber*', 'admin/all-subscription'], 'active')}}"
                        aria-controls="subscription">
                        <i class="las la-cubes"></i>
                        <span>{{ __('manage_subscription') }}</span>
                    </a>

                    <ul class="sub-menu collapse {{ menuActivation(['admin/package*', 'admin/rental-history*', 'admin/payment-gateway*', 'admin/subscriber*', 'admin/all-subscription', 'admin/transaction-log*'], 'show') }}"
                        id="subscription" data-bs-parent="#accordionSidebar">

                        @can('admin.subscribers')
                        <li>
                            <a class="{{menuActivation(['admin/subscriber*'], 'active')}}"
                                href="{{route('admin.subscribers')}}">{{ __('all_subscriber') }}</a>
                        </li>
                        @endcan

                        @can('all.subscription')
                        <li>
                            <a class="{{menuActivation(['admin/all-subscription'], 'active')}}"
                                href="{{route('all.subscription')}}">{{ __('all_subscription') }}</a>
                        </li>
                        @endcan

                        @can('rental.history')
                        <li>
                            <a class="{{menuActivation(['admin/rental-history*'], 'active')}}"
                                href="{{route('rental.history')}}">{{ __('rental_history') }}</a>
                        </li>
                        @endcan

                        @can('admin.packages')
                        <li>
                            <a class="{{menuActivation(['admin/package*'], 'active')}}"
                                href="{{route('admin.packages')}}">{{ __('price_plan') }}</a>
                        </li>
                        @endcan

                        @can('payment.gateways')
                        <li>
                            <a class="{{menuActivation(['admin/payment-gateway*'], 'active')}}"
                                href="{{route('payment.gateways')}}">{{ __('payment_setting') }}</a>
                        </li>
                        @endcan

                        @can('transaction.log')
                        <li>
                            <a class="{{menuActivation(['admin/transaction-log*'], 'active')}}"
                                href="{{route('transaction.log')}}">{{ __('transaction_log') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany

                @canany([
                'admin.theme.options',
                'admin.faqs',
                'pages.index'
                ])
                <li class="{{ menuActivation(['admin/pages*', 'admin/faq*', 'admin/website/*'], 'active') }}">
                    <a href="#website-setting" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ menuActivation(['admin/website/*', 'admin/faq*'], 'active') }}"
                        aria-controls="website-setting">
                        <i class="las la-wrench"></i>
                        <span>{{ __('website_settings') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/pages*', 'admin/faq*', 'admin/website/*'], 'show') }}"
                        id="website-setting" data-bs-parent="#accordionSidebar">

                        @can('admin.theme.options')
                        <li>
                            <a class="{{ menuActivation(['admin/website/*'], 'active') }}"
                                href="{{ route('admin.theme.options') }}">{{ __('all_setting') }}</a>
                        </li>
                        @endcan

                        @can('admin.faqs')
                        <li>
                            <a class="{{ menuActivation(['admin/faq*'], 'active') }}"
                                href="{{ route('admin.faqs') }}">{{ __('faqs') }}</a>
                        </li>
                        @endcan

                        @can('pages.index')
                        <li>
                            <a class="{{ menuActivation('admin/pages*', 'active') }}" href="{{ route('pages.index') }}">{{ __('pages') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany
                @can('admin.movie.settings')    
                <li class="{{ menuActivation(['admin/api-settings','admin/mobile-ads-settings'], 'active') }}">
                    <a href="#movie-app-setting" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ menuActivation(['admin/api-settings','admin/mobile-ads-settings'], 'active') }}"
                        aria-controls="website-setting">
                        <i class="las la-mobile"></i>
                        <span>{{ __('mobile_app_settings') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/api-settings','admin/mobile-ads-settings'], 'show') }}"
                        id="movie-app-setting" data-bs-parent="#accordionSidebar">

                        @can('admin.api.settings')
                        <li>
                            <a class="{{ menuActivation(['admin/api-settings'], 'active') }}"
                                href="{{ route('admin.api.settings') }}">{{ __('api_settings') }}</a>
                        </li>
                        @endcan

                        @can('admin.ads.settings')
                        <li>
                            <a class="{{ menuActivation(['admin/mobile-ads-settings'], 'active') }}"
                                href="{{ route('admin.ads.settings') }}">{{ __('ads_settings') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcan
                @canany([
                'admin.staffs',
                'roles.index'
                ])
                <li class="{{ menuActivation(['admin/staff*', 'admin/roles*'], 'active') }}">
                    <a href="#staff" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ menuActivation(['admin/staff*', 'admin/roles*'], 'true', 'false') }}"
                        aria-controls="staff">
                        <i class="las la-user-friends"></i>
                        <span>{{ __('staffs') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/staff*', 'admin/roles*'], 'show') }}"
                        id="staff" data-bs-parent="#accordionSidebar">

                        @can('admin.staffs')
                        <li>
                            <a class="{{ menuActivation('admin/staff*', 'active') }}"
                                href="{{ route('admin.staffs') }}">{{ __('all_staffs') }}</a>
                        </li>
                        @endcan

                        @can('roles.index')
                        <li>
                            <a class="{{ menuActivation('admin/roles*', 'active') }}"
                                href="{{ route('roles.index') }}">{{ __('roles') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany

                @canany([
                'email.template',
                'email.server-configuration',
                ])
                <li class="{{ menuActivation(['admin/email/server-configuration*', 'admin/email/template*'], 'active') }}">
                    <a href="#emailSetting" class="dropdown-icon" data-bs-toggle="collapse"
                        aria-expanded="{{ menuActivation(['admin/email/server-configuration*', 'admin/email/template*'], 'true', 'false') }}"
                        aria-controls="emailSetting">
                        <i class="las la-envelope"></i>
                        <span>{{ __('email_settings') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/email/server-configuration*', 'admin/email/template*'], 'show') }}"
                        id="emailSetting" data-bs-parent="#accordionSidebar">

                        @can('email.template')
                        <li>
                            <a class="{{ menuActivation('admin/email/template*', 'active') }}"
                                href="{{ route('email.template') }}">{{ __('email_template') }}</a>
                        </li>
                        @endcan

                        @can('email.server-configuration')
                        <li>
                            <a class="{{ menuActivation('admin/email/server-configuration*', 'active') }}"
                                href="{{ route('email.server-configuration') }}">{{ __('server_configuration') }}</a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany
                @canany([
                'admin.system.settings',
                'admin.settings',
                'admin.system.languages',
                'admin.tmdb.settings',
                'admin.social.settings',
                'admin.recaptcha.settings',
                ])
                <li class="{{menuActivation(['admin/system-settings*', 'admin/system-language*', 'admin/admin-settings', 'admin/tmdb-settings', 'admin/social-settings', 'admin/recaptcha-settings'], 'active')}}">
                    <a href="#settings" class="dropdown-icon" data-bs-toggle="collapse" role="button"
                        aria-expanded=""
                        aria-controls="settings">
                        <i class="las la-cog"></i>
                        <span>{{ __('settings') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{menuActivation(['admin/system-settings*', 'admin/system-language*', 'admin/admin-settings', 'admin/tmdb-settings', 'admin/social-settings', 'admin/recaptcha-settings'], 'show')}}"
                        id="settings" data-bs-parent="#accordionSidebar">

                        @can('admin.system.settings')
                        <li>
                            <a class="{{menuActivation(['admin/system-settings'], 'active')}}"
                                href="{{route('admin.system.settings')}}">{{ __('system_settings') }}</a>
                        </li>
                        @endcan

                        @can('admin.settings')
                        <li>
                            <a class="{{menuActivation(['admin/admin-settings'], 'active')}}"
                                href="{{route('admin.settings')}}">{{ __('admin_settings') }}</a>
                        </li>
                        @endcan

                        @can('admin.system.languages')
                        <li>
                            <a class="{{menuActivation(['admin/system-language*'], 'active')}}"
                                href="{{route('admin.system.languages')}}">{{ __('languages') }}</a>
                        </li>
                        @endcan

                        @can('admin.tmdb.settings')
                        <li>
                            <a class="{{menuActivation(['admin/tmdb-settings'], 'active')}}"
                                href="{{route('admin.tmdb.settings')}}">{{ __('tmdb_settings') }}</a>
                        </li>
                        @endcan

                        @can('admin.social.settings')
                        <li>
                            <a class="{{menuActivation(['admin/social-settings'], 'active')}}"
                                href="{{route('admin.social.settings')}}">{{ __('social_settings') }}</a>
                        </li>
                        @endcan

                        @can('admin.recaptcha.settings')
                        <li>
                            <a class="{{menuActivation(['admin/recaptcha-settings'], 'active')}}"
                                href="{{route('admin.recaptcha.settings')}}">{{ __('recaptcha_settings') }}</a>
                        </li>
                        @endcan
                    </ul>
                </li>
                @endcanany

                @canany([
                'system.update',
                'server.info'
                ])
                <li class="{{ menuActivation(['admin/server-info', 'admin/system-info', 'admin/extension-library', 'admin/file-system-permission', 'admin/system-update'], 'active') }}">
                    <a href="#utility" class="dropdown-icon" data-bs-toggle="collapse"
                        aria-expanded="{{ menuActivation(['admin/server-info', 'admin/system-info', 'admin/extension-library', 'admin/file-system-permission', 'admin/system-update'], 'true', 'false') }}"
                        aria-controls="utility">
                        <i class="las la-cogs"></i>
                        <span>{{ __('utility') }}</span>
                    </a>
                    <ul class="sub-menu collapse {{ menuActivation(['admin/server-info', 'admin/system-info', 'admin/extension-library', 'admin/file-system-permission', 'admin/system-update'], 'show') }}"
                        id="utility" data-bs-parent="#accordionSidebar">
                        @can('system.update')
                        <li>
                            <a class="{{ menuActivation(['admin/system-update'], 'active') }}"
                                href="{{ route('system.update') }}">{{ __('system_update') }}</a>
                        </li>
                        @endcan
                        @can('server.info')
                        <li>
                            <a class="{{ menuActivation(['admin/server-info', 'admin/system-info', 'admin/extension-library', 'admin/file-system-permission'], 'active') }}"
                                href="{{ route('server.info') }}">{{ __('server_information') }}</a>
                        </li>
                        @endcan
                    </ul>
                </li>
                @endcanany
            </ul>
        </nav>
    </div>
</header>