@extends('admin.layouts.master')
@section('title', __('importer'))
@section('content')

<section class="oftions">
    <div class="container-fluid">
        <div class="row">
            <div class="col col-md-12">
                <div class="header-top d-flex justify-content-between align-items-center">
                    <h3 class="section-title">{{ __('tmdb_importer') }}</h3>

                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="bg-white redious-border rounded-20 p-20 p-sm-30">
                            <h4> {{ __('import_movies/tv_show_from_tmdb') }} </h4>
                            <hr>
                            <div class="d-flex align-items-center flex-wrap gap-3">
                                <select class="form-select form-select-lg mb-3 with_search w-27" name="language"
                                    id="language">
                                    <option value=""> {{ __('select_movie_language') }} </option>
                                    @foreach ($movie_languages as $language)
                                    <option value="{{ $language->slug }}"
                                        {{ $language->slug == get_config('tmdb_default_language') ? 'selected' : '' }}>
                                        {{ $language->name }}
                                    </option>
                                    @endforeach
                                </select>
                                <select class="form-select form-select-lg mb-3 with_search" name="type"
                                    id="type">

                                    <option value="movies_by_title">{{ __('movies_by_title') }}</option>
                                    <option value="popular_movies">{{ __('popular_movies') }}</option>
                                    <option value="top_rated_movies">{{ __('top_rated_movies') }}</option>
                                    <option value="upcoming_movies">{{ __('upcoming_movies') }}</option>
                                    <option value="movies_by_year">{{ __('movies_by_year') }}</option>
                                    <option value="movies_by_genre">{{ __('movies_by_genre') }}</option>
                                    <option value="movies_by_keyword">{{ __('movies_by_keyword') }}
                                    </option>
                                    <option value="movies_by_people">{{ __('movies_by_people') }}</option>

                                    <option value="tvshows_by_title">{{ __('tvshows_by_title') }}
                                    </option>
                                    <option value="popular_tvshows">{{ __('popular_tvshows') }}</option>
                                    <option value="top_rated_tvshows">{{ __('top_rated_tvshows') }}
                                    </option>
                                    <option value="on_air_tvshows">{{ __('on_air_tvshows') }}
                                    </option>
                                    <option value="tvshows_by_year">{{ __('tvshows_by_year') }}</option>
                                    <option value="tvshows_latest">{{ __('tvshows_latest') }}</option>
                                    <option value="tvshows_by_people">{{ __('tvshows_by_people') }}
                                    </option>
                                </select>
                                <input type="text" class="form-control" id="title" name="title"
                                    placeholder="{{ __('enter_movie/tv_show_title,_keywords_here') }}">
                                <input type="text" class="form-control placeholder-font d-none" name="tmdb_id"
                                    id="tmdb-id" placeholder="{{ __('Enter ID Here') }}" aria-label="Search"
                                    aria-describedby="search-addon">
                                <input type="number" class="form-control placeholder-font d-none" name="year"
                                    id="year" placeholder="{{ __('Ex:2025') }}" aria-label="Search"
                                    aria-describedby="search-addon" value="{{date('Y')}}">
                                <input type="number" class="form-control placeholder-font input-page-no" name="page"
                                    min="1" id="page" placeholder="{{ __('Page no.Ex:5(optional)') }}"
                                    aria-label="Search" aria-describedby="search-addon">
                                @can('admin.fetch.movies')
                                <button type="button" class="btn sg-btn-primary"
                                    id="fetchButton">{{ __('fetch') }}</button>
                                @endcan
                            </div>
                        </div>
                        <div class="mt-3 bg-white redious-border rounded-20 p-20 p-sm-30" id="fetch-data">
                            {{ __('list_will_be_show_here') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
@push('js')
<script>
    "use strict";
    // On change of the select dropdown
    $('#type').on('change', function() {
        const selected = $('#type').val();

        if (selected == 'movies_by_year' || selected == 'tvshows_by_year') {
            $('input[name="year"]').removeClass('d-none');
        } else {
            $('input[name="year"]').addClass('d-none');
        }

        if (selected == 'movies_by_genre') {
            $('input[name="tmdb_id"]').removeClass('d-none');
        } else {
            $('input[name="tmdb_id"]').addClass('d-none');
        }
    });

    $(document).ready(function() {
        $("#fetchButton").click(function() {
            var language = $("#language").val();
            var type = $("#type").val();
            var title = $("#title").val();
            var year = $("#year").val();
            var tmdb_id = $("#tmdb-id").val();
            var page = $("#page").val() || 1;
            var movie_tmdb_ids = {!! json_encode($movie_tmdb_ids ?? []) !!}; // Defaults to []
            var tv_show_tmdb_ids = {!! json_encode($tv_show_tmdb_ids ?? []) !!};

            $("#fetch-data").html(""); // Clear previous results

            if (!language) {
                toastr['error']('{{ __('language_field_is_required') }}');
                return false;
            }
            if (!type) {
                toastr['error']('{{ __('type_field_is_required') }}');
                return false;
            }

            $.ajax({
                url: "{{ route('admin.fetch.movies') }}",
                type: "GET",
                data: {
                    language: language,
                    type: type,
                    title: title,
                    year: year,
                    tmdb_id: tmdb_id,
                    page: page
                },
                success: function(response) {
                    if (response.results && response.results.length > 0) {
                        response.results.forEach(function(movie) {
                            let rawImportUrl =
                                `{{ route('admin.import.db', ['language' => '__LANG__', 'type' => '__TYPE__', 'id' => '__ID__']) }}`;

                            // Detect type and map to import route prefix
                            let selectedType = $('#type').val();
                            let language = $('#language').val();
                            let movieId = movie.id;

                            // Convert type (e.g. movies_by_title -> movie/title)
                            let finalType = selectedType
                                .replace('movies_', 'movies_')
                                .replace('tvshows_', 'tvshows_');

                            // Final import URL
                            let importUrl = rawImportUrl
                                .replace('__LANG__', encodeURIComponent(language))
                                .replace('__TYPE__', finalType)
                                .replace('__ID__', encodeURIComponent(movieId));

                            // Determine existence based on type
                            let isExisting = false;
                            if ([
                                    'movies_by_title',
                                    'popular_movies',
                                    'top_rated_movies',
                                    'upcoming_movies',
                                    'movies_by_year',
                                    'movies_by_genre',
                                    'movies_by_keyword',
                                    'movies_by_people',
                                ].includes(selectedType)) {
                                isExisting = movie_tmdb_ids.includes(movieId);
                            } else if ([
                                    'tvshows_by_title',
                                    'popular_tvshows',
                                    'top_rated_tvshows',
                                    'on_air_tvshows',
                                    'tvshows_by_year',
                                    'tvshows_latest',
                                    'tvshows_by_people',
                                ].includes(selectedType)) {
                                isExisting = tv_show_tmdb_ids.includes(movieId);
                            }

                            // Generate Import Button
                            let importButton = isExisting ?
                                `<button class="px-3 py-1 mt-2 btn sg-btn-primary rounded border-0 text-muted" disabled>
                                            <i class='bx bx-check'></i> Imported
                                        </button>` :
                                `<a href="javascript:void(0)" data-url="${importUrl}"
                                            class="px-3 py-1 mt-2 btn sg-btn-primary rounded border-0 text-muted import-db"
                                            data-toggle="tooltip" title="Import">
                                            <i class='bx bx-import'></i> {{ __('import') }}
                                        </a>`;

                            // Append movie block
                            $("#fetch-data").append(`
                                        <div class="movie-item">
                                            <div class="d-flex align-items-center gap-3">
                                                <img src="https://image.tmdb.org/t/p/w200${movie.poster_path}" width="100" class="rounded" alt="${movie.title || movie.name}">
                                                <div>
                                                    <h5>${movie.title || movie.name} (${movie.release_date || movie.first_air_date})</h5>
                                                    <p>{{ __('rating') }}: ${movie.vote_average}</p>
                                                    <p>{{ __('description') }}: ${movie.overview || 'N/A'}</p>
                                                    ${importButton}
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                    `);
                        });
                    } else {
                        $("#fetch-data").html("<p>{{ __('no_results_found') }}</p>");
                    }
                },
                error: function() {
                    $("#fetch-data").html(
                        "<p>{{ __('error_fetching_data_please_try_again') }}</p>");
                }
            });
        });
    });


    $(document).ready(function() {
        $(document).on("click", ".import-db", function() {
            var selector = this;
            $(selector).text('{{ __('importing') }}');
            $(selector).addClass('disabled');
            var url = $(this).data('url');
            $.ajax({
                dataType: "json",
                type: "GET",
                url: url,
                success: function(response) {
                    if (response.status == 'success') {
                        $(selector).addClass('btn-outline-success disabled');
                        $(selector).removeClass('btn-outline-info import-db');
                        $(selector).text('{{ __('imported') }}');
                    } else if (response.status == 'info') {
                        toastr['info'](response.message);
                    } else {
                        toastr['error'](response.message);
                    }
                }
            }).done(function(response) {
                toastr['success'](response.message);
            });
        });
    });
</script>
@endpush