<form action="{{ route('admin.download_link.update', ['id' => $downloadLink->id]) }}" method="post"
    class="form-validate form">
    @csrf

    <div class="mb-2">
        <label class="form-label">{{ __('download_link_title') }} <span class="text-danger">*</span></label>
        <input type="text" name="title" class="form-control rounded-2" value="{{ old('title', $downloadLink->title) }}"
            placeholder="{{ __('title') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('title') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="resolution" class="form-label"> {{ __('resolution') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="resolution" name="resolution"
            value="{{ old('resolution', $downloadLink->resolution) }}" placeholder="{{ __('enter_resolution') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('resolution') }}</p>
        </div>
    </div>
    <div class="mb-2">
        <label for="file_size" class="form-label"> {{ __('file_size') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control rounded-2" id="file_size" name="file_size"
            value="{{ old('file_size', $downloadLink->file_size) }}" placeholder="{{ __('enter_file_size') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('file_size') }}</p>
        </div>
    </div>

    <div class="mb-2">
        <label class="form-label">{{ __('download_link') }} <span class="text-danger">*</span></label>
        <input type="url" name="link" class="form-control rounded-2"
            value="{{ old('link', $downloadLink->link) }}" placeholder="{{ __('https') }}">
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('link') }}</p>
        </div>
    </div>

    <div class="mb-2">
        <label class="form-label">{{ __('status') }} <span class="text-danger">*</span></label>
        <select name="status" class="form-select select2">
            <option value="1" {{ $downloadLink->status == '1' ? 'selected' : '' }}>{{ __('active') }}</option>
            <option value="0" {{ $downloadLink->status == '0' ? 'selected' : '' }}>{{ __('inactive') }}</option>
        </select>
        <div class="nk-block-des text-danger">
            <p class="error">{{ $errors->first('status') }}</p>
        </div>
    </div>

    <button type="submit" class="btn sg-btn-primary">{{ __('update') }}</button>
    @include('layouts.loading_button', ['class' => 'btn sg-btn-primary'])
</form>

<script>
    "use strict";
    $('.with_search').select2({
        dropdownParent: $('#ajaxModal')
    });
</script>
