<table class="table table-borderless best-selling-courses">
    <thead>
        <tr>
            <th>{{ __('client') }}</th>
            <th>{{ __('price') }}</th>
            <th>{{ __('date') }}</th>
        </tr>
    </thead>
    <tbody>
        @forelse($recent_subscriptions ?? [] as $subscription)
            @php
                $client = App\Models\User::where('client_id', $subscription->client_id)->first();
                if(!$client) {
                    continue;
                }
            @endphp
            <tr>
                <td>
                    <div class="instructors-pro d-flex align-items-center">
                        <div class="inst-avtar">
                            <img src="{{getFileLink('image', $client->image, 'users', '80x80')}}"
                                alt="{{ $client->first_name.' '.$client->last_name ?? 'Client' }}">
                        </div>
                        <div class="inst-intro">
                            <h6>{{ $client->first_name.' '.$client->last_name ?? 'Client' }}</h6>
                            <p>{{ $client->email ?? '' }}</p>
                        </div>
                    </div>
                </td>
                <td>{{ get_currency(number_format($subscription->price, 2)) }}</td>
                <td>{{ $subscription->created_at->format('m-d-Y h:i a') }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="3">{{ __('no_recent_subscriptions') }}</td>
            </tr>
        @endforelse
    </tbody>
</table>
