<table class="table table-borderless best-selling-courses best-instructor">
    <thead>
        <tr>
            <th>{{ __('name') }}</th>
            <th>{{ __('total_spend') }}</th>
            <th>{{ __('started_at') }}</th>
        </tr>
    </thead>
    <tbody>
        @forelse($best_clients ?? [] as $client_id => $total)
            @php
                $client = App\Models\User::where('client_id', $client_id)->first();
                $total_spend = App\Models\Subscription::where('client_id', $client_id)->sum('price');
            @endphp
            <tr>
                <td>
                    <div class="instructors-pro d-flex align-items-center">
                        <div class="inst-avtar">
                            <img src="{{getFileLink('image', $client->image, 'users', '80x80')}}"
                                alt="{{ $client->first_name.' '.$client->last_name ?? 'Client' }}">
                        </div>
                        <div class="inst-intro">
                            <h6>{{ $client->first_name.' '.$client->last_name ?? 'Client' }}</h6>
                            <p>{{ $client->email ?? '' }}</p>
                        </div>
                    </div>
                </td>
                <td>{{ get_currency(number_format($total_spend, 2)) }}</td>
                <td>{{ $client->created_at->format('d M Y') ?? '' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="3">{{ __('no_best_clients_found') }}</td>
            </tr>
        @endforelse
    </tbody>
</table>
