(function ($) {
    "use strict";
    /*********************************
     * Table of Context
     * *******************************/
    /*********************************
    /* Preloader Start
    *********************************/
    $(window).on("load", function () {
        $("#ovoo__preloader").addClass("loaded");
        setTimeout(function () {
            $("#preloader").remove();
        }, 1000); // 1 second delay to remove preloader
    });

    /*********************************
    /* Sticky Navbar
    *********************************/
    $(window).scroll(function () {
        var scrolling = $(this).scrollTop();
        var stikey = $(".header");

        if (scrolling >= 50) {
            $(stikey).addClass("nav-bg");
        } else {
            $(stikey).removeClass("nav-bg");
        }
    });

    /*********************************
    /*  Mobile Menu Flyout Menu
    *********************************/
    $(".header__toggle").on("click", function (event) {
        event.preventDefault();
        $(".flyoutMenu").toggleClass("active");
    });
    $(".closest__btn").on("click", function (event) {
        event.preventDefault();
        $(".flyoutMenu").toggleClass("active");
    });

    $(document).on("click", function (e) {
        if (
            $(e.target).closest(".flyout__flip").length === 0 &&
            $(e.target).closest(".header__toggle").length === 0
        ) {
            $(".flyoutMenu").removeClass("active");
        }
    });

    /*********************************
    /*  Mobile Menu Expand
    *********************************/
    $(".flyout-main__menu .has__dropdown .nav__link").click(function () {
        $(".sub__menu").slideUp(400);
        if ($(this).parent().hasClass("active")) {
            $(".has__dropdown").removeClass("active");
            $(this).parent().removeClass("active");
        } else {
            $(".has__dropdown").removeClass("active");
            $(this).next(".sub__menu").slideDown(400);
            $(this).parent().addClass("active");
        }
    });

    /********************************
     * ToolTip Dropdown
     ********************************/
    var tooltipTriggerList = document.querySelectorAll(
        '[data-bs-toggle="tooltip"]'
    );
    tooltipTriggerList.forEach(function (tooltipTriggerEl) {
        new bootstrap.Tooltip(tooltipTriggerEl);
    });

    /********************************
     * Avatar Dropdown
     ********************************/
    $(".drop__action").on("click", function (e) {
        e.preventDefault();
        $(".dropdown__list").removeClass("active");
        $(this)
            .parents(".dropdown__btn")
            .find(".dropdown__list")
            .addClass("active");
    });

    $(document).on("click", function (e) {
        if (
            $(e.target).closest(".dropdown__btn").length === 0 &&
            $(e.target).closest(".drop__action").length === 0
        ) {
            $(".dropdown__list").removeClass("active");
        }
    });

    /*********************************
    /*  Banner Video Sound Control
    *********************************/

    $(document).ready(function () {
        // Initialize Swiper
        if ($(".banner__slider").length > 0) {
            const bannerSlider = new Swiper(".banner__slider", {
                direction: "horizontal",
                loop: true,
                grabCursor: true,
                slidesPerView: 1,
                spaceBetween: 20,
                speed: 500,
                effect: "fade",
                centeredSlides: true,
                freeMode: false,
                autoplay: {
                    enabled: false, // Turn off default autoplay
                },
                navigation: {
                    nextEl: ".banner-swipe-next",
                    prevEl: ".banner-swipe-prev",
                },
                pagination: {
                    el: ".swiper-pagination",
                },
                on: {
                    slideChange: function () {
                        // Pause all videos when slide changes
                        $("video").each(function () {
                            this.pause();
                            this.muted = true; // Mute all videos on slide change
                            $(this)
                                .closest(".swiper-slide")
                                .find(".btn-mute")
                                .addClass("muted"); // Add muted class to mute button
                        });

                        // Play the active video and unmute it
                        var activeSlide = this.slides[this.activeIndex];
                        var activeVideo = $(activeSlide).find("video")[0];
                        if (activeVideo) {
                            activeVideo.play();
                            activeVideo.muted = true; // Unmute the active video
                        }
                    },
                },
            });

            // Handle mute button click
            $(".btn-mute").click(function () {
                var videoId = $(this).attr("id").replace("btn-mute", "video");
                var videoElement = document.getElementById(videoId);
                if (videoElement) {
                    // Toggle mute on video
                    videoElement.muted = !videoElement.muted;
                    $(this).toggleClass("muted", videoElement.muted); // Optionally toggle class to show mute state
                }
            });

            // Initialize all videos to be muted and paused
            $("video").each(function () {
                this.muted = true; // Mute the video initially
                this.pause(); // Ensure video is paused initially
            });

            // Play the video of the initial active slide and unmute it
            var initialSlide = bannerSlider.slides[bannerSlider.activeIndex];
            var initialVideo = $(initialSlide).find("video")[0];
            if (initialVideo) {
                initialVideo.play(); // Start playing the active slide video
                initialVideo.muted = true; // Unmute the active slide video
            }
        }
    });

    // document.addEventListener("DOMContentLoaded", function () {
    // 	// Function to initialize video controls (mute/unmute functionality)
    // 	function initializeVideoControls(videoSelector, btnMuteSelector) {
    // 		const video = document.querySelector(videoSelector);
    // 		const btnMute = document.querySelector(btnMuteSelector);

    // 		if (!video || !btnMute) return; // Ensure video and button exist

    // 		// Ensure the video starts paused and unmuted
    // 		video.muted = false;
    // 		video.pause(); // Start video in paused state

    // 		// Function to update the mute button's appearance
    // 		const updateButtonStatus = () => {
    // 			btnMute.classList.toggle("muted", video.paused || video.muted);
    // 		};

    // 		// Toggle play/pause and mute/unmute on button click
    // 		btnMute.addEventListener("click", () => {
    // 			if (video.paused) {
    // 				video.play();
    // 				video.muted = false; // Unmute when playing
    // 			} else {
    // 				video.pause();
    // 				video.muted = true; // Mute when paused
    // 			}
    // 			updateButtonStatus();
    // 		});

    // 		// Listen to video state changes and update button status
    // 		video.addEventListener("play", updateButtonStatus);
    // 		video.addEventListener("pause", updateButtonStatus);
    // 		video.addEventListener("volumechange", updateButtonStatus);

    // 		// Initialize button state
    // 		updateButtonStatus();
    // 	}

    // 	// Function to control video playback on the active slide
    // 	function handleSlideChange(sliderInstance) {
    // 		const slides = document.querySelectorAll(".swiper-slide");

    // 		slides.forEach((slide, index) => {
    // 			const video = slide.querySelector("video");
    // 			if (video) {
    // 				if (index === sliderInstance.realIndex) {
    // 					video.play(); // Auto-play active slide video
    // 					video.muted = false; // Unmute active slide video
    // 				} else {
    // 					video.pause(); // Pause other slide videos
    // 					video.muted = true; // Mute inactive slide videos
    // 				}
    // 			}
    // 		});
    // 	}

    // 	// Initialize the banner slider with video controls
    // 	if ($(".banner__slider").length > 0) {
    // 		const bannerSlider = new Swiper(".banner__slider", {
    // 			direction: "horizontal",
    // 			loop: true,
    // 			grabCursor: true,
    // 			slidesPerView: 1,
    // 			spaceBetween: 20,
    // 			speed: 500,
    // 			effect: "fade",
    // 			centeredSlides: true,
    // 			freeMode: false,
    // 			autoplay: {
    // 				enabled: false, // Turn off default autoplay
    // 			},
    // 			navigation: {
    // 				nextEl: ".banner-swipe-next",
    // 				prevEl: ".banner-swipe-prev",
    // 			},
    // 			pagination: {
    // 				el: ".swiper-pagination",
    // 			},
    // 			on: {
    // 				init: function () {
    // 					handleSlideChange(this); // Ensure video on the first active slide is played
    // 				},
    // 				slideChange: function () {
    // 					handleSlideChange(this); // Ensure active slide video is played on slide change
    // 				},
    // 			},
    // 		});

    // 		// Trigger Swiper's initialization event manually to ensure initial video is played
    // 		bannerSlider.init();
    // 	}

    // 	// Initialize controls for multiple videos
    // 	initializeVideoControls("#video1", "#btn-mute1");
    // 	initializeVideoControls("#video2", "#btn-mute2");
    // 	initializeVideoControls("#video3", "#btn-mute3");
    // });

    /*********************************
    /*  Category Slider
    *********************************/
    if ($(".category__slider").length > 0) {
        var categorySlider = new Swiper(".category__slider", {
            loop: false,
            spaceBetween: 12,
            slidesPerView: "auto",
            autoplay: {
                enabled: false,
                delay: 3000,
            },
            navigation: {
                nextEl: ".category-swipe-next",
                prevEl: ".category-swipe-prev",
            },
            breakpoints: {
                300: {
                    slidesPerView: 2,
                },
                400: {
                    slidesPerView: 3,
                },
                479: {
                    slidesPerView: 5,
                },
                575: {
                    slidesPerView: 8,
                },
                767: {
                    slidesPerView: 10,
                },
                991: {
                    slidesPerView: 12,
                },
                1400: {
                    slidesPerView: 16,
                },
            },
        });
    }

    /*********************************
    /*  Movie Slider
    *********************************/
    if ($(".movie__slider").length > 0) {
        var movieSlider = new Swiper(".movie__slider", {
            loop: false,
            spaceBetween: 12,
            autoplay: {
                enabled: false,
                delay: 2500,
            },
            navigation: {
                nextEl: ".movie-swipe-next",
                prevEl: ".movie-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 3,
                },
                991: {
                    slidesPerView: 4,
                },
                1140: {
                    slidesPerView: 5,
                },
                1400: {
                    slidesPerView: 6,
                },
                1650: {
                    slidesPerView: 7,
                },
            },
        });
    }

    if ($(".movie__slider2").length > 0) {
        var movieSlider2 = new Swiper(".movie__slider2", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: false,
                delay: 2500,
            },
            navigation: {
                nextEl: ".movie-swipe-next",
                prevEl: ".movie-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 2.5,
                },
                991: {
                    slidesPerView: 3,
                },
                1140: {
                    slidesPerView: 3,
                },
                1400: {
                    slidesPerView: 5,
                },
                1650: {
                    slidesPerView: 5,
                },
            },
        });
    }

    /*********************************
   /*  Drama Slider
   *********************************/
    if ($(".drama__slider").length > 0) {
        var dramaSlider = new Swiper(".drama__slider", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".drama-swipe-next",
                prevEl: ".drama-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 2.5,
                },
                991: {
                    slidesPerView: 3,
                },
                1140: {
                    slidesPerView: 3,
                },
                1400: {
                    slidesPerView: 5,
                },
                1650: {
                    slidesPerView: 5,
                },
            },
        });
    }

    /*********************************
    /*  Blog Slider
    *********************************/
    if ($(".blog__slider").length > 0) {
        var blogSlider = new Swiper(".blog__slider", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".blog-swipe-next",
                prevEl: ".blog-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 2.5,
                },
                991: {
                    slidesPerView: 3,
                },
                1140: {
                    slidesPerView: 4,
                },
            },
        });
    }

    /*********************************
    /*  Release Slider
    *********************************/
    if ($(".release__slider").length > 0) {
        var releaseSlider = new Swiper(".release__slider", {
            loop: false,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 3000,
            },
            navigation: {
                nextEl: ".release-swipe-next",
                prevEl: ".release-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 3,
                },
                991: {
                    slidesPerView: 4,
                },
                1140: {
                    slidesPerView: 5,
                },
                1400: {
                    slidesPerView: 6,
                },
                1650: {
                    slidesPerView: 7,
                },
            },
        });
    }

    /*********************************
    /*  TV Show Slider
    *********************************/
    if ($(".tvShow__slider").length > 0) {
        var releaseSlider = new Swiper(".tvShow__slider", {
            loop: false,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".tvShow-swipe-next",
                prevEl: ".tvShow-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 3,
                },
                991: {
                    slidesPerView: 4,
                },
                1140: {
                    slidesPerView: 5,
                },
                1400: {
                    slidesPerView: 6,
                },
                1650: {
                    slidesPerView: 7,
                },
            },
        });
    }

    /*********************************
    /*  featureShow Thumb Slider Carousel
    *********************************/
    document.addEventListener("DOMContentLoaded", function () {
        var featureShowThumbs = new Swiper(".featureShow__thumb", {
            spaceBetween: 10,
            slidesPerView: 3,
            grabCursor: true,
            freeMode: false,
            slideToClickedSlide: true,
            breakpoints: {
                300: {
                    slidesPerView: 2,
                },
                479: {
                    slidesPerView: 3,
                },

            },
            autoplay: {
                enabled: false,
                delay: 3000,
            },
            watchSlidesProgress: true,

        });

        var featureShowSlider = new Swiper(".featureShow__slider", {
            spaceBetween: 10,
            slidesPerView: 1,
            speed: 500,
            // loop: true,
            grabCursor: true,
            effect: "fade",
            autoplay: {
                enabled: true,
                delay: 3000,
            },
            navigation: {
                nextEl: ".show-swipe-next",
                prevEl: ".show-swipe-prev",
            },
            thumbs: {
                swiper: featureShowThumbs,
            },
        });

    });

    /*********************************
    /*  Channel Slider
    *********************************/
    if ($(".channel__slider").length > 0) {
        var channelSlider = new Swiper(".channel__slider", {
            loop: false,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".channel-swipe-next",
                prevEl: ".channel-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 3,
                },
                991: {
                    slidesPerView: 4,
                },
                1140: {
                    slidesPerView: 5,
                },
                1400: {
                    slidesPerView: 6,
                },
                1650: {
                    slidesPerView: 7,
                },
            },
        });
    }

    /*********************************
    /*  Mega Movie Slider
    *********************************/
    if ($(".megaMovie__slider").length > 0) {
        var movieSlider = new Swiper(".megaMovie__slider", {
            loop: false,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 3000,
            },
            navigation: {
                nextEl: ".megMovie-swipe-next",
                prevEl: ".megMovie-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 3,
                },
                991: {
                    slidesPerView: 4,
                },
                1140: {
                    slidesPerView: 5,
                },
                1400: {
                    slidesPerView: 6,
                },
                1650: {
                    slidesPerView: 7,
                },
            },
        });
    }

    /*********************************
    /*  megaTvShow Slider
    *********************************/
    if ($(".megaTvShow__slider").length > 0) {
        var movieSlider = new Swiper(".megaTvShow__slider", {
            loop: false,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 3000,
            },
            navigation: {
                nextEl: ".megaTvShow-swipe-next",
                prevEl: ".megaTvShow-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1,
                },
                500: {
                    slidesPerView: 1,
                },
                640: {
                    slidesPerView: 1,
                },
                991: {
                    slidesPerView: 3,
                },
            },
        });
    }

    /*********************************
    /*  megaTrending__slider Slider
    *********************************/
    if ($(".megaTrending__slider").length > 0) {
        var movieSlider = new Swiper(".megaTrending__slider", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".megaTrending-swipe-next",
                prevEl: ".megaTrending-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1,
                },
                500: {
                    slidesPerView: 1,
                },
                640: {
                    slidesPerView: 1,
                },
                991: {
                    slidesPerView: 3,
                },
            },
        });
    }

    /*********************************
    /*  LiveTv Slider
    *********************************/
    if ($(".liveTv__slider").length > 0) {
        var movieSlider = new Swiper(".liveTv__slider", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".liveTv-swipe-next",
                prevEl: ".liveTv-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1,
                },
                500: {
                    slidesPerView: 1,
                },
                640: {
                    slidesPerView: 1,
                },
                991: {
                    slidesPerView: 3,
                },
            },
        });
    }

    /*********************************
 /*  Relared Movie Slider
 *********************************/
    if ($(".relatedmovie__slider").length > 0) {
        var relaredMovieSlider = new Swiper(".relatedmovie__slider", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".related-movie-swipe-next",
                prevEl: ".related-movie-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 2.5,
                },
                991: {
                    slidesPerView: 3,
                },
                1140: {
                    slidesPerView: 4,
                },
            },
        });
    }

    /*********************************
    /*  Recommended Movie Slider
    *********************************/
    if ($(".recommendedmovie__slider").length > 0) {
        var recommendedMovieSlider = new Swiper(".recommendedmovie__slider", {
            loop: true,
            spaceBetween: 12,
            autoplay: {
                enabled: true,
                delay: 2500,
            },
            navigation: {
                nextEl: ".recommended-movie-swipe-next",
                prevEl: ".recommended-movie-swipe-prev",
            },
            breakpoints: {
                400: {
                    slidesPerView: 1.5,
                },
                500: {
                    slidesPerView: 2,
                },
                640: {
                    slidesPerView: 2.5,
                },
                991: {
                    slidesPerView: 3,
                },
                1140: {
                    slidesPerView: 4,
                },
            },
        });
    }

    /*********************************
    /*  PopOver Js
    *********************************/

    $(document).ready(function () {
        // Initialize popovers with dynamic content
        $(".popOver__card").popover({
            placement: "auto",
            boundary: "window",
            trigger: window.innerWidth > 400 ? "hover" : "click", // Conditionally set trigger based on screen width
            delay: {
                show: 1000, // Delay of 1 second before showing the popover
            },
            html: true, // Allow HTML content inside the popover
            container: "body",
        });
    });

    /********************************
     * Filter Dropdown
     ********************************/
    $(".filter__dropdown .selected").on("click", function (e) {
        e.preventDefault();
        $(".filter__list").removeClass("active");
        $(this)
            .parents(".filter__dropdown")
            .find(".filter__list")
            .addClass("active");
    });

    $(document).on("click", function (e) {
        if (
            $(e.target).closest(".filter__dropdown").length === 0 &&
            $(e.target).closest(".filter__dropdown .selected").length === 0
        ) {
            $(".filter__list").removeClass("active");
        }
    });

    /*********************************
    /* Playlist Collapse Button
    *********************************/
    $(".more__btn").on("click", function () {
        var desc = $(this).prev(".desc");

        // Toggle the class to show full text or not
        desc.toggleClass("expanded");

        // Toggle the button text
        if (desc.hasClass("expanded")) {
            $(this).text("read less");
        } else {
            $(this).text("read more");
        }
    });

    /*********************************
    /* Playlist Collapse Button
    *********************************/
    // if ($(".collapse__btn").length > 0) {
    //     $(".collapse__btn").on("click", function () {
    //         $(this).find("i").toggleClass(" ri-subtract-line ri-add-line"); // Toggle icon class
    //         $(".playlist__single").slideToggle();
    //     });
    // }

    $(document).ready(function () {
        // Open the first playlist__single, close others
        $(".playlist__single").hide().first().show();

        // Toggle playlist accordion
        $(".collapse__btn").on("click", function () {
            const $currentArea = $(this).closest(".playlist__area");
            const $currentContent = $currentArea.find(".playlist__single");
            const isOpen = $currentContent.is(":visible");

            // Reset all icons and hide all playlist__single
            $(".collapse__btn i").removeClass("ri-subtract-line").addClass("ri-add-line");
            $(".playlist__single").slideUp();

            if (!isOpen) {
                // Open the clicked one
                $currentContent.slideDown();
                $(this).find("i").removeClass("ri-add-line").addClass("ri-subtract-line");
            }
        });
    });



    /*********************************
    /* Price Range Slider
    *********************************/
    // if ($("#slider-range").length > 0) {
    //     $("#slider-range").slider({
    //         // range: 'min',
    //         range: true,
    //         min: 0,
    //         max: 10,
    //         values: [2, 8],
    //         slide: function (event, ui) {
    //             $(".mincount").html(ui.values[0]);
    //             $(".maxcount").html(ui.values[1]);
    //         },
    //     });
    //     $(".mincount").html($("#slider-range").slider("values", 0));
    //     $(".maxcount").html($("#slider-range").slider("values", 1));
    // }

    /**********************************
     *  Options for the player
     **********************************/
    document.addEventListener("DOMContentLoaded", function () {
        const plyrOptions = {
            autoplay: false,
            muted: false,
            controls: [
                "play",
                "play-large",
                "progress",
                "current-time",
                "mute",
                "volume",
                "settings",
                "fullscreen",
                "pip",
                "quality",
                "speed",
                "captions",
                "currentTrack",
            ],
            settings: ["captions", "quality", "speed"],
        };

        const player = new Plyr("#plyr-video", plyrOptions);
    });

    /**********************************
     *  Back to Top JS
     **********************************/
    $("body").append(
        '<div id="toTop" class="back__icon"><i class="ri-arrow-up-double-line"></i></div>'
    );
    $(window).on("scroll", function () {
        if ($(this).scrollTop() != 0) {
            $("#toTop").addClass("active");
        } else {
            $("#toTop").removeClass("active");
        }
    });
    $("#toTop").on("click", function () {
        $("html, body").animate({ scrollTop: 0 }, 0);
        return false;
    });

    /*********************************
     * feature movie slider
     **********************************/
    document.addEventListener("DOMContentLoaded", function () {
        // Initialize Swiper with centered slides
        const swiper = new Swiper(".featureMovie__slider", {
            spaceBetween: 20,
            loop: true,
            // slidesPerView: 2, // Try an odd number
            centeredSlides: true,
            effect: "coverflow",
            coverflow: {
                rotate: 0,
                stretch: 0,
                depth: 0, // Increase this value
                modifier: 5, // Increase modifier for stronger effect
                slideShadows: false,
            },
            autoplay: {
                enabled: true,
                delay: 10000,
            },
            navigation: {
                nextEl: ".featureMovie-swipe-next",
                prevEl: ".featureMovie-swipe-prev",
            },
            pagination: {
                el: ".featureMovie-pagination",
            },
            breakpoints: {
                300: {
                    slidesPerView: 1,
                },
                400: {
                    slidesPerView: 1,
                },
                479: {
                    slidesPerView: 1,
                },
                575: {
                    slidesPerView: 1,
                },
                767: {
                    slidesPerView: 1,
                },
                991: {
                    slidesPerView: 2,
                },
                1400: {
                    slidesPerView: 2,
                },
            },
            on: {
                slideChange: function () {
                    // Pause all videos and clear timeouts
                    document.querySelectorAll(".video__background").forEach((video) => {
                        video.pause();
                        if (video.timeoutId) {
                            clearTimeout(video.timeoutId);
                            video.timeoutId = null;
                        }

                        const overlay = video.closest(".swiper-slide")?.querySelector(".countdown__overlay");
                        if (overlay) overlay.style.display = "none";
                    });

                    // Get current video element
                    const currentSlide = this.slides[this.activeIndex];
                    const currentVideo = currentSlide.querySelector(".video__background");

                    // Only run countdown if video exists
                    if (currentVideo) {
                        const countdown = currentVideo.closest(".swiper-slide").querySelector(".countdown__overlay");
                        countdown.style.display = "flex";

                        let seconds = 3;
                        countdown.textContent = seconds;

                        const countdownInterval = setInterval(() => {
                            seconds--;
                            countdown.textContent = seconds;

                            if (seconds <= 0) {
                                clearInterval(countdownInterval);
                                countdown.style.display = "none";
                                currentVideo.play().catch((error) => {
                                    console.error("Video playback failed:", error);
                                });
                            }
                        }, 1000);

                        currentVideo.timeoutId = countdownInterval;
                    }
                },
                init: function () {
                    // Initialize all videos with posters showing first
                    document.querySelectorAll(".video__background").forEach((video, index) => {
                        video.pause();
                        video.currentTime = 0;
                        video.muted = true; // Start muted by default

                        // Initialize mute button
                        const muteBtn = video.closest(".swiper-slide").querySelector(".mute__btn");
                        const volumeIcon = muteBtn.querySelector("i");
                        volumeIcon.className = video.muted ? "ri-volume-mute-fill" : "ri-volume-up-fill";

                        // Only start countdown for first video
                        if (index === 0) {
                            const countdown = video.closest(".swiper-slide").querySelector(".countdown__overlay");
                            countdown.style.display = "flex";

                            let seconds = 3;
                            countdown.textContent = seconds;

                            const countdownInterval = setInterval(() => {
                                seconds--;
                                countdown.textContent = seconds;

                                if (seconds <= 0) {
                                    clearInterval(countdownInterval);
                                    countdown.style.display = "none";
                                    video.play().catch((error) => {
                                        console.error("Video playback failed:", error);
                                    });
                                }
                            }, 1000);

                            video.timeoutId = countdownInterval;
                        }
                    });
                },
            },
        });

        // Initialize mute buttons
        document.querySelectorAll(".mute__btn").forEach((btn) => {
            const video = btn.closest(".swiper-slide").querySelector(".video__background");

            btn.addEventListener("click", () => {
                video.muted = !video.muted;
                const icon = btn.querySelector("i");
                icon.className = video.muted ? "ri-volume-mute-fill" : "ri-volume-up-fill";
            });
        });

        // Handle video ending to move to next slide
        document.querySelectorAll(".video__background").forEach((video, index) => {
            video.addEventListener("ended", () => {
                if (index < document.querySelectorAll(".swiper-slide").length - 1) {
                    swiper.slideNext();
                } else {
                    video.currentTime = 0;
                    video.play();
                }
            });
        });
    });

})(jQuery);


