<?php

namespace Database\Seeders;

use App\Models\Season;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SeasonSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $seasons = [
            ['season_name' => 'Season 01', 'order' => 1, 'status' => 1],
            ['season_name' => 'Season 02', 'order' => 2, 'status' => 1],
            ['season_name' => 'Season 03', 'order' => 3, 'status' => 1],
            ['season_name' => 'Season 04', 'order' => 4, 'status' => 1],
            ['season_name' => 'Season 05', 'order' => 5, 'status' => 1],
            ['season_name' => 'Season 06', 'order' => 6, 'status' => 1],
            ['season_name' => 'Season 07', 'order' => 7, 'status' => 1],
            ['season_name' => 'Season 08', 'order' => 8, 'status' => 1],
            ['season_name' => 'Season 09', 'order' => 9, 'status' => 1],
            ['season_name' => 'Season 10', 'order' => 10, 'status' => 1],
        ];

        foreach ($seasons as $season) {
            Season::create([
                'season_name' => $season['season_name'],
                'order' => $season['order'],
                'slug' => slugify($season['season_name']),
                'status' => $season['status'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
