<?php

namespace Database\Seeders;

use App\Models\Ads;
use App\Models\Category;
use App\Models\Config;
use App\Models\Interest;
use App\Models\Language;
use App\Models\LiveTvCategory;
use App\Models\MovieIndustry;
use App\Models\MovieLanguage;
use App\Models\Package;
use App\Models\PlanCredential;
use App\Models\VideoQuality;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            UserSeeder::class,
            TimeZoneSeeder::class,
            FlagSeeder::class,
            CurrencySeeder::class,
            CountrySeeder::class,
            SeasonSeeder::class,
            DemoDataSeeder::class,
        ]);

        MovieLanguage::create(['name' => 'Bangla', 'slug' => 'bangla', 'description' => '', 'status' => 1]);
        MovieLanguage::create(['name' => 'English', 'slug' => 'english', 'description' => '', 'status' => 1]);
        MovieLanguage::create(['name' => 'Arabic', 'slug' => 'arabic', 'description' => '', 'status' => 1]);
        MovieLanguage::create(['name' => 'Spanish', 'slug' => 'spanish', 'description' => '', 'status' => 1]);

        Category::create(['video_type' => 'Comedy', 'slug' => 'comedy']);
        Category::create(['video_type' => 'Drama', 'slug' => 'drama']);
        Category::create(['video_type' => 'Action', 'slug' => 'action']);
        Category::create(['video_type' => 'Romance', 'slug' => 'romance']);
        Category::create(['video_type' => 'Thriller', 'slug' => 'thriller']);
        Category::create(['video_type' => 'Sports', 'slug' => 'sports']);
        Category::create(['video_type' => 'Sci-Fi', 'slug' => 'sci-Fi']);
        Category::create(['video_type' => 'Horror', 'slug' => 'horror']);

        VideoQuality::create(['status' => 1, 'quality' => 'SD', 'description' => 'Standard Definition']);
        VideoQuality::create(['status' => 1, 'quality' => 'HD', 'description' => 'High Definition']);
        VideoQuality::create(['status' => 1, 'quality' => 'Full HD', 'description' => 'High Definition']);
        VideoQuality::create(['status' => 1, 'quality' => '2K', 'description' => '']);
        VideoQuality::create(['status' => 1, 'quality' => 'UHD/4K', 'description' => 'Ultra High Definition']);
        VideoQuality::create(['status' => 1, 'quality' => '8K', 'description' => '']);

        Language::create(['name' => 'English', 'locale' => 'en', 'flag' => 'images/flags/us.png', 'text_direction' => 'ltr', 'status' => 1]);
        Language::create(['name' => 'Bangla', 'locale' => 'bd', 'flag' => 'images/flags/bd.png', 'text_direction' => 'ltr', 'status' => 1]);

        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'News', 'slug' => 'news']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Music', 'slug' => 'music']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Comedy', 'slug' => 'comedy']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Drama', 'slug' => 'drama']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Comedy Drama', 'slug' => 'comedy-drama']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Teen Drama', 'slug' => 'teen-drama']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Teen Drama', 'slug' => 'teen-drama']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Romantic Drama', 'slug' => 'romantic-drama']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Political Drama', 'slug' => 'political-drama']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Movie', 'slug' => 'movie']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Entertainment', 'slug' => 'entertainment']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Factual', 'slug' => 'factual']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Sports', 'slug' => 'sports']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Sci-Fi', 'slug' => 'sci-Fi']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Animated', 'slug' => 'animated']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Mokumentary', 'slug' => 'mokumentary']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Telenovela', 'slug' => 'telenovela']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'TV Documentary', 'slug' => 'tv-documentary']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Streaming TV', 'slug' => 'streaming-tv']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Soap Opera', 'slug' => 'soap-opera']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Reality TV', 'slug' => 'reality-tv']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Sitcom', 'slug' => 'sitcom']);
        LiveTvCategory::create(['live_tv_category_desc' => '', 'live_tv_category' => 'Horror', 'slug' => 'horror']);

        Package::create(['price_id' => 'price_id', 'name' => 'Basic', 'day' => 7, 'screens' => 3, 'type' => 'monthly', 'price' => 200, 'status' => 1]);
        Package::create(['price_id' => 'price_id', 'name' => 'Professional ', 'day' => 14, 'screens' => 5, 'type' => 'monthly', 'price' => 300, 'status' => 1]);
        Package::create(['price_id' => 'price_id', 'name' => 'Ultra ', 'day' => 28, 'screens' => 8, 'type' => 'monthly', 'price' => 500, 'status' => 1]);

        Ads::create(['title' => 'Movie details sidebar one', 'type' => 'local', 'size' => '300x250', 'size' => '300x250', 'position' => 'movie_details_sidebar_1', 'start_date' => '2025-07-01T15:12', 'end_date' => '2026-07-01T15:12', 'redirect_url' => '#', 'banner' => '{"storage":"local","original_image":"images/default.jpg"}', 'status' => 1]);
        Ads::create(['title' => 'Movie details sidebar two', 'type' => 'local', 'size' => '300x600', 'position' => 'movie_details_sidebar_2', 'start_date' => '2025-07-01T15:12', 'end_date' => '2026-07-01T15:12', 'redirect_url' => '#', 'banner' => '{"storage":"local","original_image":"images/default.jpg"}', 'status' => 1]);
        Ads::create(['title' => 'Home page promotional left', 'type' => 'local', 'size' => '300x250', 'position' => 'home_page_promotional_left', 'start_date' => '2025-07-01T15:12', 'end_date' => '2026-07-01T15:12', 'redirect_url' => '#', 'banner' => '{"storage":"local","original_image":"images/default.jpg"}', 'status' => 1]);
        Ads::create(['title' => 'Home page promotional right', 'type' => 'local', 'size' => '300x250', 'position' => 'home_page_promotional_right', 'start_date' => '2025-07-01T15:12', 'end_date' => '2026-07-01T15:12', 'redirect_url' => '#', 'banner' => '{"storage":"local","original_image":"images/default.jpg"}', 'status' => 1]);
        Ads::create(['title' => 'Movie details middle', 'type' => 'local', 'size' => '728x90', 'position' => 'movie_details_middle', 'start_date' => '2025-07-01T15:12', 'end_date' => '2026-07-01T15:12', 'redirect_url' => '#', 'banner' => '{"storage":"local","original_image":"images/default.png"}', 'status' => 1]);
        Ads::create(['title' => 'Footer', 'type' => 'local', 'size' => '728x90', 'position' => 'footer', 'start_date' => '2025-07-01T15:12', 'end_date' => '2026-07-01T15:12', 'redirect_url' => '#', 'banner' => '{"storage":"local","original_image":"images/default.png"}', 'status' => 1]);


        Config::create(['lang' => 'en', 'title' => 'system_name', 'value' => 'Flixoo',]);
        Config::create(['lang' => 'en', 'title' => 'default_time_zone', 'value' => 1]);
        Config::create(['lang' => 'en', 'title' => 'default_currency', 'value' => 97]);
        Config::create(['lang' => 'en', 'title' => 'currency_symbol', 'value' => 97]);
        Config::create(['lang' => 'en', 'title' => 'default_language', 'value' => 1]);
        Config::create(['lang' => 'en', 'title' => 'currency_symbol_position', 'value' => 'left',]);
        Config::create(['lang' => 'en', 'title' => 'exchange_rate', 'value' => '1',]);
        Config::create(['lang' => 'en', 'title' => 'system_email', 'value' => 'admin@spagreen.net',]);
        Config::create(['lang' => 'en', 'title' => 'business_address', 'value' => 'Dhaka, Bangladesh',]);
        Config::create(['lang' => 'en', 'title' => 'business_phone', 'value' => '+8801400620055',]);
        Config::create(['lang' => 'en', 'title' => 'contact_email', 'value' => 'contact@spagreen.net',]);
        Config::create(['lang' => 'en', 'title' => 'registration_enable', 'value' => 0,]);
        Config::create(['lang' => 'en', 'title' => 'google_recaptcha', 'value' => 0,]);
        Config::create(['lang' => 'en', 'title' => 'recaptcha_site_key', 'value' => 'Recaptcha site key',]);
        Config::create(['lang' => 'en', 'title' => 'recaptcha_secret_key', 'value' => 'Recaptcha secret key',]);
        Config::create(['lang' => 'en', 'title' => 'tmdb_default_language', 'value' => 'english',]);
        Config::create(['lang' => 'en', 'title' => 'tmdb_api_key', 'value' => 'Api key',]);

        Config::create(['lang' => 'en', 'title' => 'android_tv_btn_link', 'value' => 'https://example.com',]);
        Config::create(['lang' => 'en', 'title' => 'show_android_tv_btn_banner', 'value' => 1,]);
        Config::create(['lang' => 'en', 'title' => 'android_device_btn_link', 'value' => 'https://example.com',]);
        Config::create(['lang' => 'en', 'title' => 'show_android_device_btn_banner', 'value' => 1,]);
        Config::create(['lang' => 'en', 'title' => 'apple_device_btn_link', 'value' => 'https://example.com',]);
        Config::create(['lang' => 'en', 'title' => 'show_apple_device_btn_banner', 'value' => 1,]);

        Config::create(['lang' => 'en', 'title' => 'show_social_links', 'value' => 1,]);
        Config::create(['lang' => 'en', 'title' => 'facebook_link', 'value' => 'https://facebook.com',]);
        Config::create(['lang' => 'en', 'title' => 'twitter_link', 'value' => 'https://twitter.com',]);
        Config::create(['lang' => 'en', 'title' => 'instagram_link', 'value' => 'https://instagram.com',]);
        Config::create(['lang' => 'en', 'title' => 'pinterest_link', 'value' => 'https://pinterest.com',]);
        Config::create(['lang' => 'en', 'title' => 'linkedin_link', 'value' => 'https://linkedin.com',]);

        Config::create(['lang' => 'en', 'title' => 'show_copyright', 'value' => 1,]);
        Config::create(['lang' => 'en', 'title' => 'copyright_title', 'value' => 'Copyright ©SpaGreen 2025',]);

        Config::create(['lang' => 'en', 'title' => 'show_payment_method_banner', 'value' => 1,]);
        Config::create(['lang' => 'en', 'title' => 'payment_method_banner', 'value' => '{"storage":"local","original_image":"https://placehold.co/310x30"}',]);

        Config::create(['lang' => 'en', 'title' => 'high_lighted_text', 'value' => 'Your movie site could offer comprehensive film information, reviews, and ratings.',]);
        Config::create(['lang' => 'en', 'title' => 'show_help_center_links', 'value' => 1]);
        Config::create(['lang' => 'en', 'title' => 'faqs_link', 'value' => url('faqs'),]);
        Config::create(['lang' => 'en', 'title' => 'contact_link', 'value' => url('contact-us')]);
        Config::create(['lang' => 'en', 'title' => 'promotion', 'value' => '{"storage":"local","original_image":"images/bg.jpg"}']);
        Config::create(['lang' => 'en', 'title' => 'version_code', 'value' => '"1.0.0"']);
        Config::create(['lang' => 'en', 'title' => 'current_version', 'value' => '"100"']);
        Config::create(['lang' => 'en', 'title' => 'paginate', 'value' => '"10"']);
        Config::create(['lang' => 'en', 'title' => 'openai_secret_key', 'value' => 'Your api key here']);

        Config::create(['lang' => 'en', 'title' => 'light_logo', 'value' => '{"storage":"local","original_image":"images/default/logo/logo.png"}']);
        Config::create(['lang' => 'en', 'title' => 'favicon', 'value' => '{"storage":"local","original_image":"images/default/logo/logo-mini.png"}']);

        MovieIndustry::create(['name' => 'Bollywood', 'country_id' => 75, 'status' => 1]);
        MovieIndustry::create(['name' => 'Hollywood', 'country_id' => 184, 'status' => 1]);
        MovieIndustry::create(['name' => 'Tollywood', 'country_id' => 75, 'status' => 1]);
        MovieIndustry::create(['name' => 'Japan', 'country_id' => 84, 'status' => 1]);
        MovieIndustry::create(['name' => 'Chinese cinema', 'country_id' => 36, 'status' => 1]);
        MovieIndustry::create(['name' => 'South Korea', 'country_id' => 60, 'status' => 1]);

        Interest::create(['title' => 'Action', 'status' => 1]);
        Interest::create(['title' => 'Drama', 'status' => 1]);
        Interest::create(['title' => 'Cartoon', 'status' => 1]);
        Interest::create(['title' => 'Animation', 'status' => 1]);
        Interest::create(['title' => 'Fiction', 'status' => 1]);
        Interest::create(['title' => 'Non-Fiction', 'status' => 1]);
        Interest::create(['title' => 'Novel', 'status' => 1]);
        Interest::create(['title' => 'Science fiction', 'status' => 1]);


        PlanCredential::create([
            'plan_id' => 2,
            'title'   => 'stripe',
            'value'   => 'price_1OmLoXJUxq2pPEOHfvBIVgmt',
        ]);

        PlanCredential::create([
            'plan_id' => 3,
            'title'   => 'stripe',
            'value'   => 'price_1Ol70AJUxq2pPEOH9iYo69nr',
        ]);
        PlanCredential::create([
            'plan_id' => 5,
            'title'   => 'stripe',
            'value'   => 'price_1OmLq4JUxq2pPEOHJiIwCcTP',
        ]);
        PlanCredential::create([
            'plan_id' => 6,
            'title'   => 'stripe',
            'value'   => 'price_1OmK7ZJUxq2pPEOHiAgV690p',
        ]);
        PlanCredential::create([
            'plan_id' => 6,
            'title'   => 'paddle',
            'value'   => 'pri_01hq5k3xh0qag89kq0fd6x0yyg',
        ]);
        PlanCredential::create([
            'plan_id' => 6,
            'title'   => 'paypal',
            'value'   => 'P-3D044458N8455713HMWGAJII',
        ]);

    }
}
